/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Type;

public class NameType
extends Type {
    private Name name;

    public NameType(Name name, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.name = name;
        name.setParent(this);
    }

    public Name getName() {
        return this.name;
    }

    @Override
    public int getKind() {
        return 0;
    }

    @Override
    public boolean isNameType() {
        return true;
    }

    @Override
    public ITypeBinding resolveTypeBinding() {
        IBinding binding = this.name.resolveBinding();
        if (binding == IBinding.NOT_FOUND_BINDING || binding == null) {
            return null;
        }
        return binding.isTypeBinding() ? (ITypeBinding)binding : null;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.name.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public String getCanonicalName() {
        return this.name.getCanonicalName();
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new NameType((Name)this.name.clone(), this.getOffset(), this.getOffset() + this.getLength());
    }

    @Override
    public Type getBaseType() {
        return this;
    }
}

