/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.Stack;
import java_cup.runtime.Symbol;
import org.eclipse.edt.compiler.core.ast.ITokenStream;
import org.eclipse.edt.compiler.core.ast.NonTerminal;
import org.eclipse.edt.compiler.core.ast.ParseTable;
import org.eclipse.edt.compiler.core.ast.StackSymbol;
import org.eclipse.edt.compiler.core.ast.Terminal;

public class ParseStack
extends ParseTable {
    protected StackSymbol[] stack = new StackSymbol[128];
    private int stackTop;

    public ParseStack() {
    }

    public ParseStack(Stack realStack, boolean[] isNonTerminal) {
        this.stackTop = realStack.size() - 1;
        Symbol[] symbols = realStack.toArray(new Symbol[realStack.size()]);
        int i = 0;
        while (i < symbols.length) {
            Symbol symbol = symbols[i];
            if (isNonTerminal[i]) {
                try {
                    this.stack[i] = new NonTerminal(symbol.sym, symbol.left, symbol.right, symbol.parse_state);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.enlargeStack();
                    this.stack[i] = new NonTerminal(symbol.sym, symbol.left, symbol.right, symbol.parse_state);
                }
            } else {
                try {
                    this.stack[i] = new Terminal(symbol.sym, symbol.left, symbol.right, symbol.parse_state);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.enlargeStack();
                    this.stack[i] = new Terminal(symbol.sym, symbol.left, symbol.right, symbol.parse_state);
                }
            }
            ++i;
        }
    }

    public void sync(boolean[] isNonTerminal) {
        int i = 0;
        while (i <= this.stackTop) {
            isNonTerminal[i] = this.stack[i].isNonTerminal();
            ++i;
        }
    }

    public void shiftStartState() {
        this.stack[this.stackTop] = new NonTerminal(0, 0, 0, 0);
    }

    public ParseStack createCopy() {
        ParseStack clone = new ParseStack();
        clone.stack = new StackSymbol[this.stack.length];
        System.arraycopy(this.stack, 0, clone.stack, 0, this.stack.length);
        clone.stackTop = this.stackTop;
        return clone;
    }

    public boolean processLookAhead(Terminal lookAhead) {
        block6: {
            short lhs_sym_num;
            do {
                short action;
                if ((action = this.get_action(this.stack[this.stackTop].parseState, lookAhead.symbolType)) > 0) {
                    lookAhead.parseState = action - 1;
                    ++this.stackTop;
                    try {
                        this.stack[this.stackTop] = lookAhead;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        this.enlargeStack();
                        this.stack[this.stackTop] = lookAhead;
                    }
                    return true;
                }
                if (action >= 0) break block6;
                lhs_sym_num = production_tab[-action - 1][0];
                short handle_size = production_tab[-action - 1][1];
                int right = this.stack[this.stackTop].right;
                this.stackTop -= handle_size;
                int left = handle_size == 0 ? this.stack[this.stackTop].right : this.stack[this.stackTop + 1].left;
                short newState = this.get_reduce(this.stack[this.stackTop].parseState, lhs_sym_num);
                NonTerminal nonTerminal = new NonTerminal(lhs_sym_num, left, right, newState);
                ++this.stackTop;
                try {
                    this.stack[this.stackTop] = nonTerminal;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.enlargeStack();
                    this.stack[this.stackTop] = nonTerminal;
                }
            } while (lhs_sym_num != 0);
            return true;
        }
        return false;
    }

    public int getHighestNonTerminal(int lookAheadTerminalType) {
        if (this.get_action(this.stack[this.stackTop].parseState, lookAheadTerminalType) == 0) {
            int i = 0;
            while (i < ParseTable.SCOPE_CLOSERS.length) {
                if (this.get_action(this.stack[this.stackTop].parseState, ParseTable.SCOPE_CLOSERS[i]) != 0) {
                    lookAheadTerminalType = ParseTable.SCOPE_CLOSERS[i];
                    break;
                }
                ++i;
            }
        }
        while (true) {
            int left;
            short action;
            if ((action = this.get_action(this.stack[this.stackTop].parseState, lookAheadTerminalType)) > 0) {
                return this.stack[this.stackTop].symbolType;
            }
            if (action >= 0) break;
            short lhs_sym_num = production_tab[-action - 1][0];
            short handle_size = production_tab[-action - 1][1];
            if (handle_size != 1) {
                return this.stack[this.stackTop].symbolType;
            }
            int right = this.stack[this.stackTop].right;
            this.stackTop -= handle_size;
            try {
                left = handle_size == 0 ? this.stack[this.stackTop].right : this.stack[this.stackTop + 1].left;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.enlargeStack();
                left = handle_size == 0 ? this.stack[this.stackTop].right : this.stack[this.stackTop + 1].left;
            }
            short newState = this.get_reduce(this.stack[this.stackTop].parseState, lhs_sym_num);
            NonTerminal nonTerminal = new NonTerminal(lhs_sym_num, left, right, newState);
            ++this.stackTop;
            try {
                this.stack[this.stackTop] = nonTerminal;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.enlargeStack();
                this.stack[this.stackTop] = nonTerminal;
            }
        }
        return this.stack[this.stackTop].symbolType;
    }

    public boolean canShiftNonTerminal(int nonTerminalType, int terminalType) {
        while (true) {
            int currentState;
            if (this.get_reduce(currentState = this.stack[this.stackTop].parseState, nonTerminalType) != -1) {
                return true;
            }
            short action = this.get_action(this.stack[this.stackTop].parseState, terminalType);
            if (action > 0) {
                Terminal terminal = new Terminal(terminalType, -1, -1, action - 1);
                ++this.stackTop;
                try {
                    this.stack[this.stackTop] = terminal;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.enlargeStack();
                    this.stack[this.stackTop] = terminal;
                }
                continue;
            }
            if (action >= 0) break;
            short lhs_sym_num = production_tab[-action - 1][0];
            short handle_size = production_tab[-action - 1][1];
            int right = this.stack[this.stackTop].right;
            this.stackTop -= handle_size;
            int left = handle_size == 0 ? this.stack[this.stackTop].right : this.stack[this.stackTop + 1].left;
            short newState = this.get_reduce(this.stack[this.stackTop].parseState, lhs_sym_num);
            NonTerminal nonTerminal = new NonTerminal(lhs_sym_num, left, right, newState);
            ++this.stackTop;
            try {
                this.stack[this.stackTop] = nonTerminal;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.enlargeStack();
                this.stack[this.stackTop] = nonTerminal;
            }
        }
        return false;
    }

    public boolean canShift(Terminal lookAhead) {
        return this.createCopy().processLookAhead(lookAhead);
    }

    public Terminal undoLastTerminal() {
        if (this.stack[this.stackTop].isNonTerminal()) {
            return null;
        }
        Terminal terminal = (Terminal)this.stack[this.stackTop--];
        terminal = new Terminal(terminal.symbolType, terminal.left, terminal.right, terminal.parseState);
        while (this.stackTop != 0 && this.stack[this.stackTop].left == this.stack[this.stackTop].right) {
            --this.stackTop;
        }
        this.breakRightEdge();
        return terminal;
    }

    public int getCurrentState() {
        return this.stack[this.stackTop].parseState;
    }

    public int parseCheck(ITokenStream tokenStream) {
        return this.parseCheck(tokenStream, tokenStream.getCacheCapcity());
    }

    /*
     * Unable to fully structure code
     */
    public int parseCheck(ITokenStream tokenStream, int maximumDistance) {
        distance = 0;
        if (tokenStream.peekLookAhead((int)0).symbolType != 0 || !this.stack[this.stackTop].isTerminal() || this.stack[this.stackTop].symbolType != 0) ** GOTO lbl8
        return maximumDistance;
lbl-1000:
        // 1 sources

        {
            this.processLookAhead(tokenStream.peekLookAhead(distance++));
            if (tokenStream.peekLookAhead((int)(distance - 1)).symbolType != 0) continue;
            return maximumDistance;
lbl8:
            // 2 sources

            ** while (distance < maximumDistance && this.canShift((Terminal)tokenStream.peekLookAhead((int)distance)))
        }
lbl9:
        // 1 sources

        if (distance == maximumDistance) {
            return distance;
        }
        newTokenStream = tokenStream.createTokenStreamAtOffset(distance);
        furthestDistance = 0;
        i = 0;
        while (i < ParseTable.SCOPE_CLOSERS.length) {
            scopeCloser = new Terminal(ParseTable.SCOPE_CLOSERS[i], -1, -1, -1);
            if (this.canShift(scopeCloser)) {
                newStack = this.createCopy();
                newStack.processLookAhead(scopeCloser);
                newDistance = newStack.parseCheck(newTokenStream, maximumDistance - distance) - 2;
                if (newDistance > furthestDistance) {
                    furthestDistance = newDistance;
                }
            }
            ++i;
        }
        return distance + furthestDistance;
    }

    public void processNonTerminal(int nonTerminalType) {
        int currentState = this.getCurrentState();
        short gotoState = this.get_reduce(currentState, nonTerminalType);
        NonTerminal nonTerminal = new NonTerminal(nonTerminalType, this.stack[this.stackTop].right, this.stack[this.stackTop].right, gotoState);
        ++this.stackTop;
        try {
            this.stack[this.stackTop] = nonTerminal;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.enlargeStack();
            this.stack[this.stackTop] = nonTerminal;
        }
    }

    public void breakRightEdge() {
        StackSymbol symbol = this.stack[this.stackTop];
        if (symbol.isTerminal()) {
            return;
        }
        NonTerminal nonTerminal = (NonTerminal)symbol;
        if (nonTerminal.symbolType == 150) {
            short newState = this.get_reduce(this.stack[this.stackTop - 1].parseState, 151);
            this.stack[this.stackTop] = new NonTerminal(151, nonTerminal.left, nonTerminal.right, newState);
        }
    }

    public void dumpStackUntil(int nonTerminalType, int terminalType) {
        while (this.stackTop > 0) {
            int currentState = this.stack[this.stackTop].parseState;
            if (this.get_reduce(currentState, nonTerminalType) != -1) {
                return;
            }
            if (this.get_action(currentState, terminalType) != 0 && this.createCopy().canShiftNonTerminal(nonTerminalType, terminalType)) {
                return;
            }
            --this.stackTop;
        }
    }

    public int getStackRightEdge() {
        return this.stack[this.stackTop].right;
    }

    public int getStackLeftEdge() {
        return this.stack[this.stackTop].left;
    }

    public void pop() {
        --this.stackTop;
    }

    public boolean isEmpty() {
        return this.stackTop == 0;
    }

    public int getStackTop() {
        return this.stackTop;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i <= this.stackTop) {
            buffer.append(this.stack[i].toString());
            buffer.append(" ");
            ++i;
        }
        return buffer.toString();
    }

    private void enlargeStack() {
        StackSymbol[] newStack = new StackSymbol[this.stack.length * 2];
        System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
        this.stack = newStack;
    }
}

