/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.Stack;
import java_cup.runtime.Symbol;
import org.eclipse.edt.compiler.core.ast.AbstractRecovery;
import org.eclipse.edt.compiler.core.ast.ISyntaxErrorRequestor;
import org.eclipse.edt.compiler.core.ast.ITokenStream;
import org.eclipse.edt.compiler.core.ast.ParseStack;
import org.eclipse.edt.compiler.core.ast.ParseTable;
import org.eclipse.edt.compiler.core.ast.Terminal;

public class ScopeRecovery
extends AbstractRecovery {
    private int parseCheckDistance;
    private int scopeCloserIndex;

    public ScopeRecovery(ParseStack errorStack, Stack realStack, ITokenStream tokenStream, ISyntaxErrorRequestor problemRequestor) {
        super(errorStack, realStack, tokenStream, problemRequestor);
    }

    @Override
    protected void performTrial() {
        int i = 0;
        while (i < ParseTable.SCOPE_CLOSERS.length) {
            Terminal scopeCloser = new Terminal(ParseTable.SCOPE_CLOSERS[i], -1, -1, -1);
            if (this.errorStack.canShift(scopeCloser)) {
                ParseStack newStack = this.errorStack.createCopy();
                newStack.processLookAhead(scopeCloser);
                int distance = newStack.parseCheck(this.tokenStream);
                if (distance > this.parseCheckDistance) {
                    this.parseCheckDistance = distance;
                    this.scopeCloserIndex = i;
                }
            }
            ++i;
        }
    }

    @Override
    public float getMisspellingIndex() {
        return 1.0f;
    }

    @Override
    public int getParseCheckDistance() {
        return this.parseCheckDistance - 2;
    }

    @Override
    public int performRecovery() {
        Terminal lookAhead = this.tokenStream.getLookAhead();
        int left = lookAhead.left;
        int right = lookAhead.right;
        Terminal scopeCloser = new Terminal(ParseTable.SCOPE_CLOSERS[this.scopeCloserIndex], left, left, -1);
        Symbol scopeCloserSymbol = new Symbol(ParseTable.SCOPE_CLOSERS[this.scopeCloserIndex], left, left);
        this.tokenStream.rollBack(scopeCloser, scopeCloserSymbol);
        if (lookAhead.symbolType == 0 && scopeCloser.symbolType == 69) {
            Symbol lastRealSymbol = this.getLastRealSymbol(this.realStack);
            this.problemRequestor.missingEndForPart(lastRealSymbol.left, lastRealSymbol.right);
        } else {
            this.problemRequestor.missingScopeCloser(scopeCloser.symbolType, left, right);
        }
        return 0;
    }
}

