/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal;

import org.eclipse.edt.compiler.internal.EGLBaseNlsStrings;
import org.eclipse.edt.compiler.internal.EGLSystemWord;

public class EGLSystemFunctionWord
extends EGLSystemWord {
    private String[] parameterNames;
    private String[] parameterTypes;
    private String returnType;
    private int returnLength;
    private int[] parameterFunctionModifiers;
    private int[] validArgumentCounts;

    public EGLSystemFunctionWord(String name, int type, int specialFunctionType, String library, String returnType, int returnLength, String[] parameterNames, String[] parameterTypes, int[] parameterFunctionModifiers, int[] validArgumentCounts) {
        super(name, type, specialFunctionType, library);
        this.returnType = returnType;
        this.returnLength = returnLength;
        this.parameterNames = parameterNames;
        this.parameterTypes = parameterTypes;
        this.parameterFunctionModifiers = parameterFunctionModifiers;
        this.additonalInformation = this.isArrayWord() ? EGLBaseNlsStrings.CAProposalArrayFunctionSystemWord : EGLBaseNlsStrings.CAProposalFunctionSystemWord;
        this.validArgumentCounts = validArgumentCounts;
    }

    public int getNumberOfParameters() {
        return this.parameterNames.length;
    }

    public boolean hasReturnCode() {
        return (this.type & 0x100) != 0;
    }

    public boolean returnTypeIsNullable() {
        return (this.type & 0x1000) != 0;
    }

    @Override
    public boolean isSystemFunction() {
        return true;
    }

    @Override
    public String toString() {
        return this.toString(this.parameterNames.length);
    }

    public String toString(int numberOfParms) {
        if (numberOfParms > this.parameterNames.length) {
            numberOfParms = this.parameterNames.length;
        }
        StringBuffer buffer = new StringBuffer(this.name);
        buffer.append('(');
        int i = 0;
        while (i < numberOfParms) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.parameterNames[i]);
            ++i;
        }
        buffer.append(")");
        return buffer.toString();
    }

    public int getReturnLength() {
        return this.returnLength;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public int[] getValidArgumentCounts() {
        return this.validArgumentCounts;
    }

    public String[] getParameterNames() {
        return this.parameterNames;
    }

    public String[] getParameterNames(int numberOfParameters) {
        String[] parameterNamesArray = new String[numberOfParameters];
        int i = 0;
        while (i < parameterNamesArray.length) {
            parameterNamesArray[i] = this.parameterNames[i];
            ++i;
        }
        return parameterNamesArray;
    }

    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    public int[] getParameterFunctionModifiers() {
        return this.parameterFunctionModifiers;
    }
}

