/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import org.eclipse.edt.compiler.binding.FormBinding;
import org.eclipse.edt.compiler.binding.FormBindingCompletor;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.ConstantFormField;
import org.eclipse.edt.compiler.core.ast.FormField;
import org.eclipse.edt.compiler.core.ast.NestedForm;
import org.eclipse.edt.compiler.core.ast.TopLevelForm;
import org.eclipse.edt.compiler.core.ast.VariableFormField;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultBinder;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultScope;
import org.eclipse.edt.compiler.internal.core.lookup.FormScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;

public class FormBinder
extends DefaultBinder {
    private FormBinding formBinding;
    private Scope scope;

    public FormBinder(FormBinding formBinding, Scope scope, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(scope, formBinding, dependencyRequestor, problemRequestor, compilerOptions);
        this.formBinding = formBinding;
        this.scope = scope;
    }

    @Override
    public boolean visit(TopLevelForm form) {
        form.accept(new FormBindingCompletor(this.scope, this.formBinding, this.dependencyRequestor, this.problemRequestor, this.compilerOptions));
        this.currentScope = new FormScope(this.currentScope, this.formBinding);
        return true;
    }

    @Override
    public boolean visit(NestedForm form) {
        form.accept(new FormBindingCompletor(this.scope, this.formBinding, this.dependencyRequestor, this.problemRequestor, this.compilerOptions));
        this.currentScope = new FormScope(this.currentScope, this.formBinding);
        return true;
    }

    @Override
    public boolean visit(VariableFormField variableFormField) {
        return this.visitFormField(variableFormField);
    }

    @Override
    public boolean visit(ConstantFormField constantFormField) {
        return this.visitFormField(constantFormField);
    }

    public boolean visitFormField(FormField field) {
        if (field.hasSettingsBlock()) {
            field.getSettingsBlock().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(Assignment assignment) {
        Scope currentScopeParent = this.currentScope.getParentScope();
        this.currentScope.setParentScope(new DefaultScope());
        assignment.getLeftHandSide().accept(this);
        this.currentScope.setParentScope(currentScopeParent);
        assignment.getRightHandSide().accept(this);
        return false;
    }
}

