/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation;

import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;

public class ProgramParameterValidator {
    private IProblemRequestor problemRequestor;

    public ProgramParameterValidator(IProblemRequestor problemRequestor) {
        this.problemRequestor = problemRequestor;
    }

    public void validate(ITypeBinding tBinding, Node nodeForErrors) {
        if (!this.typeIsValid(tBinding)) {
            this.problemRequestor.acceptProblem(nodeForErrors, 4904, new String[]{StatementValidator.getTypeString(tBinding)});
        }
    }

    private boolean typeIsValid(ITypeBinding tBinding) {
        if (3 == tBinding.getKind()) {
            switch (((PrimitiveTypeBinding)tBinding).getPrimitive().getType()) {
                case 0: 
                case 21: 
                case 22: {
                    return false;
                }
            }
        } else {
            if (2 == tBinding.getKind()) {
                return this.typeIsValid(((ArrayTypeBinding)tBinding).getElementType());
            }
            if (7 == tBinding.getKind()) {
                for (IDataBinding dBinding : ((FlexibleRecordBinding)tBinding).getDeclaredFields()) {
                    if (dBinding.getType() == null || this.typeIsValid(dBinding.getType())) continue;
                    return false;
                }
            } else if (6 != tBinding.getKind() && 8 != tBinding.getKind()) {
                return false;
            }
        }
        if (tBinding.isReference()) {
            return false;
        }
        if (tBinding.isNullable()) {
            return false;
        }
        return !tBinding.isDynamic();
    }
}

