/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.FixedRecordBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IAnnotationValidationRule;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class RedefinesAnnotationValidator
implements IAnnotationValidationRule {
    protected IAnnotationTypeBinding annotationType;
    protected String canonicalAnnotationName;

    private IDataBinding getDataBinding(Node target) {
        IDataBinding result = this.getNonEmbeddedStructureItemBinding(target);
        if (result == null) {
            if (target instanceof ClassDataDeclaration) {
                result = ((Name)((ClassDataDeclaration)target).getNames().get(0)).resolveDataBinding();
            }
            if (target instanceof FunctionDataDeclaration) {
                result = ((Name)((FunctionDataDeclaration)target).getNames().get(0)).resolveDataBinding();
            }
        }
        return result;
    }

    private StructureItemBinding getNonEmbeddedStructureItemBinding(Node target) {
        if (target instanceof StructureItem) {
            StructureItem si = (StructureItem)target;
            if (si.isEmbedded()) {
                return null;
            }
            IBinding binding = si.resolveBinding();
            if (Binding.isValidBinding(binding) && binding.isDataBinding() && ((IDataBinding)binding).getKind() == 5) {
                return (StructureItemBinding)binding;
            }
            return null;
        }
        if (target instanceof Name) {
            IBinding binding = ((Name)target).resolveBinding();
            if (Binding.isValidBinding(binding) && binding.isDataBinding() && ((IDataBinding)binding).getKind() == 5) {
                return (StructureItemBinding)binding;
            }
            return null;
        }
        return null;
    }

    private boolean isNonEmbeddedFixedRecordField(Node target) {
        return this.getNonEmbeddedStructureItemBinding(target) != null;
    }

    private boolean isBasicFixedRecord(ITypeBinding targetTypeBinding) {
        if (!StatementValidator.isValidBinding(targetTypeBinding)) {
            return true;
        }
        return targetTypeBinding.getKind() == 6 && targetTypeBinding.getAnnotation(new String[]{"egl", "core"}, "BasicRecord") != null;
    }

    @Override
    public void validate(Node errorNode, Node target, ITypeBinding targetTypeBinding, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        if (allAnnotations.get(InternUtil.intern((String)"pcb")) != null) {
            return;
        }
        if (!this.isBasicFixedRecord(targetTypeBinding) && !this.isNonEmbeddedFixedRecordField(target)) {
            problemRequestor.acceptProblem(errorNode, 3122);
            return;
        }
        IAnnotationBinding annotationBinding = (IAnnotationBinding)allAnnotations.get(InternUtil.intern((String)"redefines"));
        Object value = annotationBinding.getValue();
        if (value instanceof IBinding && StatementValidator.isValidBinding((IBinding)value) && ((IBinding)value).isDataBinding()) {
            ITypeBinding typeBinding;
            IDataBinding redefined = (IDataBinding)value;
            if (redefined.getAnnotation(new String[]{"egl", "core"}, "Redefines") != null) {
                problemRequestor.acceptProblem(errorNode, 3115, new String[]{"redefines"});
            }
            if (redefined.getKind() == 5) {
                if (!this.isNonEmbeddedFixedRecordField(target)) {
                    problemRequestor.acceptProblem(errorNode, 3114, new String[]{"redefines"});
                } else {
                    StructureItemBinding redefinedStructureBinding = (StructureItemBinding)redefined;
                    StructureItemBinding redefining = this.getNonEmbeddedStructureItemBinding(target);
                    if (!this.immediatelyFollows(redefinedStructureBinding, redefining)) {
                        problemRequestor.acceptProblem(errorNode, 3124, new String[]{redefining.getCaseSensitiveName(), redefined.getCaseSensitiveName()});
                    }
                    if (redefinedStructureBinding.hasOccurs()) {
                        problemRequestor.acceptProblem(errorNode, 3125, new String[]{redefined.getCaseSensitiveName()});
                    }
                }
            }
            if (StatementValidator.isValidBinding(typeBinding = redefined.getType())) {
                if (typeBinding.getKind() != 6 && redefined.getKind() != 5) {
                    problemRequestor.acceptProblem(errorNode, 3114, new String[]{"redefines"});
                } else {
                    IDataBinding redefiner = this.getDataBinding(target);
                    if (Binding.isValidBinding(redefiner) && redefiner.getDeclaringPart() != redefined.getDeclaringPart()) {
                        problemRequestor.acceptProblem(errorNode, 3126, new String[]{redefiner.getCaseSensitiveName(), redefined.getCaseSensitiveName()});
                    } else {
                        int recordDoingTheRedefiningSize;
                        int recordBeingRedefinedSize = this.getSizeInBytes(redefined);
                        if (recordBeingRedefinedSize < (recordDoingTheRedefiningSize = this.getSizeInBytes(targetTypeBinding, target))) {
                            problemRequestor.acceptProblem(errorNode, 3116, new String[]{"redefines", redefined.getCaseSensitiveName(), Integer.toString(recordBeingRedefinedSize), this.getTargetName(targetTypeBinding, target), Integer.toString(recordDoingTheRedefiningSize)});
                        }
                    }
                }
            }
        }
    }

    private String getTargetName(ITypeBinding targetTypeBinding, Node target) {
        if (this.isNonEmbeddedFixedRecordField(target)) {
            StructureItemBinding siBinding = this.getNonEmbeddedStructureItemBinding(target);
            return siBinding.getCaseSensitiveName();
        }
        return targetTypeBinding.getCaseSensitiveName();
    }

    private int getSizeInBytes(ITypeBinding targetTypeBinding, Node target) {
        if (this.isNonEmbeddedFixedRecordField(target)) {
            StructureItemBinding siBinding = this.getNonEmbeddedStructureItemBinding(target);
            int len = siBinding.getLengthInBytes();
            if (Binding.isValidBinding(siBinding.getEnclosingStructureBinding())) {
                if (siBinding.getEnclosingStructureBinding().getAnnotation(new String[]{"egl", "io", "sql"}, "SQLRecord") != null) {
                    len += 4;
                }
                return len;
            }
        }
        if (Binding.isValidBinding(targetTypeBinding) && targetTypeBinding.getKind() == 6) {
            return ((FixedRecordBinding)targetTypeBinding).getSizeInBytes();
        }
        return -1;
    }

    private int getSizeInBytes(IDataBinding dBinding) {
        if (Binding.isValidBinding(dBinding)) {
            if (dBinding.getKind() == 5) {
                StructureItemBinding siBinding = (StructureItemBinding)dBinding;
                int len = siBinding.getLengthInBytes();
                if (siBinding.getDeclaringPart().getAnnotation(new String[]{"egl", "io", "sql"}, "SQLRecord") != null) {
                    len += 4;
                }
                return len;
            }
            ITypeBinding tBinding = dBinding.getType();
            if (Binding.isValidBinding(tBinding) && tBinding.getKind() == 6) {
                FixedRecordBinding rec = (FixedRecordBinding)tBinding;
                int len = rec.getSizeInBytes();
                if (rec.getAnnotation(new String[]{"egl", "io", "sql"}, "SQLRecord") != null) {
                    len += 4 * rec.getStructureItems().size();
                }
                return len;
            }
        }
        return -1;
    }

    private boolean immediatelyFollows(StructureItemBinding first, StructureItemBinding second) {
        if (first.getParentItem() != second.getParentItem()) {
            return false;
        }
        List items = first.getParentItem() == null ? first.getEnclosingStructureBinding().getStructureItems() : first.getParentItem().getChildren();
        Iterator i = items.iterator();
        boolean foundFirst = false;
        while (i.hasNext()) {
            StructureItemBinding current = (StructureItemBinding)i.next();
            if (current == first) {
                foundFirst = true;
                continue;
            }
            if (current == second) {
                return foundFirst;
            }
            if (!foundFirst || current.getAnnotation(new String[]{"egl", "core"}, "Redefines") != null) continue;
            return false;
        }
        return false;
    }
}

