/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.Map;
import org.eclipse.edt.compiler.binding.FixedStructureBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.DefaultFieldContentAnnotationValidationRule;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class SelectedIndexItemForVGUIRecordItemValidator
extends DefaultFieldContentAnnotationValidationRule {
    @Override
    public void validate(Node errorNode, Node container, IDataBinding containerBinding, String canonicalContainerName, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        IDataBinding selectedIndexItemDBinding;
        IAnnotationBinding aBinding = (IAnnotationBinding)allAnnotations.get(InternUtil.intern((String)"selectedIndexItem"));
        if (aBinding != null && (selectedIndexItemDBinding = this.dataBindingFor(aBinding.getValue())) != null && IBinding.NOT_FOUND_BINDING != selectedIndexItemDBinding) {
            IAnnotationBinding numElementsItemABinding;
            boolean conflictWithAnotherName = false;
            FixedStructureBinding enclosingStructureBinding = ((StructureItemBinding)containerBinding).getEnclosingStructureBinding();
            IAnnotationBinding commandValueItemForRecord = (IAnnotationBinding)enclosingStructureBinding.getAnnotation(enclosingStructureBinding.getSubType()).findData(InternUtil.intern((String)"commandValueItem"));
            if (commandValueItemForRecord != IBinding.NOT_FOUND_BINDING && this.dataBindingFor(commandValueItemForRecord.getValue()) == selectedIndexItemDBinding) {
                conflictWithAnotherName = true;
            }
            if (!conflictWithAnotherName) {
                boolean bl = conflictWithAnotherName = selectedIndexItemDBinding.getName() == containerBinding.getName();
            }
            if (!conflictWithAnotherName && (numElementsItemABinding = containerBinding.getAnnotation(new String[]{"egl", "ui"}, "NumElementsItem")) != null && this.dataBindingFor(numElementsItemABinding.getValue()) == selectedIndexItemDBinding) {
                conflictWithAnotherName = true;
            }
            if (conflictWithAnotherName) {
                problemRequestor.acceptProblem(errorNode, 7786, new String[]{"selectedIndexItem", "commandValueItem", "numElementsItem"});
            }
            if (!((StructureItemBinding)containerBinding).isMultiplyOccuring()) {
                problemRequestor.acceptProblem(errorNode, 7787, new String[]{containerBinding.getName(), "selectedIndexItem"});
            } else if (5 == selectedIndexItemDBinding.getKind()) {
                boolean typeIsValid = false;
                ITypeBinding selectedIndexItemTBinding = selectedIndexItemDBinding.getType();
                if (3 == selectedIndexItemTBinding.getKind()) {
                    PrimitiveTypeBinding primTypeBinding = (PrimitiveTypeBinding)selectedIndexItemTBinding;
                    boolean bl = typeIsValid = Primitive.isNumericType(primTypeBinding.getPrimitive()) && primTypeBinding.getDecimals() == 0;
                }
                if (!typeIsValid) {
                    problemRequestor.acceptProblem(errorNode, 7788, new String[]{"selectedIndexItem", selectedIndexItemDBinding.getCaseSensitiveName()});
                } else {
                    int selectedIndexItemOccurs = this.getFirstOccurs((StructureItemBinding)selectedIndexItemDBinding);
                    if (selectedIndexItemOccurs != 0 && selectedIndexItemOccurs != this.getFirstOccurs((StructureItemBinding)containerBinding)) {
                        problemRequestor.acceptProblem(errorNode, 7790, new String[]{selectedIndexItemDBinding.getCaseSensitiveName()});
                    }
                }
            }
        }
    }

    private IDataBinding dataBindingFor(Object annotationValue) {
        if (annotationValue instanceof IDataBinding) {
            return (IDataBinding)annotationValue;
        }
        if (annotationValue instanceof Name) {
            return ((Name)annotationValue).resolveDataBinding();
        }
        return null;
    }

    private int getFirstOccurs(StructureItemBinding sItemBinding) {
        if (sItemBinding.isMultiplyOccuring()) {
            if (sItemBinding.hasOccurs()) {
                return sItemBinding.getOccurs();
            }
            return this.getFirstOccurs(sItemBinding.getParentItem());
        }
        return 0;
    }
}

