/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.edt.compiler.binding.EnumerationDataBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.Enumerations.UITypeKind;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.DefaultFieldContentAnnotationValidationRule;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class UITypeForVGUIRecordItemValidator
extends DefaultFieldContentAnnotationValidationRule {
    private static Set propertiesForWhichUITypeValueOfProgramLinkOrUIFormIsNotAllowed = new TreeSet(new EGLCaseInsensitiveComparator());
    private static Set propertiesForWhichUITypeValueOfNoneIsNotAllowed;
    private static List validPrimitivesForUITypeSubmit;
    private static Set uiTypeValuesForWhichProgramLinkDataPropertyIsNotAllowed;

    static {
        propertiesForWhichUITypeValueOfProgramLinkOrUIFormIsNotAllowed.addAll(Arrays.asList(InternUtil.intern((String)"typeChkMsgKey"), InternUtil.intern((String)"validValuesMsgKey"), InternUtil.intern((String)"currency"), InternUtil.intern((String)"currencySymbol"), InternUtil.intern((String)"numericSeparator"), InternUtil.intern((String)"sign"), InternUtil.intern((String)"inputRequired"), InternUtil.intern((String)"validatorFunction"), InternUtil.intern((String)"validatorDataTable"), InternUtil.intern((String)"zeroFormat"), InternUtil.intern((String)"minimumInput"), InternUtil.intern((String)"needsSOSI"), InternUtil.intern((String)"runValidatorFromProgram"), InternUtil.intern((String)"validValues"), InternUtil.intern((String)"validatorFunctionMsgKey"), InternUtil.intern((String)"validatorDataTableMsgKey"), InternUtil.intern((String)"minimumInputMsgKey"), InternUtil.intern((String)"inputRequiredMsgKey"), InternUtil.intern((String)"typeChkMsgKey"), InternUtil.intern((String)"validValuesMsgKey"), InternUtil.intern((String)"fillCharacter"), InternUtil.intern((String)"isBoolean"), InternUtil.intern((String)"dateFormat"), InternUtil.intern((String)"timeFormat"), InternUtil.intern((String)"upperCase")));
        propertiesForWhichUITypeValueOfNoneIsNotAllowed = new TreeSet(new EGLCaseInsensitiveComparator());
        propertiesForWhichUITypeValueOfNoneIsNotAllowed.addAll(Arrays.asList(InternUtil.intern((String)"currency"), InternUtil.intern((String)"currencySymbol"), InternUtil.intern((String)"numericSeparator"), InternUtil.intern((String)"sign"), InternUtil.intern((String)"isBoolean"), InternUtil.intern((String)"zeroFormat"), InternUtil.intern((String)"displayName"), InternUtil.intern((String)"help"), InternUtil.intern((String)"numElementsItem"), InternUtil.intern((String)"selectedIndexItem"), InternUtil.intern((String)"inputRequired"), InternUtil.intern((String)"validatorFunction"), InternUtil.intern((String)"validatorDataTable"), InternUtil.intern((String)"minimumInput"), InternUtil.intern((String)"needsSOSI"), InternUtil.intern((String)"runValidatorFromProgram"), InternUtil.intern((String)"validValues"), InternUtil.intern((String)"validatorFunctionMsgKey"), InternUtil.intern((String)"validatorDataTableMsgKey"), InternUtil.intern((String)"typeChkMsgKey"), InternUtil.intern((String)"validValuesMsgKey"), InternUtil.intern((String)"fillCharacter"), InternUtil.intern((String)"dateFormat"), InternUtil.intern((String)"timeFormat"), InternUtil.intern((String)"upperCase"), InternUtil.intern((String)"minimumInputMsgKey"), InternUtil.intern((String)"inputRequiredMsgKey")));
        validPrimitivesForUITypeSubmit = Arrays.asList(Primitive.CHAR, Primitive.MBCHAR, Primitive.DBCHAR, Primitive.UNICODE);
        uiTypeValuesForWhichProgramLinkDataPropertyIsNotAllowed = new TreeSet();
        uiTypeValuesForWhichProgramLinkDataPropertyIsNotAllowed.addAll(Arrays.asList(InternUtil.intern((String)"hidden"), InternUtil.intern((String)"input"), InternUtil.intern((String)"inputOutput"), InternUtil.intern((String)"output"), InternUtil.intern((String)"submit"), InternUtil.intern((String)"submitBypass"), InternUtil.intern((String)"none")));
    }

    @Override
    public void validate(Node errorNode, Node container, IDataBinding containerBinding, String canonicalContainerName, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        IAnnotationBinding annotationBinding = (IAnnotationBinding)allAnnotations.get(InternUtil.intern((String)"uiType"));
        if (annotationBinding != null) {
            ITypeBinding tBinding;
            EnumerationDataBinding value = (EnumerationDataBinding)annotationBinding.getValue();
            if (AbstractBinder.enumerationIs(value, new String[]{"egl", "ui", "webTransaction"}, "UITypeKind", "UIFORM") || AbstractBinder.enumerationIs(value, new String[]{"egl", "ui", "webTransaction"}, "UITypeKind", "PROGRAMLINK")) {
                if (allAnnotations.get(InternUtil.intern((String)"programLinkData")) == null) {
                    problemRequestor.acceptProblem(errorNode, 7791, new String[]{"@programLinkData"});
                }
                for (String nextPropName : propertiesForWhichUITypeValueOfProgramLinkOrUIFormIsNotAllowed) {
                    Object otherValue;
                    IAnnotationBinding otherABinding = (IAnnotationBinding)allAnnotations.get(nextPropName);
                    if (otherABinding == null || this.isUnapplicable(otherValue = otherABinding.getValue())) continue;
                    problemRequestor.acceptProblem(errorNode, 7785, new String[]{nextPropName, UITypeForVGUIRecordItemValidator.toCommaList(new String[]{UITypeKind.UIFORM.getCaseSensitiveName(), UITypeKind.PROGRAMLINK.getCaseSensitiveName()})});
                }
            } else if (AbstractBinder.enumerationIs(value, new String[]{"egl", "ui", "webTransaction"}, "UITypeKind", "NONE")) {
                for (String nextPropName : propertiesForWhichUITypeValueOfNoneIsNotAllowed) {
                    Object otherValue;
                    IAnnotationBinding otherABinding = (IAnnotationBinding)allAnnotations.get(nextPropName);
                    if (otherABinding == null || this.isUnapplicable(otherValue = otherABinding.getValue())) continue;
                    problemRequestor.acceptProblem(errorNode, 7785, new String[]{nextPropName, UITypeForVGUIRecordItemValidator.toCommaList(new String[]{UITypeKind.NONE.getName()})});
                }
            } else if ((AbstractBinder.enumerationIs(value, new String[]{"egl", "ui", "webTransaction"}, "UITypeKind", "SUBMIT") || AbstractBinder.enumerationIs(value, new String[]{"egl", "ui", "webTransaction"}, "UITypeKind", "SUBMITBYPASS")) && (tBinding = containerBinding.getType()) != null && IBinding.NOT_FOUND_BINDING != tBinding) {
                boolean typeIsValid = false;
                if (3 == tBinding.getKind()) {
                    typeIsValid = validPrimitivesForUITypeSubmit.contains(((PrimitiveTypeBinding)tBinding).getPrimitive());
                }
                if (!typeIsValid) {
                    problemRequestor.acceptProblem(errorNode, 7795, new String[]{AbstractBinder.enumerationIs(value, new String[]{"egl", "ui", "webTransaction"}, "UITypeKind", "SUBMIT") ? UITypeKind.SUBMIT.getName() : UITypeKind.SUBMITBYPASS.getName(), UITypeForVGUIRecordItemValidator.toCommaList(validPrimitivesForUITypeSubmit.toArray(new Primitive[0]))});
                }
            }
            if (canonicalContainerName.equals("*") && !AbstractBinder.enumerationIs(value, new String[]{"egl", "ui", "webTransaction"}, "UITypeKind", "NONE")) {
                problemRequestor.acceptProblem(errorNode, 7792);
            }
            if (allAnnotations.get(InternUtil.intern((String)"programLinkData")) != null && uiTypeValuesForWhichProgramLinkDataPropertyIsNotAllowed.contains(value.getName())) {
                problemRequestor.acceptProblem(errorNode, 7785, new String[]{"@programLinkData", UITypeForVGUIRecordItemValidator.toCommaList(uiTypeValuesForWhichProgramLinkDataPropertyIsNotAllowed.toArray(new String[0]))});
            }
        }
    }

    private boolean isUnapplicable(Object value) {
        if (value == Boolean.NO) {
            return true;
        }
        if (value instanceof EnumerationDataBinding) {
            EnumerationDataBinding eDataBinding = (EnumerationDataBinding)value;
            if (InternUtil.intern((String)"NONE") == eDataBinding.getName()) {
                return true;
            }
        }
        return false;
    }

    private static String toCommaList(String[] ary) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < ary.length) {
            sb.append(ary[i]);
            if (i != ary.length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        return sb.toString();
    }

    private static String toCommaList(Primitive[] ary) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < ary.length) {
            sb.append(ary[i].getName());
            if (i != ary.length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        return sb.toString();
    }

    private static String toCommaList(IDataBinding[] ary) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < ary.length) {
            sb.append(ary[i].getName());
            if (i != ary.length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        return sb.toString();
    }

    private static class EGLCaseInsensitiveComparator
    implements Comparator {
        private EGLCaseInsensitiveComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            if (arg0 == null) {
                return -1;
            }
            if (arg1 == null) {
                return 1;
            }
            return arg0.toString().compareToIgnoreCase(arg1.toString());
        }
    }
}

