/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.part;

import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.DataItem;
import org.eclipse.edt.compiler.core.ast.PrimitiveType;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.compiler.internal.core.validation.type.PrimitiveTypeValidator;

public class DataItemValidator
extends AbstractASTVisitor {
    protected IProblemRequestor problemRequestor;
    private ICompilerOptions compilerOptions;

    public DataItemValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public boolean visit(DataItem dataItem) {
        EGLNameValidator.validate(dataItem.getName(), 10, this.problemRequestor, this.compilerOptions);
        if (dataItem.getType().isPrimitiveType()) {
            PrimitiveTypeValidator.validate((PrimitiveType)dataItem.getType(), this.problemRequestor, this.compilerOptions);
        }
        return true;
    }

    @Override
    public boolean visit(SettingsBlock settingsBlock) {
        return false;
    }
}

