/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.part;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.edt.compiler.binding.FormBinding;
import org.eclipse.edt.compiler.binding.FormFieldBinding;
import org.eclipse.edt.compiler.binding.FormGroupBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.ConstantFormField;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedForm;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.TopLevelForm;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.compiler.core.ast.VariableFormField;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AnnotationValidator;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class FormValidator
extends AbstractASTVisitor {
    private static final String[] EGLUITEXT = new String[]{"egl", "ui", "text"};
    private static final String[] EGLUI = new String[]{"egl", "ui"};
    protected IProblemRequestor problemRequestor;
    private FormBinding formBinding;
    private String canonicalFormName;
    private FormGroupBinding enclosingFormGroupBinding;
    private Node topLevelNode;
    private FormGridValidator formGridValidator;
    private boolean isTextForm;
    private boolean isPrintForm;
    private int[] formSize;
    private int[] formPosition;
    private IFieldInfo cursorField;
    private List validationOrders = new ArrayList();
    private ICompilerOptions compilerOptions;

    public FormValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this(problemRequestor, null, compilerOptions);
    }

    public FormValidator(IProblemRequestor problemRequestor, FormGroupBinding enclosingFormGroupBinding, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
        this.enclosingFormGroupBinding = enclosingFormGroupBinding;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public boolean visit(TopLevelForm topLevelForm) {
        this.topLevelNode = topLevelForm;
        this.formBinding = (FormBinding)topLevelForm.getName().resolveBinding();
        this.canonicalFormName = topLevelForm.getName().getCanonicalName();
        if (this.formBinding != null) {
            new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(topLevelForm);
            this.initializeData();
            this.checkForm(topLevelForm.getName());
        }
        return true;
    }

    @Override
    public void endVisit(TopLevelForm topLevelForm) {
        if (this.formGridValidator != null) {
            this.formGridValidator.reportFormContextProblems();
        }
        this.issueFinalErrors(topLevelForm.getName());
    }

    @Override
    public boolean visit(NestedForm nestedForm) {
        this.topLevelNode = nestedForm;
        this.formBinding = (FormBinding)nestedForm.getName().resolveBinding();
        this.canonicalFormName = nestedForm.getName().getCanonicalName();
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(nestedForm);
        this.initializeData();
        if (!this.checkForm(nestedForm.getName())) {
            return false;
        }
        this.addFloatingAreas();
        return true;
    }

    @Override
    public void endVisit(NestedForm nestedForm) {
        if (this.formGridValidator != null) {
            this.formGridValidator.reportFormContextProblems();
            this.formGridValidator.reportFormGroupContextProblems();
        }
        this.issueFinalErrors(nestedForm.getName());
    }

    private void issueFinalErrors(Node formNameNode) {
        this.checkValidationOrderValues(formNameNode);
    }

    private void checkValidationOrderValues(Node formNameNode) {
        if (!this.validationOrders.isEmpty()) {
            Collections.sort(this.validationOrders);
            boolean isValid = true;
            boolean firstPass = true;
            int previousOrder = -1;
            Iterator iter = this.validationOrders.iterator();
            while (iter.hasNext() && isValid) {
                int currentOrder = (Integer)iter.next();
                if (firstPass) {
                    isValid = currentOrder >= 1;
                    firstPass = false;
                } else {
                    isValid = currentOrder >= previousOrder + 1;
                }
                previousOrder = currentOrder;
            }
            if (!isValid) {
                this.problemRequestor.acceptProblem(formNameNode, 5335, new String[]{this.canonicalFormName});
            }
        }
    }

    @Override
    public boolean visit(UseStatement useStatement) {
        for (Name nextName : useStatement.getNames()) {
            this.canonicalFormName = nextName.getCanonicalName();
            IBinding binding = nextName.resolveBinding();
            if (binding == null || binding == IBinding.NOT_FOUND_BINDING || !binding.isTypeBinding() || 8 != ((ITypeBinding)binding).getKind()) continue;
            this.topLevelNode = nextName;
            this.formBinding = (FormBinding)binding;
            this.initializeData();
            this.addFloatingAreas();
            if (this.formGridValidator != null) {
                Iterator iter2 = this.formBinding.getFields().iterator();
                while (iter2.hasNext()) {
                    IFieldInfo[] fieldInfos = this.createFieldInfos((FormFieldBinding)iter2.next(), nextName);
                    int i = 0;
                    while (i < fieldInfos.length) {
                        this.formGridValidator.applyFieldToGrid(fieldInfos[i]);
                        ++i;
                    }
                }
            }
            if (this.formGridValidator == null) continue;
            this.formGridValidator.reportFormGroupContextProblems();
        }
        return false;
    }

    @Override
    public boolean visit(VariableFormField variableFormField) {
        EGLNameValidator.validate(variableFormField.getName(), 33, this.problemRequestor, this.compilerOptions);
        IFieldInfo[] fInfos = this.createFieldInfos(variableFormField);
        this.checkFields(fInfos);
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(variableFormField);
        if (fInfos.length != 0) {
            Integer validationOrder = fInfos[0].getValidationOrder();
            if (validationOrder != null) {
                this.validationOrders.add(validationOrder);
            }
            int i = 0;
            while (i < fInfos.length) {
                if (fInfos[i].isCursor()) {
                    if (this.cursorField == null) {
                        this.cursorField = fInfos[i];
                    } else {
                        int sev;
                        if (this.cursorField.isCursorOnSpecificIndex() || fInfos[i].isCursorOnSpecificIndex()) {
                            sev = 1;
                            if (this.cursorField.isCursorOnSpecificIndex()) {
                                this.cursorField = fInfos[i];
                            }
                        } else {
                            sev = 2;
                        }
                        this.problemRequestor.acceptProblem(fInfos[0].getNodeForErrors(), 5336, sev, new String[]{this.canonicalFormName});
                    }
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public boolean visit(ConstantFormField constantFormField) {
        IFieldInfo fInfo = this.createFieldInfo(constantFormField);
        this.checkField(fInfo);
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(constantFormField);
        if (fInfo.isCursor()) {
            if (this.cursorField == null) {
                this.cursorField = fInfo;
            } else {
                int sev = this.cursorField.isCursorOnSpecificIndex() ? 1 : 2;
                this.problemRequestor.acceptProblem(fInfo.getNodeForErrors(), 5336, sev, new String[]{this.canonicalFormName});
            }
        }
        return false;
    }

    @Override
    public boolean visit(SettingsBlock settingsBlock) {
        return false;
    }

    private void initializeData() {
        Integer[] positionValue;
        Integer[] formSizeValue;
        this.isPrintForm = this.formBinding.getAnnotation(EGLUITEXT, "PrintForm") != null;
        this.isTextForm = this.formBinding.getAnnotation(EGLUITEXT, "TextForm") != null;
        IAnnotationBinding aBinding = this.formBinding.getAnnotation(EGLUITEXT, "FormSize");
        if (aBinding != null && aBinding.getValue() instanceof Integer[] && (formSizeValue = (Integer[])aBinding.getValue()) != null && formSizeValue.length == 2) {
            this.formSize = new int[]{formSizeValue[0], formSizeValue[1]};
            if (this.formSize[0] < 1 || this.formSize[1] < 1) {
                this.formSize = null;
            }
        }
        if ((aBinding = this.formBinding.getAnnotation(EGLUI, "Position")) != null && (positionValue = (Integer[])aBinding.getValue()) != null && positionValue.length == 2) {
            this.formPosition = new int[]{positionValue[0], positionValue[1]};
        }
        if (this.formSize != null) {
            if (this.isTextForm) {
                Integer[][] screenSizesValue;
                this.formGridValidator = this.formPosition == null ? new FloatingTextFormGridValidator() : new FixedTextFormGridValidator();
                aBinding = this.getField(this.formBinding.getAnnotation(this.formBinding.getSubType()), "screenSizes");
                if (aBinding != null && (screenSizesValue = (Integer[][])aBinding.getValue()) != null) {
                    int i = 0;
                    while (i < screenSizesValue.length) {
                        int[] screenSize;
                        if (screenSizesValue[i].length == 2 && (screenSize = new int[]{screenSizesValue[i][0], screenSizesValue[i][1]})[0] > 0 && screenSize[1] > 0) {
                            this.formGridValidator.addScreenSize(screenSize);
                        }
                        ++i;
                    }
                }
            } else if (this.isPrintForm) {
                this.formGridValidator = this.formPosition == null ? new FloatingPrintFormGridValidator() : new FixedPrintFormGridValidator();
                this.formGridValidator.addScreenSize(new int[]{255, 158});
            }
        }
    }

    private void addFloatingAreas() {
        block7: {
            IAnnotationBinding aBinding;
            block8: {
                if (this.formGridValidator == null) break block7;
                if (!this.isPrintForm) break block8;
                IAnnotationBinding aBinding2 = this.enclosingFormGroupBinding.getAnnotation(EGLUITEXT, "PrintFloatingAreas");
                if (aBinding2 == null || !(aBinding2.getValue() instanceof IAnnotationBinding[])) break block7;
                IAnnotationBinding[] printFloatingAreas = (IAnnotationBinding[])aBinding2.getValue();
                if (printFloatingAreas.length == 0) {
                    this.formGridValidator.useDefaultFloatingArea();
                } else {
                    int i = 0;
                    while (i < printFloatingAreas.length) {
                        this.formGridValidator.addFloatingArea(this.createFloatingAreaInfo(printFloatingAreas[i], false));
                        ++i;
                    }
                }
                break block7;
            }
            if (this.isTextForm && (aBinding = this.enclosingFormGroupBinding.getAnnotation(EGLUITEXT, "ScreenFloatingAreas")) != null && aBinding.getValue() instanceof IAnnotationBinding[]) {
                IAnnotationBinding[] screenFloatingAreas = (IAnnotationBinding[])aBinding.getValue();
                if (screenFloatingAreas.length == 0) {
                    this.formGridValidator.useDefaultFloatingArea();
                } else {
                    int i = 0;
                    while (i < screenFloatingAreas.length) {
                        this.formGridValidator.addFloatingArea(this.createFloatingAreaInfo(screenFloatingAreas[i], true));
                        ++i;
                    }
                }
            }
        }
    }

    private boolean checkForm(Name formNameNode) {
        EGLNameValidator.validate(formNameNode, 33, this.problemRequestor, this.compilerOptions);
        if (this.formSize == null) {
            this.problemRequestor.acceptProblem((Node)formNameNode, 5333, new String[]{this.canonicalFormName});
            return false;
        }
        return true;
    }

    private boolean checkFields(IFieldInfo[] fInfos) {
        boolean result = true;
        int i = 0;
        while (i < fInfos.length) {
            if (!this.checkField(fInfos[i])) {
                result = false;
            }
            ++i;
        }
        return result;
    }

    private boolean checkField(IFieldInfo fInfo) {
        if (this.formGridValidator != null) {
            this.formGridValidator.applyFieldToGrid(fInfo);
        }
        return true;
    }

    private FloatingAreaInfo createFloatingAreaInfo(IAnnotationBinding floatingAreaBinding, boolean isScreenFloatingArea) {
        if (isScreenFloatingArea) {
            Integer[] screenSizeValue;
            IAnnotationBinding aBinding = this.getField(floatingAreaBinding, "screenSize");
            if (aBinding != null && (screenSizeValue = (Integer[])aBinding.getValue()) != null && screenSizeValue.length == 2) {
                FloatingAreaInfo result = new FloatingAreaInfo(this.getIntValue(floatingAreaBinding, "leftMargin"), this.getIntValue(floatingAreaBinding, "topMargin"), new int[]{screenSizeValue[0], screenSizeValue[1]});
                return result;
            }
        } else {
            Integer[] pageSizeValue;
            IAnnotationBinding aBinding = this.getField(floatingAreaBinding, "pageSize");
            if (aBinding != null && (pageSizeValue = (Integer[])aBinding.getValue()) != null && pageSizeValue.length == 2) {
                FloatingAreaInfo result = new FloatingAreaInfo(this.getIntValue(floatingAreaBinding, "leftMargin"), this.getIntValue(floatingAreaBinding, "topMargin"), new int[]{pageSizeValue[0], pageSizeValue[1]});
                aBinding = this.getField(floatingAreaBinding, "deviceType");
                if (aBinding != null && aBinding.getValue() instanceof IDataBinding && "doubleByte".equalsIgnoreCase(((IDataBinding)aBinding.getValue()).getName())) {
                    result.isDoubleByte = true;
                }
                return result;
            }
        }
        return null;
    }

    private int getIntValue(IAnnotationBinding annotationContainer, String fieldName) {
        IAnnotationBinding aBinding = this.getField(annotationContainer, fieldName);
        return (Integer)aBinding.getValue();
    }

    private Node getPositionNode() {
        return this.getAnnotationNode(InternUtil.intern((String)"Position"));
    }

    private Node getFormSizeNode() {
        return this.getAnnotationNode(InternUtil.intern((String)"FormSize"));
    }

    private Node getAnnotationNode(final String annotationName) {
        final Node[] result = new Node[]{this.topLevelNode};
        this.topLevelNode.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(NestedForm nestedForm) {
                return true;
            }

            @Override
            public boolean visit(TopLevelForm topLevelForm) {
                return true;
            }

            @Override
            public boolean visit(SettingsBlock settingsBlock) {
                return true;
            }

            @Override
            public boolean visit(Assignment assignment) {
                assignment.getLeftHandSide().accept(new DefaultASTVisitor(){

                    @Override
                    public boolean visit(SimpleName simpleName) {
                        if (simpleName.getIdentifier() == annotationName) {
                            result[0] = simpleName;
                        }
                        return false;
                    }
                });
                return false;
            }
        });
        return result[0];
    }

    private IFieldInfo[] createFieldInfos(VariableFormField varFormField) {
        FormFieldBinding fBinding = (FormFieldBinding)varFormField.getName().resolveBinding();
        return fBinding == null ? new IFieldInfo[]{} : this.createFieldInfos(fBinding, varFormField.getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IFieldInfo[] createFieldInfos(FormFieldBinding fBinding, Node nodeForErrors) {
        if (fBinding.isMultiplyOccuring()) {
            int occurs = fBinding.getOccurs();
            IAnnotationBinding aBinding = fBinding.getAnnotation(EGLUI, "FieldLen");
            IFieldInfo[] result = new IFieldInfo[]{};
            if (aBinding == null) return result;
            int fieldLength = (Integer)aBinding.getValue();
            result = new IFieldInfo[occurs];
            int i = 0;
            while (i < occurs) {
                result[i] = this.isTextForm ? new VariableTextFormFieldInfo() : new VariablePrintFormFieldInfo();
                result[i].setNodeForErrors(nodeForErrors);
                result[i].setFieldLength(fieldLength);
                Integer[] positionValue = (Integer[])fBinding.getAnnotation(EGLUI, "Position", i + 1).getValue();
                result[i].setFieldPosition(new int[]{positionValue[0], positionValue[1]});
                result[i].setCanonicalFieldName(String.valueOf(fBinding.getName()) + "[" + Integer.toString(i + 1) + "]");
                result[i].setFieldBinding(fBinding);
                result[i].setIndex(i + 1);
                ++i;
            }
            return result;
        }
        FieldInfo result = null;
        result = this.isTextForm ? (fBinding.isConstant() ? new ConstantTextFormFieldInfo() : new VariableTextFormFieldInfo()) : (fBinding.isConstant() ? new ConstantPrintFormFieldInfo() : new VariablePrintFormFieldInfo());
        result.setNodeForErrors(nodeForErrors);
        IAnnotationBinding aBinding = fBinding.getAnnotation(EGLUI, "FieldLen");
        if (aBinding == null || aBinding.getValue() == null) {
            if (!fBinding.isConstant()) return new IFieldInfo[0];
            aBinding = fBinding.getAnnotation(EGLUI, "Value");
            if (aBinding == null) {
                result.setFieldLength(0);
            } else {
                Object valueValue = aBinding.getValue();
                if (valueValue instanceof String) {
                    result.setFieldLength(FormValidator.lengthWithoutEscapeChars((String)valueValue));
                } else if (valueValue instanceof Integer) {
                    result.setFieldLength(((Integer)valueValue).toString().length());
                }
            }
        } else {
            try {
                result.setFieldLength(Integer.parseInt(aBinding.getValue().toString()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        result.setFieldPosition(this.getPosition(fBinding));
        result.setCanonicalFieldName(fBinding.getName());
        result.setFieldBinding(fBinding);
        return new IFieldInfo[]{result};
    }

    private IFieldInfo createFieldInfo(ConstantFormField constFormField) {
        FormFieldBinding fBinding = constFormField.resolveBinding();
        return this.createFieldInfos(fBinding, constFormField)[0];
    }

    private int[] getPosition(IBinding binding) {
        IAnnotationBinding aBinding = binding.getAnnotation(EGLUI, "Position");
        Integer[] positionValue = null;
        if (aBinding == null || !(aBinding.getValue() instanceof Integer[])) {
            positionValue = new Integer[]{new Integer(1), new Integer(1)};
        } else {
            positionValue = (Integer[])aBinding.getValue();
            if (positionValue == null || positionValue.length != 2) {
                positionValue = new Integer[]{new Integer(1), new Integer(1)};
            }
        }
        return new int[]{positionValue[0], positionValue[1]};
    }

    private static int lengthWithoutEscapeChars(String input) {
        String tempString = input;
        int len = input.length();
        if (tempString == "\\") {
            return 1;
        }
        int slashIndex = tempString.indexOf(92);
        while (slashIndex != -1) {
            if (slashIndex == input.length() - 1) {
                slashIndex = -1;
                --len;
                continue;
            }
            tempString = tempString.substring(slashIndex + 2);
            slashIndex = tempString.indexOf(92);
            --len;
        }
        return len;
    }

    private static boolean hasDBCharField(FormBinding formBinding) {
        Iterator iter = formBinding.getFields().iterator();
        while (iter.hasNext()) {
            Primitive nextPrim;
            ITypeBinding nextType = ((IDataBinding)iter.next()).getType();
            if (nextType == null || 3 != nextType.getKind() || (nextPrim = ((PrimitiveTypeBinding)nextType).getPrimitive()) != Primitive.DBCHAR) continue;
            return true;
        }
        return false;
    }

    private IAnnotationBinding getField(IAnnotationBinding aBinding, String fieldName) {
        IDataBinding fieldBinding = aBinding.findData(fieldName);
        return IBinding.NOT_FOUND_BINDING == fieldBinding ? null : (IAnnotationBinding)fieldBinding;
    }

    private static class AttributeFieldInfo
    implements IFieldInfo {
        private IFieldInfo fieldInfo;

        public AttributeFieldInfo(IFieldInfo fieldInfo) {
            this.fieldInfo = fieldInfo;
        }

        @Override
        public boolean canAlwaysWrap() {
            return this.fieldInfo.canAlwaysWrap();
        }

        @Override
        public boolean canExtendBeyondFormBoundary() {
            return this.fieldInfo.canExtendBeyondFormBoundary();
        }

        @Override
        public String getCanonicalFieldName() {
            return this.fieldInfo.getCanonicalFieldName();
        }

        @Override
        public FormFieldBinding getFieldBinding() {
            return this.fieldInfo.getFieldBinding();
        }

        @Override
        public int getFieldLength() {
            return this.fieldInfo.getFieldLength();
        }

        @Override
        public int[] getFieldPosition() {
            return this.fieldInfo.getFieldPosition();
        }

        @Override
        public Node getNodeForErrors() {
            return this.fieldInfo.getNodeForErrors();
        }

        @Override
        public Integer getValidationOrder() {
            return this.fieldInfo.getValidationOrder();
        }

        @Override
        public boolean isAttribute() {
            return true;
        }

        @Override
        public boolean isCursor() {
            return this.fieldInfo.isCursor();
        }

        @Override
        public void setCanonicalFieldName(String canonicalFieldName) {
            this.fieldInfo.setCanonicalFieldName(canonicalFieldName);
        }

        @Override
        public void setFieldBinding(FormFieldBinding fieldBinding) {
            this.fieldInfo.setFieldBinding(fieldBinding);
        }

        @Override
        public void setFieldLength(int fieldLength) {
            this.fieldInfo.setFieldLength(fieldLength);
        }

        @Override
        public void setFieldPosition(int[] fieldPosition) {
            this.fieldInfo.setFieldPosition(fieldPosition);
        }

        @Override
        public void setNodeForErrors(Node nodeForErrors) {
            this.fieldInfo.setNodeForErrors(nodeForErrors);
        }

        public boolean equals(Object obj) {
            return this.fieldInfo.equals(obj);
        }

        @Override
        public boolean isPrintField() {
            return false;
        }

        @Override
        public boolean isTextField() {
            return false;
        }

        @Override
        public int getIndex() {
            return this.fieldInfo.getIndex();
        }

        @Override
        public void setIndex(int index) {
            this.fieldInfo.setIndex(index);
        }

        @Override
        public boolean isCursorOnSpecificIndex() {
            return this.fieldInfo.isCursorOnSpecificIndex();
        }
    }

    private static class ConstantPrintFormFieldInfo
    extends PrintFormFieldInfo {
        private ConstantPrintFormFieldInfo() {
        }

        @Override
        protected IFieldInfo getNewInstance() {
            return new ConstantPrintFormFieldInfo();
        }

        @Override
        public boolean canAlwaysWrap() {
            return true;
        }
    }

    private static class ConstantTextFormFieldInfo
    extends TextFormFieldInfo {
        private ConstantTextFormFieldInfo() {
        }

        @Override
        protected IFieldInfo getNewInstance() {
            return new ConstantTextFormFieldInfo();
        }

        @Override
        public boolean canAlwaysWrap() {
            return true;
        }
    }

    private static abstract class FieldInfo
    implements IFieldInfo {
        private Node nodeForErrors;
        private int fieldLength;
        private int[] fieldPosition;
        private String canonicalFieldName;
        private FormFieldBinding fieldBinding;
        private int index;

        private FieldInfo() {
        }

        @Override
        public boolean isCursorOnSpecificIndex() {
            if (this.getIndex() < 1 || !this.isCursor()) {
                return false;
            }
            return this.getFieldBinding().getAnnotation(EGLUITEXT, "Cursor", this.getIndex()) != this.getFieldBinding().getAnnotation(EGLUITEXT, "Cursor");
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public void setIndex(int index) {
            this.index = index;
        }

        @Override
        public Node getNodeForErrors() {
            return this.nodeForErrors;
        }

        @Override
        public int getFieldLength() {
            return this.fieldLength;
        }

        @Override
        public int[] getFieldPosition() {
            return this.fieldPosition;
        }

        @Override
        public String getCanonicalFieldName() {
            return this.canonicalFieldName;
        }

        @Override
        public FormFieldBinding getFieldBinding() {
            return this.fieldBinding;
        }

        @Override
        public void setNodeForErrors(Node nodeForErrors) {
            this.nodeForErrors = nodeForErrors;
        }

        @Override
        public void setFieldLength(int fieldLength) {
            this.fieldLength = fieldLength;
        }

        @Override
        public void setFieldPosition(int[] fieldPosition) {
            this.fieldPosition = fieldPosition;
        }

        @Override
        public void setCanonicalFieldName(String canonicalFieldName) {
            this.canonicalFieldName = canonicalFieldName;
        }

        @Override
        public void setFieldBinding(FormFieldBinding fieldBinding) {
            this.fieldBinding = fieldBinding;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof IFieldInfo) {
                IFieldInfo other = (IFieldInfo)obj;
                return other.getNodeForErrors() == this.getNodeForErrors() && other.getFieldLength() == this.getFieldLength() && other.getFieldPosition()[0] == this.getFieldPosition()[0] && other.getFieldPosition()[1] == this.getFieldPosition()[1] && other.getCanonicalFieldName().equals(this.getCanonicalFieldName());
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.nodeForErrors.hashCode();
            result = 37 * result + this.fieldLength;
            result = 37 * result + this.fieldPosition[0];
            result = 37 * result + this.fieldPosition[1];
            result = 37 * result + this.canonicalFieldName.hashCode();
            return result;
        }

        protected abstract IFieldInfo getNewInstance();

        IFieldInfo copy() {
            IFieldInfo result = this.getNewInstance();
            result.setNodeForErrors(this.nodeForErrors);
            result.setFieldLength(this.fieldLength);
            result.setFieldPosition(new int[]{this.fieldPosition[0], this.fieldPosition[1]});
            result.setCanonicalFieldName(this.canonicalFieldName);
            return result;
        }

        @Override
        public boolean isAttribute() {
            return false;
        }

        @Override
        public boolean isTextField() {
            return false;
        }

        @Override
        public boolean isPrintField() {
            return false;
        }
    }

    private static class FieldInfoPair {
        IFieldInfo firstInfo;
        IFieldInfo secondInfo;

        FieldInfoPair(IFieldInfo firstInfo, IFieldInfo secondInfo) {
            this.firstInfo = firstInfo;
            this.secondInfo = secondInfo;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof FieldInfoPair) {
                FieldInfoPair other = (FieldInfoPair)obj;
                return other.firstInfo.equals(this.firstInfo) && other.secondInfo.equals(this.secondInfo);
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.firstInfo.hashCode();
            result = 37 * result + this.secondInfo.hashCode();
            return result;
        }
    }

    private class FixedPrintFormGridValidator
    extends PrintFormGridValidator {
        private FixedPrintFormGridValidator() {
        }

        @Override
        protected void primAddScreenSize(int[] screenSize) {
            Node positionNode = FormValidator.this.getPositionNode();
            if (FormValidator.this.formPosition[0] > screenSize[0] || FormValidator.this.formPosition[1] > screenSize[1]) {
                FormValidator.this.problemRequestor.acceptProblem(positionNode, 5313, new String[]{"position", FormValidator.this.canonicalFormName});
            } else if (FormValidator.this.formPosition[0] + FormValidator.this.formSize[0] - 1 > screenSize[0] || FormValidator.this.formPosition[1] + FormValidator.this.formSize[1] - 1 > screenSize[1]) {
                FormValidator.this.problemRequestor.acceptProblem(FormValidator.this.getFormSizeNode(), 5313, new String[]{"formSize", FormValidator.this.canonicalFormName});
            }
        }
    }

    private class FixedTextFormGridValidator
    extends TextFormGridValidator {
        private FixedTextFormGridValidator() {
        }

        @Override
        protected int[] getFormPosition(int[] screenSize) {
            return FormValidator.this.formPosition;
        }

        @Override
        protected FormGrid primAddScreenSize(int[] screenSize) {
            FormGrid newFormGrid = super.primAddScreenSize(screenSize);
            IFormGridProblemAcceptor problemAcceptor = (IFormGridProblemAcceptor)this.formGridsToProblemCollectors.get(newFormGrid);
            if (FormValidator.this.formSize[0] > screenSize[0] || FormValidator.this.formSize[1] > screenSize[1]) {
                problemAcceptor.formSizeIsInvalid();
            } else if (FormValidator.this.formPosition[0] > screenSize[0] || FormValidator.this.formPosition[1] > screenSize[1]) {
                problemAcceptor.formPositionIsInvalid();
            } else if (FormValidator.this.formPosition[0] + FormValidator.this.formSize[0] - 1 > screenSize[0] || FormValidator.this.formPosition[1] + FormValidator.this.formSize[1] - 1 > screenSize[1]) {
                problemAcceptor.formSizeIsInvalid();
            }
            return newFormGrid;
        }

        @Override
        void reportFormContextProblems() {
            this.reportProblems(new IFormGridProblemAcceptor(){

                @Override
                public void fieldExtendsOutsideForm(IFieldInfo fieldInfo) {
                    FixedTextFormGridValidator.this.requestFieldExtendsOutsideFormProblem(fieldInfo);
                }

                @Override
                public void fieldsOverlap(IFieldInfo fieldOnGrid, IFieldInfo fieldBeingAdded) {
                    FixedTextFormGridValidator.this.requestOverlappingFieldsProblem(fieldOnGrid, fieldBeingAdded);
                }

                @Override
                public void fieldOutsideForm(IFieldInfo fieldInfo) {
                    FixedTextFormGridValidator.this.requestFieldOutsideFormProblem(fieldInfo);
                }

                @Override
                public void formPositionIsInvalid() {
                    ((FixedTextFormGridValidator)FixedTextFormGridValidator.this).FormValidator.this.problemRequestor.acceptProblem(FormValidator.this.getPositionNode(), 5314, new String[]{"position", FormValidator.this.canonicalFormName});
                }

                @Override
                public void formSizeIsInvalid() {
                    ((FixedTextFormGridValidator)FixedTextFormGridValidator.this).FormValidator.this.problemRequestor.acceptProblem(FormValidator.this.getFormSizeNode(), 5313, new String[]{"formSize", FormValidator.this.canonicalFormName});
                }
            });
        }

        @Override
        void reportFormGroupContextProblems() {
        }
    }

    private static class FloatingAreaInfo {
        int leftMargin;
        int topMargin;
        int[] size;
        boolean isDoubleByte;

        FloatingAreaInfo(int leftMargin, int topMargin, int[] size) {
            this.leftMargin = leftMargin;
            this.topMargin = topMargin;
            this.size = size;
        }

        boolean formOfSizeFits(int[] formSize) {
            return formSize[0] + this.topMargin <= this.size[0] && formSize[1] + this.leftMargin <= this.size[1];
        }
    }

    private class FloatingPrintFormGridValidator
    extends PrintFormGridValidator {
        private boolean isFormSizeProblem;
        private java.lang.Boolean formHasDBCharField;

        private FloatingPrintFormGridValidator() {
            this.isFormSizeProblem = false;
        }

        @Override
        void addFloatingArea(FloatingAreaInfo floatingAreaInfo) {
            if (!this.isFormSizeProblem && !floatingAreaInfo.formOfSizeFits(FormValidator.this.formSize)) {
                this.isFormSizeProblem = true;
            }
        }

        @Override
        void useDefaultFloatingArea() {
            FloatingAreaInfo floatingAreaInfo = null;
            floatingAreaInfo = this.getHasDBCharField() ? new FloatingAreaInfo(0, 0, new int[]{255, 158}) : new FloatingAreaInfo(0, 0, new int[]{255, 132});
            this.addFloatingArea(floatingAreaInfo);
        }

        @Override
        void reportFormGroupContextProblems() {
            super.reportFormGroupContextProblems();
            if (this.isFormSizeProblem) {
                FormValidator.this.problemRequestor.acceptProblem(FormValidator.this.getFormSizeNode(), 5313, new String[]{"formSize", FormValidator.this.canonicalFormName});
            }
        }

        private boolean getHasDBCharField() {
            if (this.formHasDBCharField == null) {
                this.formHasDBCharField = new java.lang.Boolean(FormValidator.hasDBCharField(FormValidator.this.formBinding));
            }
            return this.formHasDBCharField;
        }
    }

    private class FloatingTextFormGridValidator
    extends TextFormGridValidator {
        Map screenSizesToPositions;

        private FloatingTextFormGridValidator() {
            this.screenSizesToPositions = new HashMap();
        }

        @Override
        protected int[] getFormPosition(int[] screenSize) {
            int[] result = (int[])this.screenSizesToPositions.get(screenSize);
            if (result == null) {
                result = new int[]{1, 1};
            }
            return result;
        }

        @Override
        protected FormGrid primAddScreenSize(int[] screenSize) {
            FormGrid newFormGrid = super.primAddScreenSize(screenSize);
            IFormGridProblemAcceptor problemAcceptor = (IFormGridProblemAcceptor)this.formGridsToProblemCollectors.get(newFormGrid);
            if (FormValidator.this.formSize[0] > screenSize[0] || FormValidator.this.formSize[1] > screenSize[1]) {
                problemAcceptor.formSizeIsInvalid();
            }
            return newFormGrid;
        }

        @Override
        void addFloatingArea(FloatingAreaInfo floatingAreaInfo) {
            super.addFloatingArea(floatingAreaInfo);
            this.screenSizesToPositions.put(new IntAry(floatingAreaInfo.size), new int[]{floatingAreaInfo.topMargin + 1, floatingAreaInfo.leftMargin + 1});
            if (!floatingAreaInfo.formOfSizeFits(FormValidator.this.formSize)) {
                for (Object nextFormGrid : this.formGridsToProblemCollectors.keySet()) {
                    int[] nextScreenSize = (int[])this.formGridsToScreenSizes.get(nextFormGrid);
                    if (nextScreenSize == null || nextScreenSize[0] != floatingAreaInfo.size[0] || nextScreenSize[1] != floatingAreaInfo.size[1]) continue;
                    ((IFormGridProblemAcceptor)this.formGridsToProblemCollectors.get(nextFormGrid)).formSizeIsInvalid();
                }
            }
        }

        @Override
        void reportFormContextProblems() {
            this.reportProblems(new IFormGridProblemAcceptor(){

                @Override
                public void fieldExtendsOutsideForm(IFieldInfo fieldInfo) {
                }

                @Override
                public void fieldsOverlap(IFieldInfo fieldOnGrid, IFieldInfo fieldBeingAdded) {
                }

                @Override
                public void fieldOutsideForm(IFieldInfo fieldInfo) {
                    FloatingTextFormGridValidator.this.requestFieldOutsideFormProblem(fieldInfo);
                }

                @Override
                public void formPositionIsInvalid() {
                }

                @Override
                public void formSizeIsInvalid() {
                }
            });
        }

        @Override
        void reportFormGroupContextProblems() {
            this.reportProblems(new IFormGridProblemAcceptor(){

                @Override
                public void fieldExtendsOutsideForm(IFieldInfo fieldInfo) {
                    FloatingTextFormGridValidator.this.requestFieldExtendsOutsideFormProblem(fieldInfo);
                }

                @Override
                public void fieldsOverlap(IFieldInfo fieldOnGrid, IFieldInfo fieldBeingAdded) {
                    FloatingTextFormGridValidator.this.requestOverlappingFieldsProblem(fieldOnGrid, fieldBeingAdded);
                }

                @Override
                public void fieldOutsideForm(IFieldInfo fieldInfo) {
                }

                @Override
                public void formPositionIsInvalid() {
                }

                @Override
                public void formSizeIsInvalid() {
                    ((FloatingTextFormGridValidator)FloatingTextFormGridValidator.this).FormValidator.this.problemRequestor.acceptProblem(FormValidator.this.getFormSizeNode(), 5313, new String[]{"formSize", FormValidator.this.canonicalFormName});
                }
            });
        }
    }

    private static class FormGrid {
        private IFieldInfo[][] grid;
        boolean horizontalWrappingIsAllowed = false;
        boolean verticalWrappingIsAllowed = false;

        FormGrid(int[] formSize) {
            this.grid = new IFieldInfo[formSize[0]][formSize[1]];
        }

        void applyAttributeByte(IFieldInfo fieldInfo, IFormGridProblemAcceptor problemAcceptor, int[] formPosition) {
            int zeroBasedRow = fieldInfo.getFieldPosition()[0] - 1;
            int zeroBasedCol = fieldInfo.getFieldPosition()[1] - 1;
            if (zeroBasedRow < 0 || zeroBasedRow >= this.grid.length || zeroBasedCol < 0 || zeroBasedCol >= this.grid[0].length) {
                return;
            }
            int attributeRow = zeroBasedRow;
            int attributeColumn = zeroBasedCol - 1;
            if (attributeColumn == -1) {
                if (formPosition != null && formPosition[1] != 1) {
                    return;
                }
                attributeColumn = this.grid[0].length - 1;
                if (--attributeRow == -1) {
                    if (formPosition != null && formPosition[0] != 1) {
                        return;
                    }
                    attributeRow = this.grid.length - 1;
                }
            }
            if (attributeRow < 0 || attributeRow >= this.grid.length || attributeColumn < 0 || attributeColumn >= this.grid[0].length) {
                return;
            }
            IFieldInfo fieldAtPosition = this.grid[attributeRow][attributeColumn];
            AttributeFieldInfo afi = new AttributeFieldInfo(fieldInfo);
            if (fieldAtPosition == null) {
                this.grid[attributeRow][attributeColumn] = afi;
            } else {
                problemAcceptor.fieldsOverlap(fieldAtPosition, afi);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        void applyField(IFieldInfo fieldInfo, IFormGridProblemAcceptor problemAcceptor) {
            int zeroBasedRow = fieldInfo.getFieldPosition()[0] - 1;
            int zeroBasedCol = fieldInfo.getFieldPosition()[1] - 1;
            if (zeroBasedRow < 0 || zeroBasedCol < 0) {
                return;
            }
            int i = 0;
            while (i < fieldInfo.getFieldLength()) {
                if (zeroBasedRow >= this.grid.length || zeroBasedCol >= this.grid[0].length) {
                    problemAcceptor.fieldOutsideForm(fieldInfo);
                    return;
                }
                IFieldInfo fieldAtPosition = this.grid[zeroBasedRow][zeroBasedCol];
                if (fieldAtPosition == null) {
                    this.grid[zeroBasedRow][zeroBasedCol] = fieldInfo;
                } else {
                    problemAcceptor.fieldsOverlap(fieldAtPosition, fieldInfo);
                }
                if (i != fieldInfo.getFieldLength() - 1 && ++zeroBasedCol == this.grid[0].length) {
                    if (fieldInfo.canExtendBeyondFormBoundary()) {
                        return;
                    }
                    if (!this.horizontalWrappingIsAllowed && !fieldInfo.canAlwaysWrap()) {
                        problemAcceptor.fieldExtendsOutsideForm(fieldInfo);
                        return;
                    }
                    zeroBasedCol = 0;
                    if (++zeroBasedRow == this.grid.length) {
                        if (!this.verticalWrappingIsAllowed && !fieldInfo.canAlwaysWrap()) {
                            problemAcceptor.fieldExtendsOutsideForm(fieldInfo);
                            return;
                        }
                        zeroBasedRow = 0;
                    }
                }
                ++i;
            }
        }
    }

    private static class FormGridProblemCollector
    implements IFormGridProblemAcceptor {
        List overlappingFieldProblems = new ArrayList();
        List fieldOutsideFormProblems = new ArrayList();
        List fieldExtendingOutsideFormProblems = new ArrayList();
        boolean formSizeIsInvalid = false;
        boolean formPositionInvalid = false;
        boolean hasProblem = false;

        private FormGridProblemCollector() {
        }

        @Override
        public void fieldsOverlap(IFieldInfo fieldOnGrid, IFieldInfo fieldBeingAdded) {
            FieldInfoPair fInfoPair = new FieldInfoPair(fieldOnGrid, fieldBeingAdded);
            if (!this.overlappingFieldProblems.contains(fInfoPair)) {
                this.overlappingFieldProblems.add(fInfoPair);
            }
            this.hasProblem = true;
        }

        @Override
        public void fieldOutsideForm(IFieldInfo fieldInfo) {
            if (!this.fieldOutsideFormProblems.contains(fieldInfo)) {
                this.fieldOutsideFormProblems.add(fieldInfo);
            }
            this.hasProblem = true;
        }

        @Override
        public void fieldExtendsOutsideForm(IFieldInfo fieldInfo) {
            if (!this.fieldExtendingOutsideFormProblems.contains(fieldInfo)) {
                this.fieldExtendingOutsideFormProblems.add(fieldInfo);
            }
            this.hasProblem = true;
        }

        @Override
        public void formPositionIsInvalid() {
            this.formPositionInvalid = true;
            this.hasProblem = true;
        }

        @Override
        public void formSizeIsInvalid() {
            this.formSizeIsInvalid = true;
            this.hasProblem = true;
        }
    }

    private abstract class FormGridValidator {
        private FormGridValidator() {
        }

        abstract void applyFieldToGrid(IFieldInfo var1);

        abstract void addFloatingArea(FloatingAreaInfo var1);

        abstract void useDefaultFloatingArea();

        abstract void addScreenSize(int[] var1);

        abstract void reportFormContextProblems();

        abstract void reportFormGroupContextProblems();

        protected void requestOverlappingFieldsProblem(IFieldInfo fieldOnGrid, IFieldInfo fieldBeingAdded) {
            int sev = 2;
            if (fieldOnGrid.isAttribute() && fieldBeingAdded.isPrintField() || fieldOnGrid.isPrintField() && fieldBeingAdded.isAttribute()) {
                sev = 1;
            }
            FormValidator.this.problemRequestor.acceptProblem(fieldBeingAdded.getNodeForErrors(), 5337, sev, new String[]{FormValidator.this.canonicalFormName, fieldOnGrid.getCanonicalFieldName(), fieldBeingAdded.getCanonicalFieldName()});
        }

        protected void requestFieldOutsideFormProblem(IFieldInfo fieldInfo) {
            FormValidator.this.problemRequestor.acceptProblem(fieldInfo.getNodeForErrors(), 5338, new String[]{FormValidator.this.canonicalFormName, fieldInfo.getCanonicalFieldName()});
        }

        protected void requestFieldExtendsOutsideFormProblem(IFieldInfo fieldInfo) {
            FormValidator.this.problemRequestor.acceptProblem(fieldInfo.getNodeForErrors(), 5387, new String[]{FormValidator.this.canonicalFormName, fieldInfo.getCanonicalFieldName()});
        }
    }

    private static interface IFieldInfo {
        public boolean isAttribute();

        public boolean isPrintField();

        public boolean isTextField();

        public boolean canExtendBeyondFormBoundary();

        public boolean canAlwaysWrap();

        public boolean isCursor();

        public Integer getValidationOrder();

        public Node getNodeForErrors();

        public int getFieldLength();

        public int[] getFieldPosition();

        public String getCanonicalFieldName();

        public FormFieldBinding getFieldBinding();

        public void setNodeForErrors(Node var1);

        public void setFieldLength(int var1);

        public void setFieldPosition(int[] var1);

        public void setCanonicalFieldName(String var1);

        public void setFieldBinding(FormFieldBinding var1);

        public void setIndex(int var1);

        public int getIndex();

        public boolean isCursorOnSpecificIndex();
    }

    private static interface IFormGridProblemAcceptor {
        public void fieldsOverlap(IFieldInfo var1, IFieldInfo var2);

        public void fieldOutsideForm(IFieldInfo var1);

        public void fieldExtendsOutsideForm(IFieldInfo var1);

        public void formSizeIsInvalid();

        public void formPositionIsInvalid();
    }

    private static class IntAry {
        int[] intAry;

        IntAry(int[] intAry) {
            this.intAry = intAry;
        }

        public boolean equals(Object obj) {
            if (obj instanceof IntAry) {
                IntAry other = (IntAry)obj;
                if (this.intAry.length == other.intAry.length) {
                    int i = 0;
                    while (i < this.intAry.length) {
                        if (this.intAry[i] != other.intAry[i]) {
                            return false;
                        }
                        ++i;
                    }
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            int i = 0;
            while (i < this.intAry.length) {
                result = 37 * result + this.intAry[i];
                ++i;
            }
            return result;
        }
    }

    private static abstract class PrintFormFieldInfo
    extends FieldInfo {
        private PrintFormFieldInfo() {
        }

        @Override
        public boolean canExtendBeyondFormBoundary() {
            return true;
        }

        @Override
        public boolean isCursor() {
            return false;
        }

        @Override
        public Integer getValidationOrder() {
            return null;
        }

        @Override
        public boolean isPrintField() {
            return true;
        }
    }

    private abstract class PrintFormGridValidator
    extends FormGridValidator
    implements IFormGridProblemAcceptor {
        private FormGrid formGrid;
        private List overlappingFieldsProblems = new ArrayList();
        private List fieldOutsideFormProblems = new ArrayList();

        public PrintFormGridValidator() {
            this.formGrid = new FormGrid(FormValidator.this.formSize);
        }

        @Override
        void applyFieldToGrid(IFieldInfo fieldInfo) {
            this.formGrid.applyField(fieldInfo, this);
            this.formGrid.applyAttributeByte(fieldInfo, this, FormValidator.this.formPosition);
        }

        @Override
        public void fieldsOverlap(IFieldInfo fieldOnGrid, IFieldInfo fieldBeingAdded) {
            FieldInfoPair fInfoPair = new FieldInfoPair(fieldOnGrid, fieldBeingAdded);
            if (!this.overlappingFieldsProblems.contains(fInfoPair)) {
                this.overlappingFieldsProblems.add(fInfoPair);
            } else if (!fieldOnGrid.isAttribute() && !fieldBeingAdded.isAttribute()) {
                this.overlappingFieldsProblems.remove(fInfoPair);
                this.overlappingFieldsProblems.add(fInfoPair);
            }
        }

        @Override
        public void fieldOutsideForm(IFieldInfo fieldInfo) {
            if (!this.fieldOutsideFormProblems.contains(fieldInfo)) {
                this.fieldOutsideFormProblems.add(fieldInfo);
            }
        }

        @Override
        public void fieldExtendsOutsideForm(IFieldInfo fieldInfo) {
            throw new RuntimeException("This should not happen.");
        }

        @Override
        public void formPositionIsInvalid() {
        }

        @Override
        public void formSizeIsInvalid() {
        }

        @Override
        void reportFormContextProblems() {
            for (Object nextProblem : this.overlappingFieldsProblems) {
                this.requestOverlappingFieldsProblem(((FieldInfoPair)nextProblem).firstInfo, ((FieldInfoPair)nextProblem).secondInfo);
            }
            for (Object nextProblem : this.fieldOutsideFormProblems) {
                this.requestFieldOutsideFormProblem((IFieldInfo)nextProblem);
            }
        }

        @Override
        void reportFormGroupContextProblems() {
        }

        @Override
        void addFloatingArea(FloatingAreaInfo floatingAreaInfo) {
        }

        @Override
        void addScreenSize(int[] screenSize) {
            if (FormValidator.this.formSize[0] > screenSize[0] || FormValidator.this.formSize[1] > screenSize[1]) {
                FormValidator.this.problemRequestor.acceptProblem(FormValidator.this.getFormSizeNode(), 5313, new String[]{"formSize", FormValidator.this.canonicalFormName});
            } else {
                this.primAddScreenSize(screenSize);
            }
        }

        protected void primAddScreenSize(int[] screenSize) {
        }

        @Override
        void useDefaultFloatingArea() {
        }
    }

    private static abstract class TextFormFieldInfo
    extends FieldInfo {
        private TextFormFieldInfo() {
        }

        @Override
        public boolean canExtendBeyondFormBoundary() {
            return false;
        }

        @Override
        public boolean isCursor() {
            IAnnotationBinding aBinding;
            if (this.getIndex() > 1) {
                aBinding = this.getFieldBinding().getAnnotation(EGLUITEXT, "Cursor", this.getIndex());
                if (aBinding == this.getFieldBinding().getAnnotation(EGLUITEXT, "Cursor")) {
                    aBinding = null;
                }
            } else {
                aBinding = this.getIndex() == 1 ? this.getFieldBinding().getAnnotation(EGLUITEXT, "Cursor", this.getIndex()) : this.getFieldBinding().getAnnotation(EGLUITEXT, "Cursor");
            }
            if (aBinding != null) {
                return Boolean.YES == aBinding.getValue();
            }
            return false;
        }

        @Override
        public Integer getValidationOrder() {
            IAnnotationBinding aBinding = this.getFieldBinding().getAnnotation(EGLUI, "ValidationOrder");
            if (aBinding != null) {
                try {
                    return new Integer(aBinding.getValue().toString());
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            return null;
        }

        @Override
        public boolean isTextField() {
            return true;
        }
    }

    private abstract class TextFormGridValidator
    extends FormGridValidator {
        private final List defaultScreenSizes = Arrays.asList({12, 80}, {24, 80}, {32, 80}, {43, 80}, {27, 132});
        protected Map formGridsToProblemCollectors = new HashMap();
        protected Map formGridsToScreenSizes = new HashMap();
        protected boolean usingDefaultScreenSizes = false;
        private FormGrid firstFormGrid;
        protected Set screenSizesWhichFit = new HashSet();

        private int[] getMatchingDefaultScreenSize(int[] formSize) {
            for (int[] nextScreenSize : this.defaultScreenSizes) {
                if (nextScreenSize[0] != formSize[0] || nextScreenSize[1] != formSize[1]) continue;
                return nextScreenSize;
            }
            return null;
        }

        TextFormGridValidator() {
        }

        @Override
        void addScreenSize(int[] screenSize) {
            this.primAddScreenSize(screenSize);
        }

        protected FormGrid primAddScreenSize(int[] screenSize) {
            FormGrid newFormGrid = new FormGrid(FormValidator.this.formSize);
            newFormGrid.horizontalWrappingIsAllowed = screenSize[1] == FormValidator.this.formSize[1];
            newFormGrid.verticalWrappingIsAllowed = screenSize[0] == FormValidator.this.formSize[0];
            this.formGridsToProblemCollectors.put(newFormGrid, new FormGridProblemCollector());
            this.formGridsToScreenSizes.put(newFormGrid, screenSize);
            if (this.firstFormGrid == null) {
                this.firstFormGrid = newFormGrid;
            }
            return newFormGrid;
        }

        protected abstract int[] getFormPosition(int[] var1);

        private void verifyFormGridsToProblemCollectorsNotEmpty() {
            if (this.formGridsToProblemCollectors.isEmpty()) {
                int[] matchingDefaultScreenSize = this.getMatchingDefaultScreenSize(FormValidator.this.formSize);
                if (matchingDefaultScreenSize == null) {
                    this.usingDefaultScreenSizes = true;
                    Iterator iter = this.defaultScreenSizes.iterator();
                    while (iter.hasNext()) {
                        this.primAddScreenSize((int[])iter.next());
                    }
                } else {
                    this.primAddScreenSize(matchingDefaultScreenSize);
                }
            }
        }

        @Override
        void applyFieldToGrid(IFieldInfo fieldInfo) {
            this.verifyFormGridsToProblemCollectorsNotEmpty();
            for (FormGrid nextFormGrid : this.formGridsToProblemCollectors.keySet()) {
                IFormGridProblemAcceptor problemAcceptor = (IFormGridProblemAcceptor)this.formGridsToProblemCollectors.get(nextFormGrid);
                nextFormGrid.applyAttributeByte(fieldInfo, problemAcceptor, FormValidator.this.formPosition);
                nextFormGrid.applyField(fieldInfo, problemAcceptor);
            }
        }

        protected void reportProblems(IFormGridProblemAcceptor problemAcceptor) {
            this.verifyFormGridsToProblemCollectorsNotEmpty();
            if (this.usingDefaultScreenSizes) {
                for (FormGrid nextFormGrid : this.formGridsToProblemCollectors.keySet()) {
                    FormGridProblemCollector nextProblemCollector = (FormGridProblemCollector)this.formGridsToProblemCollectors.get(nextFormGrid);
                    if (nextProblemCollector.hasProblem) continue;
                    this.screenSizesWhichFit.add(new IntAry((int[])this.formGridsToScreenSizes.get(nextFormGrid)));
                    return;
                }
                Object firstFormGridsProblems = this.formGridsToProblemCollectors.get(this.firstFormGrid);
                this.formGridsToProblemCollectors.clear();
                this.formGridsToProblemCollectors.put(this.firstFormGrid, firstFormGridsProblems);
            }
            boolean firstPass = true;
            boolean issuedError = false;
            Iterator iter = this.formGridsToProblemCollectors.keySet().iterator();
            while (iter.hasNext() && !issuedError) {
                FormGrid nextFormGrid = (FormGrid)iter.next();
                FormGridProblemCollector problemCollector = (FormGridProblemCollector)this.formGridsToProblemCollectors.get(nextFormGrid);
                if (firstPass) {
                    for (Object nextProblem : problemCollector.fieldOutsideFormProblems) {
                        problemAcceptor.fieldOutsideForm((IFieldInfo)nextProblem);
                        issuedError = true;
                    }
                    firstPass = false;
                }
                if (!problemCollector.overlappingFieldProblems.isEmpty()) {
                    for (Object nextProblem : problemCollector.overlappingFieldProblems) {
                        problemAcceptor.fieldsOverlap(((FieldInfoPair)nextProblem).firstInfo, ((FieldInfoPair)nextProblem).secondInfo);
                        issuedError = true;
                    }
                }
                if (!problemCollector.fieldExtendingOutsideFormProblems.isEmpty()) {
                    for (Object nextProblem : problemCollector.fieldExtendingOutsideFormProblems) {
                        problemAcceptor.fieldExtendsOutsideForm((IFieldInfo)nextProblem);
                        issuedError = true;
                    }
                }
                if (problemCollector.formSizeIsInvalid) {
                    problemAcceptor.formSizeIsInvalid();
                    issuedError = true;
                }
                if (problemCollector.formPositionInvalid) {
                    problemAcceptor.formPositionIsInvalid();
                    issuedError = true;
                }
                if (issuedError) continue;
                this.screenSizesWhichFit.add(new IntAry((int[])this.formGridsToScreenSizes.get(nextFormGrid)));
            }
        }

        @Override
        void addFloatingArea(FloatingAreaInfo floatingAreaInfo) {
        }

        @Override
        void useDefaultFloatingArea() {
        }
    }

    private static class VariablePrintFormFieldInfo
    extends PrintFormFieldInfo {
        private VariablePrintFormFieldInfo() {
        }

        @Override
        protected IFieldInfo getNewInstance() {
            return new VariablePrintFormFieldInfo();
        }

        @Override
        public boolean canAlwaysWrap() {
            return false;
        }
    }

    private static class VariableTextFormFieldInfo
    extends TextFormFieldInfo {
        private VariableTextFormFieldInfo() {
        }

        @Override
        protected IFieldInfo getNewInstance() {
            return new VariableTextFormFieldInfo();
        }

        @Override
        public boolean canAlwaysWrap() {
            return false;
        }
    }
}

