/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.part;

import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.binding.FunctionBinding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.NestedFunctionBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.PrimitiveType;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class ServiceInterfaceValidatorUtil {
    public static void validateParametersAndReturn(final NestedFunction thisnestedFunction, boolean isService, final IProblemRequestor problemRequestor) {
        final boolean isOneWay = ServiceInterfaceValidatorUtil.isOneWay(thisnestedFunction);
        thisnestedFunction.accept(new AbstractASTVisitor(){
            Node outparm = null;

            @Override
            public boolean visit(FunctionParameter functionParameter) {
                ITypeBinding typeBinding;
                if (functionParameter.isParmConst()) {
                    problemRequestor.acceptProblem((Node)functionParameter, 4962, new String[]{functionParameter.getName().getCanonicalName(), thisnestedFunction.getName().getCanonicalName()});
                }
                if (isOneWay && !this.isIn(functionParameter)) {
                    problemRequestor.acceptProblem((Node)functionParameter, 4963, new String[]{functionParameter.getName().getCanonicalName(), thisnestedFunction.getName().getCanonicalName()});
                }
                if (StatementValidator.isValidBinding(typeBinding = functionParameter.getType().resolveTypeBinding())) {
                    if (functionParameter.getType().isPrimitiveType()) {
                        PrimitiveType primType = (PrimitiveType)functionParameter.getType();
                        Primitive prim = primType.getPrimitive();
                        if (Primitive.isLooseType(prim, ((PrimitiveTypeBinding)typeBinding).getLength())) {
                            problemRequestor.acceptProblem(functionParameter.getType(), 7803);
                        }
                    } else if (!functionParameter.getType().isNameType() || typeBinding.getKind() == 17) {
                        // empty if block
                    }
                    if (ServiceInterfaceValidatorUtil.isUnsupportedTypeInServicesAndInterfaces(typeBinding)) {
                        problemRequestor.acceptProblem((Node)functionParameter.getType(), 7804, new String[]{typeBinding.getCaseSensitiveName()});
                    }
                    if (functionParameter.getAttrType() == FunctionParameter.AttrType.FIELD) {
                        problemRequestor.acceptProblem(functionParameter, 7806);
                    }
                }
                return false;
            }

            private boolean isIn(FunctionParameter parm) {
                if (parm.getName().resolveBinding() instanceof FunctionParameterBinding) {
                    return ((FunctionParameterBinding)parm.getName().resolveBinding()).isInput();
                }
                return parm.getUseType() == FunctionParameter.UseType.IN;
            }

            @Override
            public void endVisit(NestedFunction nestedFunction) {
                if (nestedFunction.hasReturnType()) {
                    ITypeBinding typeBinding = nestedFunction.getReturnType().resolveTypeBinding();
                    if (StatementValidator.isValidBinding(typeBinding) && ServiceInterfaceValidatorUtil.isUnsupportedTypeInServicesAndInterfaces(typeBinding)) {
                        problemRequestor.acceptProblem((Node)nestedFunction.getReturnType(), 7805, new String[]{typeBinding.getCaseSensitiveName()});
                    }
                    if (isOneWay) {
                        problemRequestor.acceptProblem((Node)nestedFunction.getReturnType(), 4964, new String[0]);
                    }
                }
            }
        });
    }

    public static boolean isUnsupportedTypeInServicesAndInterfaces(ITypeBinding typeBinding) {
        switch (typeBinding.getKind()) {
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 27: {
                return true;
            }
            case 3: {
                PrimitiveTypeBinding primitiveBinding = (PrimitiveTypeBinding)typeBinding;
                Primitive primitive = primitiveBinding.getPrimitive();
                return primitive == Primitive.ANY;
            }
        }
        return false;
    }

    private static FunctionBinding getFunctionByName(String name, List list) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            FunctionBinding next = (FunctionBinding)((NestedFunctionBinding)iter.next()).getType();
            if (InternUtil.intern((String)next.getName()) != InternUtil.intern((String)name)) continue;
            return next;
        }
        return null;
    }

    private static boolean isOneWay(NestedFunction functionAst) {
        IAnnotationBinding ann;
        IBinding binding = functionAst.getName().resolveBinding();
        if (StatementValidator.isValidBinding(binding) && (ann = binding.getAnnotation(new String[]{"eglx", "services"}, "oneway")) != null) {
            Object value = ann.getValue();
            if (value instanceof java.lang.Boolean) {
                return (java.lang.Boolean)value;
            }
            if (value instanceof Boolean) {
                return value == Boolean.YES;
            }
        }
        return false;
    }
}

