/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.CloseStatement;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.validation.statement.IOStatementValidatorConstants;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;

public class CloseStatementValidator
extends DefaultASTVisitor
implements IOStatementValidatorConstants {
    private IProblemRequestor problemRequestor;

    public CloseStatementValidator(IProblemRequestor problemRequestor) {
        this.problemRequestor = problemRequestor;
    }

    @Override
    public boolean visit(CloseStatement closeStatement) {
        StatementValidator.validateIOTargetsContainer(closeStatement.getIOObjects(), this.problemRequestor);
        Expression expr = closeStatement.getExpr();
        ITypeBinding typeBinding = expr.resolveTypeBinding();
        if (!StatementValidator.isValidBinding(typeBinding)) {
            return false;
        }
        if (typeBinding.getAnnotation(EGLIOFILE, "IndexedRecord") != null || typeBinding.getAnnotation(EGLIOMQ, "MQRecord") != null || typeBinding.getAnnotation(EGLUITEXT, "PrintForm") != null || typeBinding.getAnnotation(EGLIOFILE, "RelativeRecord") != null || typeBinding.getAnnotation(EGLIOFILE, "SerialRecord") != null || typeBinding.getAnnotation(EGLIOFILE, "CSVRecord") != null || typeBinding.getAnnotation(EGLIOSQL, "SQLRecord") != null) {
            return false;
        }
        this.problemRequestor.acceptProblem((Node)expr, 6659, new String[]{expr.getCanonicalString()});
        return false;
    }
}

