/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.edt.compiler.binding.HandlerBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTPartVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ForwardStatement;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.ParenthesizedExpression;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.PassingClause;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.ReturningToNameClause;
import org.eclipse.edt.compiler.core.ast.StringLiteral;
import org.eclipse.edt.compiler.core.ast.SubstringAccess;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.utils.TypeCompatibilityUtil;
import org.eclipse.edt.compiler.internal.core.validation.statement.IOStatementValidatorConstants;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class ForwardStatementValidator
extends DefaultASTVisitor
implements IOStatementValidatorConstants {
    private IProblemRequestor problemRequestor;
    private ICompilerOptions compilerOptions;

    public ForwardStatementValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public boolean visit(ForwardStatement forwardStatement) {
        StatementValidator.validateIOTargetsContainer(forwardStatement.getIOObjects(), this.problemRequestor);
        if (forwardStatement.getArguments().size() > 0 && forwardStatement.isForwardToURL()) {
            this.problemRequestor.acceptProblem((Expression)forwardStatement.getArguments().get(0), 7778);
        }
        this.checkPageHandlerArguments(forwardStatement);
        this.validatePassing(forwardStatement);
        this.validateContainer(forwardStatement);
        if (forwardStatement.isForwardToURL()) {
            Expression aexpr = forwardStatement.getForwardTarget();
            aexpr.accept(new AbstractASTExpressionVisitor(){

                @Override
                public boolean visitExpression(Expression expr) {
                    ITypeBinding typeBinding = expr.resolveTypeBinding();
                    if (!TypeCompatibilityUtil.isMoveCompatible(PrimitiveTypeBinding.getInstance(Primitive.CHAR), typeBinding, expr, ForwardStatementValidator.this.compilerOptions)) {
                        ForwardStatementValidator.this.problemRequestor.acceptProblem(expr, 7777);
                    }
                    return false;
                }

                @Override
                public boolean visit(StringLiteral stringLiteral) {
                    return false;
                }
            });
        }
        if ((this.hasReturningToNameClause(forwardStatement) || !forwardStatement.hasForwardTarget()) && forwardStatement.getArguments().size() != 1) {
            this.problemRequestor.acceptProblem(forwardStatement, 5178);
        }
        return false;
    }

    private void validateContainer(final ForwardStatement forwardStatement) {
        Node parent = forwardStatement.getParent();
        Node child = forwardStatement;
        while (parent.getParent() != null) {
            child = parent;
            parent = parent.getParent();
        }
        ((Node)child).accept(new AbstractASTPartVisitor(){

            @Override
            public boolean visit(Program program) {
                this.addError();
                return false;
            }

            @Override
            public boolean visit(Library lib) {
                this.addError();
                return false;
            }

            @Override
            public void visitPart(Part part) {
            }

            protected void addError() {
                ForwardStatementValidator.this.problemRequestor.acceptProblem((Node)forwardStatement, 6558, new String[]{"forward"});
            }
        });
    }

    private void validatePassing(final ForwardStatement forwardStatement) {
        forwardStatement.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(PassingClause passingClause) {
                Expression expr = passingClause.getExpression();
                ITypeBinding typeBinding = expr.resolveTypeBinding();
                if (StatementValidator.isValidBinding(typeBinding)) {
                    if (typeBinding.getKind() != 6 && typeBinding.getKind() != 7) {
                        ForwardStatementValidator.this.problemRequestor.acceptProblem((Node)expr, 6541, new String[]{expr.getCanonicalString()});
                    } else if (typeBinding.getAnnotation(EGLIODLI, "PSBRecord") != null) {
                        ForwardStatementValidator.this.problemRequestor.acceptProblem((Node)expr, 7933, new String[]{expr.getCanonicalString()});
                    }
                }
                if (!ForwardStatementValidator.this.hasReturningToNameClause(forwardStatement)) {
                    ForwardStatementValidator.this.problemRequestor.acceptProblem(passingClause, 5182);
                }
                return false;
            }
        });
    }

    private void checkPageHandlerArguments(ForwardStatement forwardStatement) {
        if (forwardStatement.getArguments().size() == 0) {
            return;
        }
        if (this.isForwardUIRecord(forwardStatement)) {
            Expression expr = (Expression)forwardStatement.getArguments().get(0);
            ITypeBinding typeBinding = expr.resolveTypeBinding();
            if (StatementValidator.isValidBinding(typeBinding)) {
                if (typeBinding.getAnnotation(EGLUIWEBTRANSACTION, "VGUIRecord") == null) {
                    this.problemRequestor.acceptProblem((Node)expr, 5191, new String[]{expr.getCanonicalString()});
                } else {
                    this.validateReturningTo(forwardStatement, typeBinding);
                }
            }
            return;
        }
        ArrayList arglist = new ArrayList();
        boolean argsValid = this.getForwardStatementArgTypes(forwardStatement, arglist);
        if (argsValid) {
            if (forwardStatement.isForwardToLabel()) {
                ITypeBinding[] forwardArgs = arglist.toArray(new ITypeBinding[arglist.size()]);
                HandlerBinding pageHandler = this.getTargetPageHandler(forwardStatement);
                if (pageHandler == null) {
                    return;
                }
                IDataBinding onConstructionFunctionDBinding = pageHandler.getAnnotation(EGLUIJSF, "JSFHandler").findData(InternUtil.intern((String)"onConstructionFunction"));
                if (IBinding.NOT_FOUND_BINDING != onConstructionFunctionDBinding) {
                    this.validateArguments(forwardStatement, forwardArgs, onConstructionFunctionDBinding);
                } else {
                    this.problemRequestor.acceptProblem(forwardStatement.getForwardTarget(), 6712);
                }
                IDataBinding onPreRenderFunctionDBinding = pageHandler.getAnnotation(EGLUIJSF, "JSFHandler").findData(InternUtil.intern((String)"onPreRenderFunction"));
                if (IBinding.NOT_FOUND_BINDING != onConstructionFunctionDBinding) {
                    this.validateArguments(forwardStatement, forwardArgs, onPreRenderFunctionDBinding);
                }
            }
            Iterator iter = forwardStatement.getArguments().iterator();
            while (iter.hasNext()) {
                ((Expression)iter.next()).accept(new DefaultASTVisitor(){

                    @Override
                    public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                        return true;
                    }

                    @Override
                    public boolean visit(SubstringAccess substringAccess) {
                        ForwardStatementValidator.this.problemRequestor.acceptProblem(substringAccess, 3364);
                        return false;
                    }
                });
            }
        }
    }

    private void validateArguments(ForwardStatement forwardStatement, ITypeBinding[] forwardArgs, IDataBinding functionDBinding) {
        Object value;
        if (functionDBinding != null && IBinding.NOT_FOUND_BINDING != functionDBinding && (value = ((IAnnotationBinding)functionDBinding).getValue()) != null && value != IBinding.NOT_FOUND_BINDING) {
            ITypeBinding[] paramtypes;
            IFunctionBinding funcBinding = (IFunctionBinding)value;
            String funcName = funcBinding.getName();
            if (StatementValidator.isValidBinding(funcBinding) && !StatementValidator.checkArguments(paramtypes = this.getFunctionParamTypes(funcBinding), forwardArgs, this.compilerOptions)) {
                this.problemRequestor.acceptProblem((Node)forwardStatement.getForwardTarget(), 6708, new String[]{funcName, StatementValidator.getParmListString(paramtypes), StatementValidator.getParmListString(forwardArgs)});
            }
        }
    }

    private HandlerBinding getTargetPageHandler(ForwardStatement forwardStatement) {
        HandlerBinding pageHandler = null;
        ITypeBinding binding = forwardStatement.getForwardTarget().resolveTypeBinding();
        if (StatementValidator.isValidBinding(binding) && binding.getAnnotation(EGLUIJSF, "JSFHandler") != null) {
            pageHandler = (HandlerBinding)binding;
        }
        return pageHandler;
    }

    private boolean getForwardStatementArgTypes(ForwardStatement forwardStatement, ArrayList arglist) {
        boolean argsValid = true;
        for (Expression expr : forwardStatement.getArguments()) {
            ITypeBinding typeBinding = expr.resolveTypeBinding();
            if (StatementValidator.isValidBinding(typeBinding)) {
                if (!this.isValidArg(typeBinding)) {
                    argsValid = false;
                    this.problemRequestor.acceptProblem((Node)expr, 5192, new String[]{expr.getCanonicalString()});
                }
            } else {
                argsValid = false;
            }
            arglist.add(typeBinding);
        }
        return argsValid;
    }

    private ITypeBinding[] getFunctionParamTypes(IFunctionBinding funcBinding) {
        ArrayList<ITypeBinding> list = new ArrayList<ITypeBinding>();
        for (IDataBinding binding : funcBinding.getParameters()) {
            list.add(binding.getType());
        }
        return list.toArray(new ITypeBinding[list.size()]);
    }

    private boolean hasReturningToNameClause(ForwardStatement forwardStatement) {
        ReturnBooleanASTVisitor visitor = new ReturnBooleanASTVisitor(){

            @Override
            public boolean visit(ReturningToNameClause returningToNameClause) {
                this.bool = true;
                return true;
            }
        };
        forwardStatement.accept(visitor);
        return visitor.hasBool();
    }

    private boolean isForwardUIRecord(ForwardStatement stmt) {
        if (stmt.getArguments().size() != 1) {
            return false;
        }
        if (stmt.hasForwardTarget()) {
            return false;
        }
        if (this.hasReturningToNameClause(stmt)) {
            return true;
        }
        return true;
    }

    private void validateReturningTo(ForwardStatement forwardStatement, final ITypeBinding uirecBinding) {
        forwardStatement.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(ReturningToNameClause returningToNameClause) {
                ITypeBinding typeBinding;
                String pgmName = returningToNameClause.getName().getCanonicalName();
                if (StatementValidator.isValidBinding(returningToNameClause.getName().resolveBinding()) && returningToNameClause.getName().resolveBinding().isTypeBinding() && (typeBinding = (ITypeBinding)returningToNameClause.getName().resolveBinding()).getKind() == 13) {
                    if (typeBinding.getAnnotation(EGLUIWEBTRANSACTION, "VGWebTransaction") != null) {
                        IDataBinding dataBinding;
                        IDataBinding inputUIRecordDBinding = typeBinding.getAnnotation(EGLUIWEBTRANSACTION, "VGWebTransaction").findData(InternUtil.intern((String)"inputUIRecord"));
                        if (IBinding.NOT_FOUND_BINDING != inputUIRecordDBinding && StatementValidator.isValidBinding(dataBinding = (IDataBinding)((IAnnotationBinding)inputUIRecordDBinding).getValue()) && StatementValidator.isValidBinding(dataBinding.getType()) && dataBinding.getType() == uirecBinding) {
                            return false;
                        }
                        ForwardStatementValidator.this.problemRequestor.acceptProblem((Node)returningToNameClause.getName(), 5194, new String[]{pgmName});
                    } else {
                        ForwardStatementValidator.this.problemRequestor.acceptProblem((Node)returningToNameClause.getName(), 5195, new String[]{pgmName});
                    }
                }
                return false;
            }
        });
    }

    private boolean isValidArg(ITypeBinding type) {
        if (type.getKind() == 3 && ((PrimitiveTypeBinding)type).getPrimitive() != Primitive.ANY) {
            return true;
        }
        if (type.getKind() == 6 || type.getKind() == 7) {
            return true;
        }
        return type.getKind() == 2;
    }

    private class ReturnBooleanASTVisitor
    extends AbstractASTVisitor {
        boolean bool = false;

        private ReturnBooleanASTVisitor() {
        }

        public boolean hasBool() {
            return this.bool;
        }
    }
}

