/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.statement.IOStatementValidatorConstants;

public class IOStatementValidator
extends DefaultASTVisitor
implements IOStatementValidatorConstants {
    protected IProblemRequestor problemRequestor;
    protected ICompilerOptions compilerOptions;
    protected boolean isSQLTarget = false;
    private Set declaredClauseNames = new HashSet();
    protected static Set NO_CURSOR_USINGKEYS = new HashSet<String>(Arrays.asList("noCursor", "usingKeys"));

    public IOStatementValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    protected void checkMutuallyExclusiveClauses(Set mutuallyExclusiveClauseNames, String clauseName, Node nodeForErrors) {
        for (String mutuallyExclusiveClauseName : mutuallyExclusiveClauseNames) {
            if (clauseName.equals(mutuallyExclusiveClauseName) || !this.declaredClauseNames.contains(mutuallyExclusiveClauseName)) continue;
            this.problemRequestor.acceptProblem(nodeForErrors, 3457, new String[]{clauseName.toUpperCase(), mutuallyExclusiveClauseName.toUpperCase()});
            return;
        }
        this.declaredClauseNames.add(clauseName);
    }

    protected void checkIsSQLTarget(String clauseKeyword, Node errorNode) {
    }
}

