/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.binding.AmbiguousDataBinding;
import org.eclipse.edt.compiler.binding.ArrayDictionaryBinding;
import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.DictionaryBinding;
import org.eclipse.edt.compiler.binding.FixedRecordBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.FormBinding;
import org.eclipse.edt.compiler.binding.FormFieldBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.MultiplyOccuringItemTypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.ArrayAccess;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FieldAccess;
import org.eclipse.edt.compiler.core.ast.IntegerLiteral;
import org.eclipse.edt.compiler.core.ast.MoveStatement;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.ParenthesizedExpression;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.SubstringAccess;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.utils.TypeCompatibilityUtil;
import org.eclipse.edt.compiler.internal.core.validation.statement.LValueValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.RValueValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class MoveStatementValidator
extends DefaultASTVisitor {
    private IProblemRequestor problemRequestor;
    private MoveStatement moveStmt;
    private ICompilerOptions compilerOptions;
    private IPartBinding enclosingPart;

    public MoveStatementValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions, IPartBinding enclosingPart) {
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
        this.enclosingPart = enclosingPart;
    }

    @Override
    public boolean visit(MoveStatement moveStatement) {
        this.problemRequestor.acceptProblem((Node)moveStatement, 3463, new String[0]);
        return false;
    }

    private boolean checkTargetOrSourceExpression(Expression expr, ITypeBinding exprType, int problemKind) {
        if (6 != exprType.getKind() && 3 != exprType.getKind() && 26 != exprType.getKind() && 19 != exprType.getKind() && 28 != exprType.getKind() && 20 != exprType.getKind() && 27 != exprType.getKind() && exprType != ArrayDictionaryBinding.INSTANCE && exprType != DictionaryBinding.INSTANCE && !exprType.isDynamic() && !MoveStatementValidator.isRecordOrForm(exprType) && 25 != exprType.getKind()) {
            if (2 == exprType.getKind()) {
                return this.checkTargetOrSourceExpression(expr, ((ArrayTypeBinding)exprType).getBaseType(), problemKind);
            }
            boolean isValid = false;
            if (!isValid) {
                this.problemRequestor.acceptProblem((Node)expr, problemKind, new String[]{expr.getCanonicalString()});
                return false;
            }
        }
        return true;
    }

    private void checkForCount(Expression forCountExpr) {
        boolean countIsValid = false;
        final boolean[] isValidExpr = new boolean[1];
        forCountExpr.accept(new AbstractASTExpressionVisitor(){

            @Override
            public void endVisit(IntegerLiteral integerLiteral) {
                isValidExpr[0] = true;
            }

            @Override
            public void endVisitName(Name name) {
                isValidExpr[0] = true;
            }

            @Override
            public void endVisit(ArrayAccess arrayAccess) {
                isValidExpr[0] = true;
            }

            @Override
            public void endVisit(FieldAccess fieldAccess) {
                isValidExpr[0] = true;
            }
        });
        if (isValidExpr[0]) {
            PrimitiveTypeBinding primTBinding;
            ITypeBinding forCountTBinding = forCountExpr.resolveTypeBinding();
            if (forCountTBinding == null) {
                countIsValid = true;
            } else if (3 == forCountTBinding.getKind() && Primitive.isNumericType((primTBinding = (PrimitiveTypeBinding)forCountTBinding).getPrimitive()) && primTBinding.getDecimals() == 0) {
                countIsValid = true;
            }
        }
        if (!countIsValid) {
            this.problemRequestor.acceptProblem((Node)forCountExpr, 5196, new String[]{forCountExpr.getCanonicalString()});
        }
    }

    private void checkExpressionsForDefaultModifier(Expression sourceExpr, Expression targetExpr, ITypeBinding sourceType, ITypeBinding targetType) {
        IDataBinding sourceDBinding;
        targetExpr.accept(new AbstractASTExpressionVisitor(){
            boolean firstVisit = true;

            @Override
            public boolean visit(ArrayAccess arrayAccess) {
                if (this.firstVisit && arrayAccess.getArray().resolveTypeBinding() == ArrayDictionaryBinding.INSTANCE) {
                    MoveStatementValidator.this.problemRequestor.acceptProblem(arrayAccess, 7744);
                }
                this.firstVisit = false;
                return true;
            }

            @Override
            public boolean visit(FieldAccess fieldAccess) {
                this.firstVisit = false;
                return true;
            }

            @Override
            public boolean visit(SubstringAccess substringAccess) {
                this.firstVisit = false;
                return true;
            }
        });
        if (!(TypeCompatibilityUtil.isMoveCompatible(targetType, sourceType, sourceExpr, this.compilerOptions) || sourceType.isDynamic() || TypeCompatibilityUtil.areCompatibleArrayTypes(targetType, sourceType, this.compilerOptions) || TypeCompatibilityUtil.areCompatibleExceptions(sourceType, targetType, this.compilerOptions))) {
            this.problemRequestor.acceptProblem((Node)targetExpr, 6653, new String[]{sourceType.getCaseSensitiveName(), targetType.getCaseSensitiveName(), "move".toUpperCase()});
        } else if (sourceType.getAnnotation(new String[]{"egl", "io", "dli"}, "PSBRecord") != null && targetType.getAnnotation(new String[]{"egl", "io", "dli"}, "PSBRecord") != null) {
            this.problemRequestor.acceptProblem((Node)targetExpr, 6653, new String[]{"PSBRecord", "PSBRecord", "move".toUpperCase()});
        }
        IDataBinding targetDBinding = targetExpr.resolveDataBinding();
        if (targetDBinding != null) {
            new LValueValidator(this.problemRequestor, this.compilerOptions, targetDBinding, targetExpr).validate();
        }
        if ((sourceDBinding = sourceExpr.resolveDataBinding()) != null) {
            new RValueValidator(this.problemRequestor, this.compilerOptions, sourceDBinding, sourceExpr).validate();
        }
        if (Binding.isValidBinding(sourceType)) {
            if (!sourceType.isReference()) {
                this.problemRequestor.acceptProblem((Node)sourceExpr, 6761, new String[0]);
            }
            if (Binding.isValidBinding(sourceType.getBaseType()) && sourceType.getBaseType().getKind() == 28) {
                this.problemRequestor.acceptProblem((Node)sourceExpr, 6762, new String[0]);
            }
        } else if (Binding.isValidBinding(targetType)) {
            if (!targetType.isReference()) {
                this.problemRequestor.acceptProblem((Node)targetExpr, 6761, new String[0]);
            }
            if (Binding.isValidBinding(targetType.getBaseType()) && targetType.getBaseType().getKind() == 28) {
                this.problemRequestor.acceptProblem((Node)targetExpr, 6762, new String[0]);
            }
        }
    }

    private boolean checkExpressionsForByNameOrByPosition(Expression sourceExpr, Expression targetExpr, ITypeBinding sourceType, ITypeBinding targetType) {
        if (2 == sourceType.getKind() && 7 == ((ArrayTypeBinding)sourceType).getElementType().getKind() && 2 == targetType.getKind() && 7 == ((ArrayTypeBinding)targetType).getElementType().getKind()) {
            this.problemRequestor.acceptProblem(this.moveStmt, 6722);
            return false;
        }
        boolean expressionsValid = true;
        if (!MoveStatementValidator.isContainer(sourceExpr)) {
            this.problemRequestor.acceptProblem((Node)sourceExpr, 6718, new String[]{sourceExpr.getCanonicalString()});
            expressionsValid = false;
        }
        if (!MoveStatementValidator.isContainer(targetExpr)) {
            this.problemRequestor.acceptProblem((Node)targetExpr, 6718, new String[]{targetExpr.getCanonicalString()});
            expressionsValid = false;
        }
        return expressionsValid;
    }

    private void checkExpressionsForByName(Expression sourceExpr, Expression targetExpr, ITypeBinding sourceType, ITypeBinding targetType) {
        if (!this.checkExpressionsForByNameOrByPosition(sourceExpr, targetExpr, sourceType, targetType)) {
            return;
        }
        if (sourceType.getAnnotation(new String[]{"egl", "io", "dli"}, "PSBRecord") != null && targetType.getAnnotation(new String[]{"egl", "io", "dli"}, "PSBRecord") != null) {
            this.problemRequestor.acceptProblem((Node)sourceExpr, 6653, new String[]{"PSBRecord", "PSBRecord", "move".toUpperCase()});
            return;
        }
        Map sourceNamesToDataBindings = MoveStatementValidator.getNamesToDataBindingsMap(sourceExpr);
        Map targetNamesToDataBindings = MoveStatementValidator.getNamesToDataBindingsMap(targetExpr);
        boolean shouldReturn = false;
        if (!this.checkNamesUnique(sourceNamesToDataBindings, sourceExpr, 6668)) {
            shouldReturn = true;
        }
        if (!this.checkNamesUnique(targetNamesToDataBindings, targetExpr, 6669)) {
            shouldReturn = true;
        }
        if (shouldReturn) {
            return;
        }
        if (!this.checkNoMultiplyOccuringStructureItems(sourceNamesToDataBindings, sourceExpr, 6670)) {
            shouldReturn = true;
        }
        if (!this.checkNoMultiplyOccuringStructureItems(targetNamesToDataBindings, targetExpr, 6671)) {
            shouldReturn = true;
        }
        if (shouldReturn) {
            return;
        }
        if (sourceNamesToDataBindings.isEmpty()) {
            this.problemRequestor.acceptProblem(sourceExpr, 6667, 1, new String[]{sourceExpr.getCanonicalString()});
        }
        for (String nextSourceName : sourceNamesToDataBindings.keySet()) {
            IDataBinding matchingTargetBinding = (IDataBinding)targetNamesToDataBindings.get(nextSourceName);
            if (matchingTargetBinding == null) continue;
            ITypeBinding nextSourceType = ((IDataBinding)sourceNamesToDataBindings.get(nextSourceName)).getType();
            if (TypeCompatibilityUtil.isMoveCompatible(matchingTargetBinding.getType(), nextSourceType, null, this.compilerOptions)) continue;
            this.problemRequestor.acceptProblem((Node)targetExpr, 6672, new String[]{nextSourceName, nextSourceType.getName(), matchingTargetBinding.getType().getName()});
        }
    }

    private void checkExpressionsForByPosition(Expression sourceExpr, Expression targetExpr, ITypeBinding sourceType, ITypeBinding targetType) {
        if (!this.checkExpressionsForByNameOrByPosition(sourceExpr, targetExpr, sourceType, targetType)) {
            return;
        }
        if (8 == sourceType.getKind()) {
            this.problemRequestor.acceptProblem(sourceExpr, 4031);
            return;
        }
        if (8 == targetType.getKind()) {
            this.problemRequestor.acceptProblem(targetExpr, 4031);
            return;
        }
        List sourceDataBindings = MoveStatementValidator.getTopLevelDataBindings(sourceExpr);
        List targetDataBindings = MoveStatementValidator.getTopLevelDataBindings(targetExpr);
        if (sourceDataBindings.isEmpty()) {
            this.problemRequestor.acceptProblem(sourceExpr, 6667, 1, new String[]{sourceExpr.getCanonicalString()});
        }
        Iterator targetBindingsIter = targetDataBindings.iterator();
        for (IDataBinding nextSourceBinding : sourceDataBindings) {
            if (!targetBindingsIter.hasNext()) continue;
            IDataBinding nextTargetBinding = (IDataBinding)targetBindingsIter.next();
            if (InternUtil.intern((String)"*") == nextSourceBinding.getName() || TypeCompatibilityUtil.isMoveCompatible(nextTargetBinding.getType(), nextSourceBinding.getType(), null, this.compilerOptions)) continue;
            this.problemRequestor.acceptProblem((Node)targetExpr, 6702, new String[]{nextSourceBinding.getCaseSensitiveName(), nextTargetBinding.getCaseSensitiveName(), nextSourceBinding.getType().getCaseSensitiveName(), nextTargetBinding.getType().getCaseSensitiveName()});
        }
    }

    private boolean checkExpressionsForForOrForAll(Expression sourceExpr, Expression targetExpr, ITypeBinding sourceType, ITypeBinding targetType) {
        boolean targetIsValid = false;
        int problemKind = 6676;
        IDataBinding targetDBinding = targetExpr.resolveDataBinding();
        if (targetDBinding != null && targetDBinding != IBinding.NOT_FOUND_BINDING && 5 == targetDBinding.getKind()) {
            StructureItemBinding strItemBinding = (StructureItemBinding)targetDBinding;
            if (5 == strItemBinding.getEnclosingStructureBinding().getKind()) {
                targetIsValid = TypeCompatibilityUtil.isMoveCompatible(targetDBinding.getType(), sourceType, sourceExpr, this.compilerOptions);
            } else if (strItemBinding.isMultiplyOccuring()) {
                targetIsValid = TypeCompatibilityUtil.isMoveCompatible(targetDBinding.getType(), sourceType, sourceExpr, this.compilerOptions);
            }
        }
        if (2 == sourceType.getKind() && MoveStatementValidator.isRecord(((ArrayTypeBinding)sourceType).getElementType())) {
            problemKind = 6677;
            targetIsValid = 2 == targetType.getKind() && MoveStatementValidator.isRecord(((ArrayTypeBinding)targetType).getElementType());
        } else if (2 == sourceType.getKind()) {
            problemKind = 6678;
            if (2 == targetType.getKind()) {
                targetIsValid = TypeCompatibilityUtil.isMoveCompatible(((ArrayTypeBinding)targetType).getElementType(), ((ArrayTypeBinding)sourceType).getElementType(), null, this.compilerOptions);
            } else if (26 == targetType.getKind()) {
                targetIsValid = TypeCompatibilityUtil.isMoveCompatible(((MultiplyOccuringItemTypeBinding)targetType).getBaseType(), ((ArrayTypeBinding)sourceType).getElementType(), null, this.compilerOptions);
            } else if (targetDBinding != null && targetDBinding != IBinding.NOT_FOUND_BINDING) {
                switch (targetDBinding.getKind()) {
                    case 7: {
                        targetIsValid = ((FormFieldBinding)targetDBinding).isMultiplyOccuring() && TypeCompatibilityUtil.isMoveCompatible(targetType, ((ArrayTypeBinding)sourceType).getElementType(), null, this.compilerOptions);
                        break;
                    }
                    case 5: {
                        targetIsValid = this.compilerOptions.isVAGCompatible() && ((StructureItemBinding)targetDBinding).isMultiplyOccuring() && TypeCompatibilityUtil.isMoveCompatible(targetType, ((ArrayTypeBinding)sourceType).getElementType(), null, this.compilerOptions);
                        break;
                    }
                    default: {
                        targetIsValid = false;
                        break;
                    }
                }
            } else {
                targetIsValid = false;
            }
        } else if (2 == targetType.getKind()) {
            targetIsValid = 26 == sourceType.getKind() ? TypeCompatibilityUtil.isMoveCompatible(((ArrayTypeBinding)targetType).getElementType(), sourceType.getBaseType(), null, this.compilerOptions) : TypeCompatibilityUtil.isMoveCompatible(((ArrayTypeBinding)targetType).getElementType(), sourceType, null, this.compilerOptions);
        } else if (26 == targetType.getKind()) {
            targetIsValid = 26 == sourceType.getKind() ? TypeCompatibilityUtil.isMoveCompatible(targetType.getBaseType(), sourceType.getBaseType(), null, this.compilerOptions) : (2 == sourceType.getKind() ? TypeCompatibilityUtil.isMoveCompatible(targetType.getBaseType(), ((ArrayTypeBinding)sourceType).getElementType(), null, this.compilerOptions) : TypeCompatibilityUtil.isMoveCompatible(targetType.getBaseType(), sourceType, null, this.compilerOptions));
        } else if (this.compilerOptions.isVAGCompatible()) {
            targetIsValid = TypeCompatibilityUtil.isMoveCompatible(targetType, sourceType, sourceExpr, this.compilerOptions);
        }
        if (!targetIsValid) {
            this.problemRequestor.acceptProblem((Node)targetExpr, problemKind, new String[]{targetExpr.getCanonicalString()});
        }
        return true;
    }

    private void checkExpressionsForFor(Expression sourceExpr, Expression targetExpr, ITypeBinding sourceType, ITypeBinding targetType) {
        if (!this.checkExpressionsForForOrForAll(sourceExpr, targetExpr, sourceType, targetType)) {
            return;
        }
    }

    private void checkExpressionsForForAll(Expression sourceExpr, Expression targetExpr, ITypeBinding sourceType, ITypeBinding targetType) {
        if (!this.checkExpressionsForForOrForAll(sourceExpr, targetExpr, sourceType, targetType)) {
            return;
        }
    }

    private boolean checkNamesUnique(Map namesToDataBindingsMap, Expression sourceOrTargetExpression, int problemKind) {
        for (String next : namesToDataBindingsMap.keySet()) {
            if (next.equals("*") || AmbiguousDataBinding.getInstance() != namesToDataBindingsMap.get(next)) continue;
            this.problemRequestor.acceptProblem((Node)sourceOrTargetExpression, problemKind, new String[]{sourceOrTargetExpression.getCanonicalString()});
            return false;
        }
        return true;
    }

    private boolean checkNoMultiplyOccuringStructureItems(Map namesToDataBindingsMap, Expression sourceOrTargetExpression, int problemKind) {
        for (IDataBinding nextDBinding : namesToDataBindingsMap.values()) {
            StructureItemBinding strItemBinding;
            if (5 != nextDBinding.getKind() || !(strItemBinding = (StructureItemBinding)nextDBinding).hasOccurs() || strItemBinding.getParentItem() == null || !strItemBinding.getParentItem().isMultiplyOccuring()) continue;
            this.problemRequestor.acceptProblem((Node)sourceOrTargetExpression, problemKind, new String[]{sourceOrTargetExpression.getCanonicalString()});
            return false;
        }
        return true;
    }

    private static boolean isContainer(Expression expr) {
        IDataBinding dBinding = expr.resolveDataBinding();
        if (dBinding != null && dBinding != IBinding.NOT_FOUND_BINDING && 5 == dBinding.getKind()) {
            return true;
        }
        ITypeBinding tBinding = expr.resolveTypeBinding();
        if (2 == tBinding.getKind()) {
            return MoveStatementValidator.isFixedRecordOrForm(((ArrayTypeBinding)tBinding).getBaseType());
        }
        return MoveStatementValidator.isRecordOrForm(expr.resolveTypeBinding());
    }

    private static boolean isStructureItem(Expression expr) {
        IDataBinding dBinding = expr.resolveDataBinding();
        return dBinding != null && dBinding != IBinding.NOT_FOUND_BINDING && 5 == dBinding.getKind();
    }

    private static boolean isRecord(ITypeBinding type) {
        return 6 == type.getKind() || 7 == type.getKind();
    }

    private static boolean isRecordOrForm(ITypeBinding type) {
        return 7 == type.getKind() || MoveStatementValidator.isFixedRecordOrForm(type);
    }

    private static boolean isFixedRecordOrForm(ITypeBinding type) {
        return 6 == type.getKind() || 8 == type.getKind();
    }

    private static Map getNamesToDataBindingsMap(Expression expr) {
        IDataBinding dBinding = expr.resolveDataBinding();
        if (dBinding != null && dBinding != IBinding.NOT_FOUND_BINDING && 5 == dBinding.getKind()) {
            return ((StructureItemBinding)dBinding).getSimpleNamesToDataBindingsMap();
        }
        return MoveStatementValidator.getNamesToDataBindingsMap(expr.resolveTypeBinding());
    }

    private static Map getNamesToDataBindingsMap(ITypeBinding type) {
        if (8 == type.getKind() || 6 == type.getKind()) {
            return type.getSimpleNamesToDataBindingsMap();
        }
        if (7 == type.getKind()) {
            HashMap<String, IDataBinding> result = new HashMap<String, IDataBinding>();
            for (IDataBinding next : ((FlexibleRecordBinding)type).getDeclaredFields()) {
                result.put(next.getName(), next);
            }
            return result;
        }
        if (2 == type.getKind()) {
            return MoveStatementValidator.getNamesToDataBindingsMap(((ArrayTypeBinding)type).getBaseType());
        }
        return Collections.EMPTY_MAP;
    }

    private static List getTopLevelDataBindings(Expression expr) {
        IDataBinding dBinding = expr.resolveDataBinding();
        if (dBinding != null && dBinding != IBinding.NOT_FOUND_BINDING && 5 == dBinding.getKind()) {
            return ((StructureItemBinding)dBinding).getChildren();
        }
        return MoveStatementValidator.getTopLevelDataBindings(expr.resolveTypeBinding());
    }

    private static List getTopLevelDataBindings(ITypeBinding type) {
        if (8 == type.getKind()) {
            return ((FormBinding)type).getFields();
        }
        if (6 == type.getKind()) {
            return ((FixedRecordBinding)type).getStructureItems();
        }
        if (7 == type.getKind()) {
            return ((FlexibleRecordBinding)type).getDeclaredFields();
        }
        if (2 == type.getKind()) {
            return MoveStatementValidator.getTopLevelDataBindings(((ArrayTypeBinding)type).getBaseType());
        }
        return Collections.EMPTY_LIST;
    }

    private String getCanonicalStringNoSubscripts(Expression expr) {
        final String[] result = new String[1];
        expr.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visitExpression(Expression expression) {
                result[0] = expression.getCanonicalString();
                return false;
            }

            @Override
            public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                return true;
            }

            @Override
            public boolean visit(ArrayAccess arrayAccess) {
                arrayAccess.getArray().accept(this);
                return false;
            }

            @Override
            public boolean visit(SubstringAccess substringAccess) {
                substringAccess.getPrimary().accept(this);
                return false;
            }
        });
        return result[0];
    }
}

