/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.ForExpressionClause;
import org.eclipse.edt.compiler.core.ast.FromExpressionClause;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.PrepareStatement;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.statement.IOStatementValidatorConstants;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;

public class PrepareStatementValidator
extends DefaultASTVisitor
implements IOStatementValidatorConstants {
    private IProblemRequestor problemRequestor;
    private ICompilerOptions compilerOptions;

    public PrepareStatementValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public boolean visit(PrepareStatement aprepareStatement) {
        StatementValidator.validateIOTargetsContainer(aprepareStatement.getIOObjects(), this.problemRequestor);
        aprepareStatement.accept(new AbstractASTVisitor(){
            boolean hasFrom;

            @Override
            public boolean visit(FromExpressionClause fromExpressionClause) {
                this.hasFrom = true;
                ITypeBinding typeBinding = fromExpressionClause.getExpression().resolveTypeBinding();
                if (StatementValidator.isValidBinding(typeBinding) && (typeBinding.getKind() == 3 && !StatementValidator.isStringCompatible(typeBinding) || typeBinding.getKind() != 3)) {
                    PrepareStatementValidator.this.problemRequestor.acceptProblem((Node)fromExpressionClause.getExpression(), 5085, new String[]{fromExpressionClause.getExpression().getCanonicalString()});
                }
                return false;
            }

            @Override
            public boolean visit(ForExpressionClause forExpressionClause) {
                ITypeBinding typeBinding = forExpressionClause.getExpression().resolveTypeBinding();
                if (StatementValidator.isValidBinding(typeBinding) && typeBinding.getAnnotation(EGLIOSQL, "SQLRecord") == null) {
                    PrepareStatementValidator.this.problemRequestor.acceptProblem((Node)forExpressionClause.getExpression(), 6632, new String[]{forExpressionClause.getExpression().getCanonicalString()});
                }
                return false;
            }

            @Override
            public void endVisit(PrepareStatement prepareStatement) {
            }
        });
        return false;
    }
}

