/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.NestedFunctionBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.ParenthesizedExpression;
import org.eclipse.edt.compiler.core.ast.ReturnStatement;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.utils.TypeCompatibilityUtil;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;

public class ReturnStatementValidator
extends DefaultASTVisitor {
    private IProblemRequestor problemRequestor;
    private ICompilerOptions compilerOptions;

    public ReturnStatementValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public boolean visit(ReturnStatement returnStatement) {
        boolean compatible;
        Node current = returnStatement.getParent();
        ParentASTVisitor visitor = new ParentASTVisitor(){

            @Override
            public boolean visit(NestedFunction nFunction) {
                IFunctionBinding fBinding = (IFunctionBinding)((NestedFunctionBinding)nFunction.getName().resolveBinding()).getType();
                if (fBinding != null) {
                    this.binding = fBinding.getReturnType();
                }
                this.bcontinue = false;
                return false;
            }

            @Override
            public boolean visit(TopLevelFunction tlFunction) {
                this.bcontinue = false;
                IFunctionBinding fBinding = (IFunctionBinding)tlFunction.getName().resolveBinding();
                if (fBinding != null) {
                    this.binding = fBinding.getReturnType();
                }
                return false;
            }
        };
        while (current != null && visitor.canContinue()) {
            current.accept(visitor);
            current = current.getParent();
        }
        if (returnStatement.getParenthesizedExprOpt() != null && !visitor.hasReturnType()) {
            this.problemRequestor.acceptProblem(returnStatement, 6608);
        }
        this.validateNoSetValues(returnStatement);
        if (visitor.hasReturnType() && returnStatement.getParenthesizedExprOpt() != null && !(compatible = TypeCompatibilityUtil.isMoveCompatible(visitor.getBinding(), returnStatement.getParenthesizedExprOpt().resolveTypeBinding(), returnStatement.getParenthesizedExprOpt(), this.compilerOptions))) {
            this.problemRequestor.acceptProblem((Node)returnStatement.getParenthesizedExprOpt(), 6691, new String[]{this.getTypeName(returnStatement.getParenthesizedExprOpt().resolveTypeBinding()), this.getTypeName(visitor.getBinding())});
        }
        if (returnStatement.getParenthesizedExprOpt() != null) {
            returnStatement.getParenthesizedExprOpt().accept(new DefaultASTVisitor(){

                @Override
                public boolean visit(AnnotationExpression annotationExpression) {
                    ReturnStatementValidator.this.problemRequestor.acceptProblem(annotationExpression.getOffset(), annotationExpression.getOffset() + 1, 2, 2002, new String[]{"@"});
                    return false;
                }

                @Override
                public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                    return true;
                }
            });
        }
        return false;
    }

    protected String getTypeName(ITypeBinding binding) {
        return StatementValidator.getTypeString(binding);
    }

    protected void validateNoSetValues(ReturnStatement returnStatement) {
        returnStatement.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(SetValuesExpression setValuesExpression) {
                ReturnStatementValidator.this.problemRequestor.acceptProblem(setValuesExpression, 7516);
                return false;
            }
        });
    }

    private class ParentASTVisitor
    extends AbstractASTVisitor {
        ITypeBinding binding = null;
        boolean bcontinue = true;

        public boolean hasReturnType() {
            return this.binding != null;
        }

        public ITypeBinding getBinding() {
            return this.binding;
        }

        public boolean canContinue() {
            return this.bcontinue;
        }
    }
}

