/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.edt.compiler.binding.FormFieldBinding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.ParenthesizedExpression;
import org.eclipse.edt.compiler.core.ast.SetStatement;
import org.eclipse.edt.compiler.core.ast.SubstringAccess;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.statement.IOStatementValidatorConstants;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class SetStatementValidator
extends DefaultASTVisitor
implements IOStatementValidatorConstants {
    private static final String POSITION_INTERN = InternUtil.intern((String)"position");
    private static final String ALARM_INTERN = InternUtil.intern((String)"alarm");
    private static final String CURSOR_INTERN = InternUtil.intern((String)"cursor");
    private static final String FULL_INTERN = InternUtil.intern((String)"full");
    private static final String NOHIGHLIGHT_INTERN = InternUtil.intern((String)"nohighlight");
    private static final String BLINK_INTERN = InternUtil.intern((String)"blink");
    private static final String REVERSE_INTERN = InternUtil.intern((String)"reverse");
    private static final String UNDERLINE_INTERN = InternUtil.intern((String)"underline");
    private static final String MODIFIED_INTERN = InternUtil.intern((String)"modified");
    private static final String DEFAULTCOLOR_INTERN = InternUtil.intern((String)"defaultColor");
    private static final String BLACK_INTERN = InternUtil.intern((String)"black");
    private static final String BLUE_INTERN = InternUtil.intern((String)"blue");
    private static final String GREEN_INTERN = InternUtil.intern((String)"green");
    private static final String MAGENTA_INTERN = InternUtil.intern((String)"magenta");
    private static final String RED_INTERN = InternUtil.intern((String)"red");
    private static final String CYAN_INTERN = InternUtil.intern((String)"cyan");
    private static final String YELLOW_INTERN = InternUtil.intern((String)"yellow");
    private static final String WHITE_INTERN = InternUtil.intern((String)"white");
    private static final String BOLD_INTERN = InternUtil.intern((String)"bold");
    private static final String DIM_INTERN = InternUtil.intern((String)"dim");
    private static final String MASKED_INTERN = InternUtil.intern((String)"masked");
    private static final String INVISIBLE_INTERN = InternUtil.intern((String)"invisible");
    private static final String NORMALINTENSITY_INTERN = InternUtil.intern((String)"normalIntensity");
    private static final String PROTECT_INTERN = InternUtil.intern((String)"protect");
    private static final String SKIP_INTERN = InternUtil.intern((String)"skip");
    private static final String UNPROTECT_INTERN = InternUtil.intern((String)"unprotect");
    private static final String NORMAL_INTERN = InternUtil.intern((String)"normal");
    private static final String INITIALATTRIBUTES_INTERN = InternUtil.intern((String)"initialAttributes");
    private static final String INITIAL_INTERN = InternUtil.intern((String)"initial");
    private static final String EMPTY_INTERN = InternUtil.intern((String)"empty");
    protected static final String[] VALID_FOR_PRINTFORM = InternUtil.intern((String[])new String[]{INITIAL_INTERN, INITIALATTRIBUTES_INTERN, EMPTY_INTERN});
    protected static final String[] VALID_FOR_TEXTFORM = InternUtil.intern((String[])new String[]{ALARM_INTERN, INITIAL_INTERN, INITIALATTRIBUTES_INTERN, EMPTY_INTERN});
    protected static final String[] VALID_FOR_FORMFIELD = InternUtil.intern((String[])new String[]{CURSOR_INTERN, FULL_INTERN, EMPTY_INTERN, NORMAL_INTERN, INITIALATTRIBUTES_INTERN, INITIAL_INTERN, MODIFIED_INTERN, DEFAULTCOLOR_INTERN, BLACK_INTERN, BLUE_INTERN, GREEN_INTERN, MAGENTA_INTERN, RED_INTERN, CYAN_INTERN, YELLOW_INTERN, WHITE_INTERN, BLINK_INTERN, REVERSE_INTERN, UNDERLINE_INTERN, NOHIGHLIGHT_INTERN, BOLD_INTERN, DIM_INTERN, MASKED_INTERN, INVISIBLE_INTERN, NORMALINTENSITY_INTERN, PROTECT_INTERN, SKIP_INTERN, UNPROTECT_INTERN});
    private String sColor;
    private String sIntensity;
    private String sProtection;
    private String sDefaultTextFieldState;
    private String sEmptyOrInitial;
    private String sNoHighlightState;
    private String sBlinkState;
    private String sReverseState;
    private String sUnderlineState;
    private String sModifiedState;
    private boolean positionState;
    private boolean alarmState;
    private boolean cursorState;
    private boolean fullState;
    private IProblemRequestor problemRequestor;
    private boolean enclosingPartIsPageHandler = false;
    private ICompilerOptions compilerOptions;

    public SetStatementValidator(IProblemRequestor problemRequestor, IPartBinding enclosingPart, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
        if (enclosingPart != null) {
            this.enclosingPartIsPageHandler = enclosingPart.getAnnotation(EGLUIJSF, "JSFHandler") != null;
        }
    }

    @Override
    public boolean visit(SetStatement setStatement) {
        this.checkForDuplicateStates(setStatement);
        this.checkForConflictingStates(setStatement);
        if (!this.checkNoSubstringAsTarget(setStatement)) {
            return false;
        }
        this.validateReferenceAndStates(setStatement);
        return false;
    }

    protected void checkForDuplicateStates(SetStatement setStmt) {
        Iterator iterator = setStmt.getStates().iterator();
        while (iterator.hasNext()) {
            String result = InternUtil.intern((String)((String)iterator.next()));
            if (result == POSITION_INTERN) {
                if (!this.positionState) {
                    this.positionState = true;
                    continue;
                }
                this.problemRequestor.acceptProblem((Node)setStmt, 6610, new String[]{"position".toUpperCase()});
                continue;
            }
            if (result == ALARM_INTERN) {
                if (!this.alarmState) {
                    this.alarmState = true;
                    continue;
                }
                this.problemRequestor.acceptProblem((Node)setStmt, 6610, new String[]{"alarm".toUpperCase()});
                continue;
            }
            if (result == CURSOR_INTERN) {
                if (!this.cursorState) {
                    this.cursorState = true;
                    continue;
                }
                this.problemRequestor.acceptProblem((Node)setStmt, 6610, new String[]{"cursor".toUpperCase()});
                continue;
            }
            if (result == FULL_INTERN) {
                if (!this.fullState) {
                    this.fullState = true;
                    continue;
                }
                this.problemRequestor.acceptProblem((Node)setStmt, 6610, new String[]{"full".toUpperCase()});
                continue;
            }
            if (result == NOHIGHLIGHT_INTERN) {
                if (this.sNoHighlightState == null) {
                    this.sNoHighlightState = result.toUpperCase();
                    continue;
                }
                this.problemRequestor.acceptProblem((Node)setStmt, 6610, new String[]{"nohighlight".toUpperCase()});
                continue;
            }
            if (result == BLINK_INTERN) {
                if (this.sBlinkState == null) {
                    this.sBlinkState = result.toUpperCase();
                    continue;
                }
                this.problemRequestor.acceptProblem((Node)setStmt, 6610, new String[]{"blink".toUpperCase()});
                continue;
            }
            if (result == REVERSE_INTERN) {
                if (this.sReverseState == null) {
                    this.sReverseState = result.toUpperCase();
                    continue;
                }
                this.problemRequestor.acceptProblem((Node)setStmt, 6610, new String[]{"reverse".toUpperCase()});
                continue;
            }
            if (result == UNDERLINE_INTERN) {
                if (this.sUnderlineState == null) {
                    this.sUnderlineState = result.toUpperCase();
                    continue;
                }
                this.problemRequestor.acceptProblem((Node)setStmt, 6610, new String[]{"underline".toUpperCase()});
                continue;
            }
            if (result == MODIFIED_INTERN) {
                if (this.sModifiedState == null) {
                    this.sModifiedState = result.toUpperCase();
                    continue;
                }
                this.problemRequestor.acceptProblem((Node)setStmt, 6610, new String[]{"modified".toUpperCase()});
                continue;
            }
            if (result == DEFAULTCOLOR_INTERN || result == BLACK_INTERN || result == BLUE_INTERN || result == GREEN_INTERN || result == MAGENTA_INTERN || result == RED_INTERN || result == CYAN_INTERN || result == YELLOW_INTERN || result == WHITE_INTERN) {
                if (this.sColor == null) {
                    this.sColor = result.toUpperCase();
                    continue;
                }
                this.problemRequestor.acceptProblem((Node)setStmt, 6611, new String[]{this.sColor, result.toUpperCase()});
                continue;
            }
            if (result == BOLD_INTERN || result == DIM_INTERN || result == MASKED_INTERN || result == INVISIBLE_INTERN || result == NORMALINTENSITY_INTERN) {
                if (this.sIntensity == null) {
                    this.sIntensity = result.toUpperCase();
                    continue;
                }
                this.problemRequestor.acceptProblem((Node)setStmt, 6612, new String[]{this.sIntensity, result.toUpperCase()});
                continue;
            }
            if (result == PROTECT_INTERN || result == SKIP_INTERN || result == UNPROTECT_INTERN) {
                if (this.sProtection == null) {
                    this.sProtection = result.toUpperCase();
                    continue;
                }
                this.problemRequestor.acceptProblem((Node)setStmt, 6613, new String[]{this.sProtection, result.toUpperCase()});
                continue;
            }
            if (result == NORMAL_INTERN || result == INITIALATTRIBUTES_INTERN || result == INITIAL_INTERN) {
                if (this.sDefaultTextFieldState == null) {
                    this.sDefaultTextFieldState = result.toUpperCase();
                } else {
                    this.problemRequestor.acceptProblem((Node)setStmt, 6614, new String[]{this.sDefaultTextFieldState, result.toUpperCase()});
                }
                if (result != INITIAL_INTERN) continue;
                if (this.sEmptyOrInitial == null) {
                    this.sEmptyOrInitial = result.toUpperCase();
                    continue;
                }
                this.problemRequestor.acceptProblem((Node)setStmt, 6615, new String[]{this.sEmptyOrInitial, result.toUpperCase()});
                continue;
            }
            if (result == EMPTY_INTERN) {
                if (this.sEmptyOrInitial == null) {
                    this.sEmptyOrInitial = result.toUpperCase();
                    continue;
                }
                this.problemRequestor.acceptProblem((Node)setStmt, 6615, new String[]{this.sEmptyOrInitial, result.toUpperCase()});
                continue;
            }
            this.problemRequestor.acceptProblem((Node)setStmt, 6617, new String[]{result.toUpperCase()});
        }
    }

    protected void checkForConflictingStates(SetStatement setStmt) {
        if (this.sNoHighlightState != null && this.sBlinkState != null) {
            this.problemRequestor.acceptProblem((Node)setStmt, 6616, new String[]{this.sNoHighlightState, this.sBlinkState});
        }
        if (this.sNoHighlightState != null && this.sReverseState != null) {
            this.problemRequestor.acceptProblem((Node)setStmt, 6616, new String[]{this.sNoHighlightState, this.sReverseState});
        }
        if (this.sNoHighlightState != null && this.sUnderlineState != null) {
            this.problemRequestor.acceptProblem((Node)setStmt, 6616, new String[]{this.sNoHighlightState, this.sUnderlineState});
        }
        if (this.sDefaultTextFieldState != null) {
            if (this.sModifiedState != null) {
                this.problemRequestor.acceptProblem((Node)setStmt, 6618, new String[]{this.sDefaultTextFieldState, this.sModifiedState});
            }
            if (this.sColor != null) {
                this.problemRequestor.acceptProblem((Node)setStmt, 6618, new String[]{this.sDefaultTextFieldState, this.sColor});
            }
            if (this.sIntensity != null) {
                this.problemRequestor.acceptProblem((Node)setStmt, 6618, new String[]{this.sDefaultTextFieldState, this.sIntensity});
            }
            if (this.sProtection != null) {
                this.problemRequestor.acceptProblem((Node)setStmt, 6618, new String[]{this.sDefaultTextFieldState, this.sProtection});
            }
            if (this.sNoHighlightState != null) {
                this.problemRequestor.acceptProblem((Node)setStmt, 6618, new String[]{this.sDefaultTextFieldState, this.sNoHighlightState});
            }
            if (this.sBlinkState != null) {
                this.problemRequestor.acceptProblem((Node)setStmt, 6618, new String[]{this.sDefaultTextFieldState, this.sBlinkState});
            }
            if (this.sReverseState != null) {
                this.problemRequestor.acceptProblem((Node)setStmt, 6618, new String[]{this.sDefaultTextFieldState, this.sReverseState});
            }
            if (this.sUnderlineState != null) {
                this.problemRequestor.acceptProblem((Node)setStmt, 6618, new String[]{this.sDefaultTextFieldState, this.sUnderlineState});
            }
        }
    }

    public void validateReferenceAndStates(final SetStatement setStmt) {
        setStmt.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visitExpression(final Expression expression) {
                IDataBinding dataBinding = expression.resolveDataBinding();
                if (!StatementValidator.isValidBinding(dataBinding)) {
                    return false;
                }
                if (dataBinding.getKind() != 3 && dataBinding.getKind() != 0 && dataBinding.getKind() != 2 && dataBinding.getKind() != 1 && dataBinding.getKind() != 8 && dataBinding.getKind() != 5 && dataBinding.getKind() != 10 && dataBinding.getKind() != 7) {
                    return false;
                }
                ITypeBinding typeBinding = expression.resolveTypeBinding();
                if (!StatementValidator.isValidBinding(typeBinding)) {
                    return false;
                }
                if (!typeBinding.isDynamic()) {
                    if (StatementValidator.isRecordOrRecordArray(typeBinding)) {
                        if (typeBinding.getAnnotation(EGLIODLI, "PSBRecord") != null) {
                            SetStatementValidator.this.problemRequestor.acceptProblem((Node)expression, 7932, new String[]{"set"});
                        } else {
                            ArrayList<String> validStates = new ArrayList<String>();
                            validStates.add(EMPTY_INTERN);
                            validStates.add(INITIAL_INTERN);
                            validStates.add(POSITION_INTERN);
                            int iErr = -1;
                            final boolean[] isIndexedOrDLI = new boolean[1];
                            if (typeBinding.getAnnotation(EGLIOFILE, "IndexedRecord") != null || typeBinding.getAnnotation(EGLIODLI, "DLISegment") != null) {
                                iErr = 6698;
                                isIndexedOrDLI[0] = true;
                            } else {
                                iErr = 6697;
                            }
                            String[] toArray = validStates.toArray(new String[0]);
                            SetStatementValidator.this.validateStates(setStmt, expression, toArray, iErr, POSITION_INTERN, new IOnStateDoThis(){

                                @Override
                                public void doIt() {
                                    if (!isIndexedOrDLI[0]) {
                                        SetStatementValidator.this.problemRequestor.acceptProblem((Node)expression, 4202, new String[]{expression.getCanonicalString()});
                                    }
                                }
                            });
                        }
                    } else if (typeBinding.getKind() == 8) {
                        if (typeBinding.getAnnotation(EGLUITEXT, "PrintForm") != null) {
                            SetStatementValidator.this.validateStates(setStmt, expression, VALID_FOR_PRINTFORM, 6700);
                        } else {
                            SetStatementValidator.this.validateStates(setStmt, expression, VALID_FOR_TEXTFORM, 6699);
                        }
                    } else if (typeBinding.getKind() != 2 && (dataBinding.getKind() == 7 && ((FormFieldBinding)dataBinding).isTextFormField() || dataBinding.getKind() == 0 && ((FunctionParameterBinding)dataBinding).isField())) {
                        SetStatementValidator.this.validateStates(setStmt, expression, VALID_FOR_FORMFIELD, 6701);
                    } else if (SetStatementValidator.this.isSQLItem(dataBinding) || dataBinding.getKind() == 0 && ((FunctionParameterBinding)dataBinding).isSQLNullable()) {
                        ArrayList<String> validStates = new ArrayList<String>();
                        if (SetStatementValidator.this.enclosingPartIsPageHandler) {
                            validStates.add(EMPTY_INTERN);
                            validStates.add(INITIAL_INTERN);
                        }
                        SetStatementValidator.this.validateStates(setStmt, expression, validStates.isEmpty() ? new String[1] : validStates.toArray(new String[0]), 6696);
                    } else if ((dataBinding.getKind() == 2 || dataBinding.getKind() == 3) && SetStatementValidator.this.enclosingPartIsPageHandler) {
                        SetStatementValidator.this.validateStates(setStmt, expression, new String[]{EMPTY_INTERN, INITIAL_INTERN}, 6695);
                    } else if (dataBinding.getKind() == 5) {
                        String[] stringArray;
                        if (((StructureItemBinding)dataBinding).getChildren().size() == 0) {
                            stringArray = new String[1];
                        } else {
                            String[] stringArray2 = new String[1];
                            stringArray = stringArray2;
                            stringArray2[0] = EMPTY_INTERN;
                        }
                        String[] validStates = stringArray;
                        SetStatementValidator.this.validateStates(setStmt, expression, validStates, 6695);
                    } else {
                        String[] stringArray;
                        if (SetStatementValidator.this.compilerOptions.isVAGCompatible()) {
                            String[] stringArray3 = new String[1];
                            stringArray = stringArray3;
                            stringArray3[0] = INVISIBLE_INTERN;
                        } else {
                            stringArray = new String[]{};
                        }
                        SetStatementValidator.this.validateStates(setStmt, expression, stringArray, 6695);
                    }
                }
                return false;
            }
        });
    }

    private boolean checkNoSubstringAsTarget(SetStatement setStmt) {
        final boolean[] result = new boolean[]{true};
        Iterator iter = setStmt.getSetTargets().iterator();
        while (iter.hasNext()) {
            ((Expression)iter.next()).accept(new DefaultASTVisitor(){

                @Override
                public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                    return true;
                }

                @Override
                public boolean visit(SubstringAccess substringAccess) {
                    SetStatementValidator.this.problemRequestor.acceptProblem(substringAccess, 3364);
                    result[0] = false;
                    return false;
                }
            });
        }
        return result[0];
    }

    protected boolean validateStates(SetStatement setStmt, Expression expression, String[] internedValidStates, int iErr) {
        return this.validateStates(setStmt, expression, internedValidStates, iErr, null, null);
    }

    protected boolean validateStates(SetStatement setStmt, Expression expression, String[] internedValidStates, int iErr, String onState, IOnStateDoThis doThis) {
        boolean allValid = true;
        Iterator iter = setStmt.getStates().iterator();
        while (iter.hasNext()) {
            String nextState = InternUtil.intern((String)((String)iter.next()));
            if (SetStatementValidator.stateIsSupported(nextState) && !SetStatementValidator.stringInArray(nextState, internedValidStates)) {
                allValid = false;
                this.problemRequestor.acceptProblem((Node)expression, iErr, new String[]{nextState.toUpperCase()});
                continue;
            }
            if (nextState != onState) continue;
            doThis.doIt();
        }
        return allValid;
    }

    private static boolean stringInArray(String string, String[] internedArray) {
        if (internedArray.length == 0 || internedArray[0] == null) {
            return false;
        }
        int i = 0;
        while (i < internedArray.length) {
            if (internedArray[i] == string) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean stateIsSupported(String state) {
        return state == POSITION_INTERN || state == ALARM_INTERN || state == CURSOR_INTERN || state == FULL_INTERN || state == NOHIGHLIGHT_INTERN || state == BLINK_INTERN || state == REVERSE_INTERN || state == UNDERLINE_INTERN || state == MODIFIED_INTERN || state == DEFAULTCOLOR_INTERN || state == BLACK_INTERN || state == BLUE_INTERN || state == GREEN_INTERN || state == MAGENTA_INTERN || state == RED_INTERN || state == CYAN_INTERN || state == YELLOW_INTERN || state == WHITE_INTERN || state == BOLD_INTERN || state == DIM_INTERN || state == MASKED_INTERN || state == INVISIBLE_INTERN || state == NORMALINTENSITY_INTERN || state == PROTECT_INTERN || state == SKIP_INTERN || state == UNPROTECT_INTERN || state == NORMAL_INTERN || state == INITIALATTRIBUTES_INTERN || state == INITIAL_INTERN || state == EMPTY_INTERN;
    }

    protected boolean isSQLItem(IDataBinding dBinding) {
        IPartBinding pBinding = dBinding.getDeclaringPart();
        return StatementValidator.isValidBinding(pBinding) && pBinding.getAnnotation(EGLIOSQL, "SQLRecord") != null;
    }

    private static interface IOnStateDoThis {
        public void doIt();
    }
}

