/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.ExternalTypeBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.annotationType.EGLNotInCurrentReleaseAnnotationTypeBinding;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OnExceptionBlock;
import org.eclipse.edt.compiler.core.ast.TryStatement;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class TryStatementValidator
extends DefaultASTVisitor {
    private IProblemRequestor problemRequestor;
    private IPartBinding enclosingPart;
    private Set caughtExceptionTypes = new HashSet();

    public TryStatementValidator(IProblemRequestor problemRequestor, IPartBinding enclosingPart) {
        this.problemRequestor = problemRequestor;
        this.enclosingPart = enclosingPart;
    }

    @Override
    public boolean visit(TryStatement tryStatement) {
        Iterator iter = tryStatement.getOnExceptionBlocks().iterator();
        while (iter.hasNext()) {
            ((OnExceptionBlock)iter.next()).accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(OnExceptionBlock onExceptionBlock) {
        if (this.enclosingPart != null) {
            boolean isV60ExceptionCompatibility;
            IAnnotationBinding aBinding = this.enclosingPart.getAnnotation(new String[]{"egl", "core"}, "V60ExceptionCompatibility");
            boolean bl = isV60ExceptionCompatibility = aBinding != null && Boolean.YES == aBinding.getValue();
            if (isV60ExceptionCompatibility) {
                if (onExceptionBlock.hasExceptionDeclaration()) {
                    this.problemRequestor.acceptProblem(onExceptionBlock.getExceptionName(), 3442);
                }
            } else if (onExceptionBlock.hasExceptionDeclaration()) {
                Type exceptionType = onExceptionBlock.getExceptionType();
                ITypeBinding exceptionTypeBinding = exceptionType.resolveTypeBinding();
                if (exceptionTypeBinding != IBinding.NOT_FOUND_BINDING && exceptionTypeBinding != null) {
                    if (this.caughtExceptionTypes.contains(exceptionTypeBinding)) {
                        this.problemRequestor.acceptProblem((Node)exceptionType, 3441, new String[]{exceptionType.getCanonicalName()});
                    } else if (!this.isAnyException(exceptionTypeBinding) && exceptionTypeBinding.getAnnotation(new String[]{"eglx", "lang"}, "Exception") == null) {
                        this.problemRequestor.acceptProblem((Node)exceptionType, 3440, new String[]{exceptionType.getCanonicalName()});
                    } else {
                        this.caughtExceptionTypes.add(exceptionTypeBinding);
                        if (exceptionTypeBinding.getAnnotation(EGLNotInCurrentReleaseAnnotationTypeBinding.getInstance()) != null) {
                            this.problemRequestor.acceptProblem((Node)exceptionType, 3459, new String[]{exceptionTypeBinding.getCaseSensitiveName()});
                        }
                    }
                }
            } else {
                this.problemRequestor.acceptProblem(onExceptionBlock, 3443);
            }
        }
        return false;
    }

    private boolean isAnyException(ITypeBinding type) {
        if (!Binding.isValidBinding(type)) {
            return false;
        }
        if (type.getKind() != 28) {
            return false;
        }
        if (type.getName() != InternUtil.intern((String)"anyException")) {
            ExternalTypeBinding etBinding = (ExternalTypeBinding)type;
            List supers = ((ExternalTypeBinding)etBinding.getNonNullableInstance()).getExtendedTypes();
            if (supers.size() > 0) {
                for (Object o : supers) {
                    if (!(o instanceof ITypeBinding) || !this.isAnyException((ITypeBinding)o)) continue;
                    return true;
                }
            }
            return false;
        }
        return type.getPackageName() == InternUtil.intern((String[])new String[]{"eglx", "lang"});
    }
}

