/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.dli;

import java.io.StringReader;
import java.util.Stack;
import java_cup.runtime.Symbol;
import java_cup.runtime.lr_parser;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.CloseStatement;
import org.eclipse.edt.compiler.core.ast.ErrorCorrectingParser;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Lexer;
import org.eclipse.edt.compiler.core.ast.Parser;
import org.eclipse.edt.compiler.core.ast.VAGLexer;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;

public class DLIEGLParser
extends lr_parser {
    private int startState;
    private ICompilerOptions compilerOptions;

    public DLIEGLParser(ICompilerOptions compilerOptions) {
        this.compilerOptions = compilerOptions;
    }

    @Override
    public short[][] action_table() {
        return new Parser().action_table();
    }

    @Override
    public Symbol do_action(int act_num, lr_parser parser, Stack stack, int top) throws Exception {
        return new Symbol(this.production_tab[act_num][0]);
    }

    @Override
    public int EOF_sym() {
        return 0;
    }

    @Override
    public int error_sym() {
        return 1;
    }

    @Override
    protected void init_actions() throws Exception {
    }

    @Override
    public short[][] production_table() {
        return new Parser().production_table();
    }

    @Override
    public short[][] reduce_table() {
        return new Parser().reduce_table();
    }

    @Override
    public int start_production() {
        return 1;
    }

    @Override
    public int start_state() {
        return this.startState;
    }

    @Override
    public void report_error(String message, Object info) {
    }

    @Override
    protected boolean error_recovery(boolean debug) throws Exception {
        this.done_parsing();
        return true;
    }

    public int getHostVariableLength(String string) {
        File fileAst = this.getFileAst(this.getPartString(string));
        if (fileAst == null) {
            return 0;
        }
        final CloseStatement[] result = new CloseStatement[1];
        fileAst.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(CloseStatement closeStatement) {
                result[0] = closeStatement;
                return false;
            }
        });
        if (result[0] == null) {
            return 0;
        }
        return result[0].getExpr().getCanonicalString().length();
    }

    private File getFileAst(String string) {
        try {
            StringReader reader = new StringReader(string);
            ErrorCorrectingParser parser = new ErrorCorrectingParser(this.compilerOptions.isVAGCompatible() ? new VAGLexer(reader) : new Lexer(reader));
            File fileAST = (File)parser.parse().value;
            return fileAST;
        }
        catch (Exception exception) {
            return null;
        }
        catch (Error error) {
            return null;
        }
    }

    public String getPartString(String string) {
        int indexONewline;
        int indexOfSingleLineComment;
        int indexOfRParen = string.indexOf(41);
        if (indexOfRParen != -1) {
            string = string.substring(0, indexOfRParen);
        }
        if ((indexOfSingleLineComment = string.indexOf("//")) != -1) {
            string = string.substring(0, indexOfSingleLineComment);
        }
        if ((indexONewline = string.indexOf("\r")) != -1) {
            string = string.substring(0, indexONewline);
        }
        if ((indexONewline = string.indexOf("\n")) != -1) {
            string = string.substring(0, indexONewline);
        }
        return "Function test() Close " + string.replaceAll("\\).*", "") + "; end";
    }
}

