/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.egl2mof.eglx.services;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.DelegateBinding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.CallStatement;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionArgumentValidator;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionContainerScope;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.core.utils.TypeCompatibilityUtil;
import org.eclipse.edt.compiler.internal.core.validation.DefaultStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class ServicesActionStatementValidator
extends DefaultStatementValidator {
    @Override
    public boolean visit(CallStatement callStatement) {
        this.validateServiceFunctionCall(callStatement);
        return false;
    }

    private void validateServiceFunctionCall(CallStatement callStatement) {
        ITypeBinding type;
        if (!(callStatement.getErrorCallbackTarget() == null && callStatement.getCallbackTarget() == null || Binding.isValidBinding(type = callStatement.getInvocationTarget().resolveTypeBinding()) && type.getKind() == 20)) {
            this.problemRequestor.acceptProblem(callStatement.getInvocationTarget(), 3390, 2, new String[0]);
            return;
        }
        IDataBinding dataBinding = callStatement.getInvocationTarget().resolveDataBinding();
        if (!Binding.isValidBinding(dataBinding)) {
            return;
        }
        if (dataBinding.getKind() == 21) {
            this.problemRequestor.acceptProblem(callStatement.getInvocationTarget(), 3392, 2, new String[]{dataBinding.getCaseSensitiveName()});
            return;
        }
        if (dataBinding.getKind() == 20) {
            if (dataBinding.getDeclaringPart() == null || dataBinding.getDeclaringPart().getKind() != 14 && dataBinding.getDeclaringPart().getKind() != 15) {
                this.problemRequestor.acceptProblem(callStatement.getInvocationTarget(), 3392, 2, new String[]{dataBinding.getCaseSensitiveName()});
            } else {
                callStatement.accept(new FunctionArgumentValidator((IFunctionBinding)dataBinding.getType(), dataBinding.getDeclaringPart(), this.problemRequestor, this.compilerOptions));
            }
            if (callStatement.getCallbackTarget() == null) {
                this.problemRequestor.acceptProblem(callStatement.getInvocationTarget(), 3393, 2, new String[0]);
            }
            if (callStatement.getCallbackTarget() != null) {
                this.validateCallback(callStatement, callStatement.getCallbackTarget().getExpression(), false, callStatement.getInvocationTarget());
            }
            if (callStatement.getErrorCallbackTarget() != null) {
                this.validateCallback(callStatement, callStatement.getErrorCallbackTarget().getExpression(), true, callStatement.getInvocationTarget());
            }
        }
    }

    private void validateCallback(CallStatement stmt, Expression expr, boolean isErrorCallback, Expression invocTarget) {
        ITypeBinding cbType = expr.resolveTypeBinding();
        if (!Binding.isValidBinding(cbType)) {
            return;
        }
        if (cbType.getKind() != 20 && cbType.getKind() != 27) {
            this.problemRequestor.acceptProblem(expr, 3394, 2, new String[0]);
            return;
        }
        if (expr.resolveDataBinding() != null && expr.resolveDataBinding().getKind() == 20) {
            IBinding callStmtPart = null;
            Node node = stmt;
            while (!(node.getParent() instanceof File)) {
                node = node.getParent();
            }
            if (node instanceof Part) {
                callStmtPart = ((Part)node).getName().resolveBinding();
            }
            if (callStmtPart == null || callStmtPart != expr.resolveDataBinding().getDeclaringPart()) {
                this.problemRequestor.acceptProblem(expr, 3391, 2, new String[]{expr.resolveDataBinding().getCaseSensitiveName(), stmt.getStatementBinding().getName()});
            }
        }
        if (this.getReturnType(expr) != null) {
            this.problemRequestor.acceptProblem(expr, 3395, 2, new String[]{expr.getCanonicalString()});
        }
        FunctionParameterBinding[] parms = this.getParameters(expr);
        int i = 0;
        while (i < parms.length) {
            if (!parms[i].isInput()) {
                this.problemRequestor.acceptProblem(expr, 3397, 2, new String[]{expr.getCanonicalString()});
                break;
            }
            ++i;
        }
        if (isErrorCallback) {
            if (parms.length == 1 || parms.length == 2 && this.lastParmIsIHttp(parms)) {
                if (Binding.isValidBinding(parms[0]) && Binding.isValidBinding(parms[0].getType()) && !this.isAnyException(parms[0].getType())) {
                    this.problemRequestor.acceptProblem(expr, 3398, 2, new String[]{"1", expr.getCanonicalString(), this.getQualAnyExceptionString()});
                }
            } else {
                this.problemRequestor.acceptProblem(expr, 3396, 2, new String[]{expr.getCanonicalString(), this.lastParmIsIHttp(parms) ? "2" : "1"});
            }
        } else {
            ITypeBinding[] argTypes = this.getArgTypesForCallback(invocTarget);
            if (argTypes.length == parms.length || argTypes.length == parms.length - 1 && this.lastParmIsIHttp(parms)) {
                int i2 = 0;
                while (i2 < argTypes.length) {
                    if (!this.argTypeCompatibleWithParm(argTypes[i2], parms[i2])) {
                        this.problemRequestor.acceptProblem(expr, 3399, 2, new String[]{StatementValidator.getShortTypeString(argTypes[i2]), parms[i2].getCaseSensitiveName(), expr.getCanonicalString(), StatementValidator.getShortTypeString(parms[i2].getType())});
                    }
                    ++i2;
                }
            } else {
                this.problemRequestor.acceptProblem(expr, 3396, 2, new String[]{expr.getCanonicalString(), Integer.toString(this.lastParmIsIHttp(parms) ? argTypes.length + 1 : argTypes.length)});
            }
        }
    }

    private boolean lastParmIsIHttp(FunctionParameterBinding[] parms) {
        if (parms.length > 0) {
            ITypeBinding lastParm = parms[parms.length - 1].getType();
            return InternUtil.intern((String[])new String[]{"eglx", "http"}).equals(lastParm.getPackageName()) && InternUtil.intern((String)"IHttp").equals(lastParm.getName());
        }
        return false;
    }

    private ITypeBinding[] getArgTypesForCallback(Expression invocTarget) {
        FunctionParameterBinding[] parms = this.getParameters(invocTarget);
        ArrayList<ITypeBinding> list = new ArrayList<ITypeBinding>();
        int i = 0;
        while (i < parms.length) {
            if (parms[i].isOutput() || parms[i].isInputOutput()) {
                list.add(parms[i].getType());
            }
            ++i;
        }
        ITypeBinding retType = this.getReturnType(invocTarget);
        if (retType != null) {
            list.add(retType);
        }
        return list.toArray(new ITypeBinding[list.size()]);
    }

    private FunctionParameterBinding[] getParameters(Expression expr) {
        if (Binding.isValidBinding(expr.resolveTypeBinding())) {
            if (expr.resolveTypeBinding().getKind() == 27) {
                List list = ((DelegateBinding)expr.resolveTypeBinding()).getParemeters();
                return list.toArray(new FunctionParameterBinding[list.size()]);
            }
            if (expr.resolveTypeBinding().getKind() == 20) {
                List list = ((IFunctionBinding)expr.resolveTypeBinding()).getParameters();
                return list.toArray(new FunctionParameterBinding[list.size()]);
            }
        }
        return new FunctionParameterBinding[0];
    }

    private ITypeBinding getReturnType(Expression expr) {
        if (Binding.isValidBinding(expr.resolveTypeBinding())) {
            if (expr.resolveTypeBinding().getKind() == 27) {
                return ((DelegateBinding)expr.resolveTypeBinding()).getReturnType();
            }
            if (expr.resolveTypeBinding().getKind() == 20) {
                return ((IFunctionBinding)expr.resolveTypeBinding()).getReturnType();
            }
        }
        return null;
    }

    private FunctionContainerScope getFunctionContainerScope(Scope scope) {
        if (scope == null) {
            return null;
        }
        if (scope instanceof FunctionContainerScope) {
            return (FunctionContainerScope)scope;
        }
        return this.getFunctionContainerScope(scope.getParentScope());
    }

    private boolean argTypeCompatibleWithParm(ITypeBinding argType, FunctionParameterBinding parm) {
        if (!Binding.isValidBinding(argType)) {
            return true;
        }
        if (!Binding.isValidBinding(parm) || !Binding.isValidBinding(parm.getType())) {
            return true;
        }
        if (TypeCompatibilityUtil.isMoveCompatible(parm.getType(), argType, null, this.compilerOptions)) {
            return true;
        }
        if (argType.isDynamic()) {
            return true;
        }
        return TypeCompatibilityUtil.areCompatibleExceptions(argType, parm.getType(), this.compilerOptions);
    }

    private boolean isAnyException(ITypeBinding type) {
        IPartBinding part;
        if (!Binding.isValidBinding(type)) {
            return false;
        }
        return type.getKind() == 28 && InternUtil.intern((String)(part = (IPartBinding)type).getPackageQualifiedName()) == this.getQualAnyExceptionString();
    }

    private String getQualAnyExceptionString() {
        return InternUtil.intern((String)"eglx.lang.AnyException");
    }
}

