/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.sql;

import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.VariableBinding;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.sql.Token;

public class ItemNameToken
extends Token {
    private Expression expression = null;
    private IDataBinding sqlIOObject;
    private boolean followsLikeKeyword = false;

    public ItemNameToken() {
    }

    public ItemNameToken(String string, IDataBinding sqlIOObject) {
        this.sqlIOObject = sqlIOObject;
        this.string = string;
    }

    @Override
    public boolean isHostVariableToken() {
        return true;
    }

    @Override
    public String getSQLString() {
        if (this.getDataBinding() == null) {
            return "";
        }
        if (this.isConstant(this.getDataBinding())) {
            Object value = ((VariableBinding)this.getDataBinding()).getConstantValue();
            if (value instanceof String) {
                if (this.isDBChar(this.getDataBinding())) {
                    return "G\"" + value.toString() + "\"";
                }
                return "\"" + value.toString() + "\"";
            }
            return value.toString();
        }
        return "\"" + this.getExpression().getCanonicalString() + "\"";
    }

    public void setFollowsLike() {
        this.followsLikeKeyword = true;
    }

    public boolean getFollowsLike() {
        return this.followsLikeKeyword;
    }

    @Override
    public boolean isItemNameToken() {
        return true;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    private IDataBinding getDataBinding() {
        if (this.getExpression() == null) {
            return null;
        }
        if (this.getExpression().resolveDataBinding() == null || this.getExpression().resolveDataBinding() == IBinding.NOT_FOUND_BINDING) {
            return null;
        }
        return this.getExpression().resolveDataBinding();
    }

    private boolean isConstant(IDataBinding dataBinding) {
        if (dataBinding == null || dataBinding.getType() == null || dataBinding.getType() == IBinding.NOT_FOUND_BINDING) {
            return false;
        }
        if (dataBinding.getKind() == 2 || dataBinding.getKind() == 3) {
            VariableBinding var = (VariableBinding)dataBinding;
            return var.isConstant();
        }
        return false;
    }

    private boolean isDBChar(IDataBinding dataBinding) {
        if (dataBinding == null || dataBinding.getType() == null || dataBinding.getType() == IBinding.NOT_FOUND_BINDING) {
            return false;
        }
        if (dataBinding.getType().getKind() == 3) {
            Primitive prim = ((PrimitiveTypeBinding)dataBinding.getType()).getPrimitive();
            return prim.getType() == 5;
        }
        return false;
    }
}

