/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.sql;

import org.eclipse.edt.compiler.internal.sql.StringToken;
import org.eclipse.edt.compiler.internal.sql.Token;
import org.eclipse.edt.compiler.internal.sqltokenizer.EGLPrimeToken;

public class WhereCurrentOfToken
extends Token {
    private String resultSetIdentifier = "";

    public WhereCurrentOfToken() {
    }

    public WhereCurrentOfToken(String string) {
        super(WhereCurrentOfToken.trim(string));
        if (this.string.length() == 0) {
            this.string = " ";
        }
        this.setStartOffset(0);
        this.setEndOffset(string.length() - 1);
    }

    public WhereCurrentOfToken(EGLPrimeToken token) {
        this.string = token.getText();
        this.setStartOffset(token.getOffset());
        this.setEndOffset(token.getOffset() + token.getText().length());
    }

    public void append(StringToken token) {
        StringBuffer buff = new StringBuffer(this.string);
        if (buff.toString().equalsIgnoreCase("where current of")) {
            this.resultSetIdentifier = token.string;
        }
        if (this.getEndOffset() != token.getStartOffset()) {
            buff.append(" ");
        }
        buff.append(token.string);
        this.string = buff.toString();
        this.setEndOffset(token.getStartOffset() + token.string.length());
    }

    public String getResultSetIdentifier() {
        return this.resultSetIdentifier;
    }

    public static String trim(String string) {
        int len = string.length();
        int st = 0;
        char[] val = string.toCharArray();
        while (st < len && val[st] <= ' ') {
            ++st;
        }
        while (st < len && val[len - 1] <= ' ') {
            --len;
        }
        String pre = "";
        String post = "";
        if (st > 0) {
            pre = " ";
        }
        if (len < string.length()) {
            post = " ";
        }
        StringBuffer buff = new StringBuffer();
        buff.append(pre);
        buff.append(string.substring(st, len));
        buff.append(post);
        return buff.toString();
    }

    @Override
    public String getSQLString() {
        return null;
    }

    @Override
    public boolean isWhereCurrentOfToken() {
        return true;
    }
}

