/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.sql.statements;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.builder.Problem;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.sql.util.SQLUtility;
import org.eclipse.edt.compiler.internal.sqltokenizer.EGLSQLParser;

public abstract class EGLSQLStatementFactory {
    private static final String[] EGLIOSQL = new String[]{"egl", "io", "sql"};
    String sqlStatement = null;
    protected int numSQLDataItems = 0;
    List sqlDataItems = null;
    IDataBinding[] structureItemBindings;
    String[] itemNames = null;
    String[] columnNames = null;
    String[] tableNames = null;
    String[] tableLabels = null;
    ArrayList errorMessages = new ArrayList();
    boolean invalidIoObject = false;
    boolean addIOObjectValidationErrorMessages = false;
    protected IDataBinding sqlRecordData;
    protected ITypeBinding sqlRecordType;
    protected ITypeBinding sqlRecordTypeBinding;
    protected String ioObjectName;
    IDataBinding[] keyItems;
    protected String[][] keyItemAndColumnNames;
    private ICompilerOptions compilerOptions;
    boolean useRecordKeys = true;

    public EGLSQLStatementFactory(ICompilerOptions compilerOptions) {
        this.compilerOptions = compilerOptions;
    }

    public EGLSQLStatementFactory(IDataBinding recordData, String ioObjectName, ICompilerOptions compilerOptions) {
        this.sqlRecordData = recordData;
        this.ioObjectName = ioObjectName;
        this.compilerOptions = compilerOptions;
    }

    public String buildDefaultSQLStatement() {
        return null;
    }

    protected boolean containsOnlyKeyOrReadOnlyColumns() {
        if (this.getSQLRecordTypeBinding() != null) {
            return SQLUtility.containsOnlyKeyOrReadOnlyColumns(this.sqlRecordData, this.getKeyItems());
        }
        return false;
    }

    private int getTableIndex(String tableName) {
        int index = -1;
        if (this.tableNames != null && tableName != null) {
            int i = 0;
            while (i < this.tableNames.length) {
                if (tableName.equals(this.tableNames[i])) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        return index;
    }

    protected String getDefaultSelectConditions() {
        String defaultSelectConditions = null;
        if ((SQLUtility.isEntityRecord(this.sqlRecordData) || SQLUtility.isBasicRecord(this.sqlRecordData)) && this.tableNames.length > 0) {
            Map<ITypeBinding, String> foreignKeys = SQLUtility.getForeignKeys(this.sqlRecordData);
            String masterTableName = null;
            String slaveTableName = SQLUtility.getTableName(this.sqlRecordData.getType());
            int slaveIndex = this.getTableIndex(slaveTableName);
            if (slaveTableName != null && slaveIndex != -1 && foreignKeys != null) {
                for (ITypeBinding masterTable : foreignKeys.keySet()) {
                    int tableIndex;
                    masterTableName = SQLUtility.getTableName(masterTable);
                    if (masterTableName == null || (tableIndex = this.getTableIndex(masterTableName)) == -1) continue;
                    defaultSelectConditions = String.valueOf(this.tableLabels[slaveIndex]) + "." + foreignKeys.get(masterTable) + "=" + this.tableLabels[tableIndex] + "." + SQLUtility.getIdColumnName(masterTable) + " " + "and" + " " + this.tableLabels[tableIndex] + "." + SQLUtility.getIdColumnName(masterTable) + "=" + "?";
                }
            }
        }
        if (defaultSelectConditions == null) {
            return null;
        }
        if ((defaultSelectConditions = defaultSelectConditions.trim()).length() == 0) {
            return null;
        }
        defaultSelectConditions = new EGLSQLParser(defaultSelectConditions, "ANY", this.compilerOptions).getAllClauses();
        defaultSelectConditions = this.trimLeadingChar(defaultSelectConditions, '\r');
        defaultSelectConditions = this.trimLeadingChar(defaultSelectConditions, '\n');
        if ((defaultSelectConditions = this.trimLeadingChar(defaultSelectConditions, ' ')).trim().length() == 0) {
            return null;
        }
        return defaultSelectConditions;
    }

    public String trimLeadingChar(String s, char charToTrim) {
        char[] c = s.toCharArray();
        int length = c.length;
        int start = 0;
        while (start < length && c[start] == charToTrim) {
            ++start;
        }
        return start > 0 ? s.substring(start, length) : s;
    }

    private String replaceString(String str, String s, String replacement) {
        int strLength = str.length();
        StringBuffer buffer = new StringBuffer(strLength);
        int start = 0;
        int index = str.indexOf(s);
        while (index != -1) {
            buffer.append(str.substring(start, index));
            start = index + s.length();
            buffer.append(replacement);
            index = str.indexOf(s, start);
        }
        if (start <= strLength) {
            buffer.append(str.substring(start, strLength));
        }
        return buffer.toString();
    }

    public ArrayList getErrorMessages() {
        return this.errorMessages;
    }

    public abstract String getIOType();

    public String getWhereCurrentOfClause() {
        return "where current of resultSetID";
    }

    protected boolean hasReadWriteColumns() {
        if (this.getSQLRecordTypeBinding() != null) {
            return SQLUtility.hasReadWriteColumns(this.sqlRecordData);
        }
        return true;
    }

    protected boolean isIoObjectValid() {
        return true;
    }

    protected boolean isSQLRecordDefinedWithMultipleTables() {
        return SQLUtility.isSQLRecordDefinedWithMultipleTables(this.sqlRecordData);
    }

    protected void setupItemColumnAndKeyInfo() {
    }

    protected boolean setupSQLInfo() {
        boolean isValidIoObject = true;
        if (!SQLUtility.isEntityRecord(this.sqlRecordData) && !SQLUtility.isBasicRecord(this.sqlRecordData)) {
            isValidIoObject = false;
        } else {
            IDataBinding[] dataBindings = SQLUtility.getFields(this.sqlRecordData);
            this.structureItemBindings = new IDataBinding[dataBindings.length];
            int i = 0;
            while (i < dataBindings.length) {
                IDataBinding itemBinding = dataBindings[i];
                if (this.shouldKeep(itemBinding)) {
                    this.structureItemBindings[this.numSQLDataItems] = itemBinding;
                    ++this.numSQLDataItems;
                }
                ++i;
            }
            if (SQLUtility.isEntityRecord(this.sqlRecordData) && !this.isIoObjectValid()) {
                isValidIoObject = false;
            }
        }
        if (!isValidIoObject) {
            this.errorMessages.add(0, this.getCouldNotBuildDefaultMessage());
            return false;
        }
        this.setupItemColumnAndKeyInfo();
        this.setupTableInfo();
        return true;
    }

    private boolean shouldKeep(IDataBinding dataBinding) {
        boolean persistentValue = true;
        if (!SQLUtility.isValid(dataBinding)) {
            return false;
        }
        IAnnotationBinding annotation = this.sqlRecordData.getAnnotationFor(EGLIOSQL, "Persistent", new IDataBinding[]{dataBinding});
        if (annotation != null) {
            boolean bl = persistentValue = annotation.getValue() == Boolean.YES;
        }
        if (!persistentValue) {
            return false;
        }
        ITypeBinding typeBinding = dataBinding.getType();
        if (typeBinding.getKind() != 3) {
            return false;
        }
        return ((PrimitiveTypeBinding)typeBinding).getPrimitive() != Primitive.ANY;
    }

    protected void setupTableInfo() {
        ArrayList<String> sqlTables = new ArrayList<String>();
        ArrayList<String> sqlTableLables = new ArrayList<String>();
        int tableIndex = 1;
        boolean haveTableAnnotation = false;
        if (SQLUtility.isEntityRecord(this.sqlRecordData) || SQLUtility.isBasicRecord(this.sqlRecordData)) {
            ArrayList<ITypeBinding> declarers = new ArrayList<ITypeBinding>();
            declarers.add(this.getSQLRecordTypeBinding());
            if (this.sqlRecordData.getDeclaringPart() != null && 7 == this.sqlRecordData.getDeclaringPart().getKind() && "get".toUpperCase().equals(this.getIOType())) {
                declarers.add(this.sqlRecordData.getDeclaringPart());
            }
            for (ITypeBinding declarer : declarers) {
                IAnnotationBinding tableNameAnnotation;
                IAnnotationBinding annotation = declarer.getAnnotation(SQLUtility.EGLXSQL, "Table");
                haveTableAnnotation = false;
                if (annotation != null && (tableNameAnnotation = (IAnnotationBinding)annotation.findData("name")) != null) {
                    haveTableAnnotation = true;
                    sqlTables.add((String)tableNameAnnotation.getValue());
                    sqlTableLables.add("t" + tableIndex);
                    ++tableIndex;
                }
                if (haveTableAnnotation) continue;
                if (declarer == this.sqlRecordTypeBinding) {
                    sqlTables.add(this.getSQLRecordTypeBinding().getCaseSensitiveName());
                } else {
                    sqlTables.add(declarer.getCaseSensitiveName());
                }
                sqlTableLables.add("t" + tableIndex);
                ++tableIndex;
            }
        }
        this.tableNames = sqlTables.toArray(new String[0]);
        this.tableLabels = sqlTableLables.toArray(new String[0]);
    }

    protected Problem getCouldNotBuildDefaultMessage() {
        return new Problem(0, 0, 2, 4515, new String[]{this.getSQLStatementType(), this.getIOType(), this.ioObjectName});
    }

    protected boolean validateSQLRecordContainsOneNonReadOnlyOrNonKeyColumn() {
        if (this.containsOnlyKeyOrReadOnlyColumns()) {
            this.errorMessages.add(new Problem(0, 0, 2, 4533, new String[]{this.ioObjectName, this.getIOType()}));
            return false;
        }
        return true;
    }

    protected boolean validateSQLRecordNotJoin() {
        if (this.isSQLRecordDefinedWithMultipleTables()) {
            this.errorMessages.add(new Problem(0, 0, 2, 4532, new String[]{this.ioObjectName, this.getIOType()}));
            return false;
        }
        return true;
    }

    protected boolean validateSQLRecordNotJoinAndContainsOneNonReadOnlyOrNonKeyColumn() {
        boolean isValid = this.validateSQLRecordNotJoin();
        if (!this.validateSQLRecordContainsOneNonReadOnlyOrNonKeyColumn()) {
            isValid = false;
        }
        return isValid;
    }

    public boolean getAddIOObjectValidationErrorMessages() {
        return this.addIOObjectValidationErrorMessages;
    }

    public void setAddIOObjectValidationErrorMessages(boolean addIOObjectValidationErrorMessages) {
        this.addIOObjectValidationErrorMessages = addIOObjectValidationErrorMessages;
    }

    public IDataBinding[] getKeyItems() {
        if (this.keyItems == null) {
            if (SQLUtility.isValid(this.sqlRecordData)) {
                IDataBinding[] dataBindings = SQLUtility.getFields(this.sqlRecordData);
                IAnnotationBinding annotation = null;
                ArrayList<IDataBinding> annoData = new ArrayList<IDataBinding>();
                IDataBinding[] iDataBindingArray = dataBindings;
                int n = dataBindings.length;
                int n2 = 0;
                while (n2 < n) {
                    IDataBinding dataBinding = iDataBindingArray[n2];
                    annotation = dataBinding.getAnnotation(SQLUtility.EGLXPERSISTENCE, "Id");
                    if (annotation != null) {
                        annoData.add(dataBinding);
                    }
                    ++n2;
                }
                if (annoData != null) {
                    this.keyItems = this.eliminateInvalid(annoData.toArray());
                }
            }
            if (this.keyItems == null) {
                this.keyItems = new IDataBinding[0];
            }
        }
        return this.keyItems;
    }

    private IDataBinding[] eliminateInvalid(Object[] bindings) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (bindings != null) {
            int i = 0;
            while (i < bindings.length) {
                if (SQLUtility.isValid((IDataBinding)bindings[i])) {
                    list.add(bindings[i]);
                }
                ++i;
            }
        }
        return list.toArray(new IDataBinding[list.size()]);
    }

    protected boolean validateSQLRecordContainsReadWriteColumns() {
        if (!this.hasReadWriteColumns()) {
            this.errorMessages.add(new Problem(0, 0, 2, 4531, new String[]{this.ioObjectName, this.getIOType()}));
            return false;
        }
        return true;
    }

    protected boolean validateSQLRecordNotJoinAndContainsReadWriteColumns() {
        boolean isValid = this.validateSQLRecordNotJoin();
        if (!this.validateSQLRecordContainsReadWriteColumns()) {
            isValid = false;
        }
        return isValid;
    }

    public void setupForSQLUpdateStatement() {
        String[] items = new String[this.numSQLDataItems];
        String[] columns = new String[this.numSQLDataItems];
        int numNonReadOnlyAndKeys = 0;
        int numKeys = 0;
        if (this.keyItemAndColumnNames == null) {
            this.keyItemAndColumnNames = this.getKeyItems() != null ? new String[this.getKeyItems().length][2] : new String[0][0];
        } else {
            this.useRecordKeys = false;
        }
        if (this.structureItemBindings != null) {
            int i = 0;
            while (i < this.numSQLDataItems) {
                IDataBinding itemBinding = this.structureItemBindings[i];
                String itemName = itemBinding.getName();
                String columnName = this.getColumnName(itemBinding);
                boolean isUpdateable = this.getIsUpdateable(itemBinding);
                if (isUpdateable && !this.isRecordKeyItem(itemBinding)) {
                    items[numNonReadOnlyAndKeys] = itemName;
                    columns[numNonReadOnlyAndKeys] = columnName;
                    ++numNonReadOnlyAndKeys;
                }
                if (this.useRecordKeys && this.isRecordKeyItem(itemBinding)) {
                    this.keyItemAndColumnNames[numKeys][0] = itemName;
                    this.keyItemAndColumnNames[numKeys][1] = columnName;
                    ++numKeys;
                }
                ++i;
            }
        }
        if (numNonReadOnlyAndKeys != 0) {
            this.itemNames = new String[numNonReadOnlyAndKeys];
            this.columnNames = new String[numNonReadOnlyAndKeys];
            int i = 0;
            while (i < numNonReadOnlyAndKeys) {
                this.itemNames[i] = items[i];
                this.columnNames[i] = columns[i];
                ++i;
            }
        }
        if (this.useRecordKeys && numKeys == 0 && this.getKeyItems().length > 0) {
            this.keyItemAndColumnNames = new String[0][0];
        }
    }

    protected boolean isRecordKeyItem(IDataBinding data) {
        return SQLUtility.isRecordKey(data, this.getKeyItems());
    }

    protected void setupForSQLInsertStatement() {
        String[] items = new String[this.numSQLDataItems];
        String[] columns = new String[this.numSQLDataItems];
        int numNonReadOnly = 0;
        if (this.structureItemBindings != null) {
            int i = 0;
            while (i < this.numSQLDataItems) {
                IDataBinding itemBinding = this.structureItemBindings[i];
                String itemName = itemBinding.getName();
                String columnName = this.getColumnName(itemBinding);
                boolean isReadOnly = this.getIsReadOnly(itemBinding);
                if (!isReadOnly) {
                    items[numNonReadOnly] = itemName;
                    columns[numNonReadOnly] = columnName;
                    ++numNonReadOnly;
                }
                ++i;
            }
        }
        if (numNonReadOnly != 0) {
            this.itemNames = new String[numNonReadOnly];
            this.columnNames = new String[numNonReadOnly];
            int i = 0;
            while (i < numNonReadOnly) {
                this.itemNames[i] = items[i];
                this.columnNames[i] = columns[i];
                ++i;
            }
        }
    }

    public abstract String getSQLStatementType();

    public String getEglUsingClause() {
        return null;
    }

    protected ITypeBinding getSQLRecordTypeBinding() {
        if (this.sqlRecordTypeBinding == null && SQLUtility.isValid(this.sqlRecordData)) {
            this.sqlRecordTypeBinding = this.sqlRecordData.getType().getBaseType();
        }
        return this.sqlRecordTypeBinding;
    }

    protected String getColumnName(IDataBinding itemBinding) {
        return SQLUtility.getColumnName(itemBinding, this.sqlRecordData);
    }

    protected boolean getIsReadOnly(IDataBinding itemBinding) {
        return SQLUtility.getIsReadOnly(itemBinding, this.sqlRecordData);
    }

    protected boolean getIsUpdateable(IDataBinding itemBinding) {
        return SQLUtility.getIsUpdateable(itemBinding);
    }

    private static IAnnotationBinding getField(IAnnotationBinding aBinding, String fieldName) {
        IDataBinding fieldBinding = aBinding.findData(fieldName);
        return IBinding.NOT_FOUND_BINDING == fieldBinding ? null : (IAnnotationBinding)fieldBinding;
    }
}

