/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.sql.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.IRecordBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.NotFoundBinding;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.internal.sql.SQLConstants;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class SQLUtility {
    public static final String[] EGLIOSQL = new String[]{"egl", "io", "sql"};
    public static final String[] EGLXSQL = new String[]{"eglx", "persistence", "sql"};
    public static final String[] EGLXPERSISTENCE = new String[]{"eglx", "persistence"};

    public static boolean containsOnlyKeyOrReadOnlyColumns(IDataBinding sqlRecordData, String[][] usingKeyItemAndColumnNames) {
        if (!SQLUtility.isValid(sqlRecordData)) {
            return false;
        }
        IDataBinding[] sqlDataItems = SQLUtility.getFields(sqlRecordData);
        int i = 0;
        while (i < sqlDataItems.length) {
            IDataBinding itemBinding = sqlDataItems[i];
            if (!SQLUtility.getIsReadOnly(itemBinding, sqlRecordData) && !SQLUtility.isUsingKeyColumn(itemBinding, usingKeyItemAndColumnNames, sqlRecordData)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isUsingKeyColumn(IDataBinding itemBinding, String[][] usingKeyItemAndColumnNames, IDataBinding recordData) {
        int i = 0;
        while (i < usingKeyItemAndColumnNames.length) {
            if (SQLUtility.getColumnName(itemBinding, recordData).equalsIgnoreCase(usingKeyItemAndColumnNames[i][1])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsOnlyKeyOrReadOnlyColumns(IDataBinding sqlRecordData, IDataBinding[] recordKeyItems) {
        if (!SQLUtility.isValid(sqlRecordData)) {
            return false;
        }
        IDataBinding[] sqlDataItems = SQLUtility.getFields(sqlRecordData);
        int i = 0;
        while (i < sqlDataItems.length) {
            IDataBinding itemBinding = sqlDataItems[i];
            if (!SQLUtility.getIsReadOnly(itemBinding, sqlRecordData) && !SQLUtility.isRecordKey(itemBinding, recordKeyItems)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isRecordKey(IDataBinding dataBinding, IDataBinding[] keyItems) {
        int i = 0;
        while (i < keyItems.length) {
            if (dataBinding == keyItems[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasReadWriteColumns(IDataBinding sqlRecordData) {
        if (!SQLUtility.isValid(sqlRecordData)) {
            return false;
        }
        IDataBinding[] sqlDataItems = SQLUtility.getFields(sqlRecordData);
        int i = 0;
        while (i < sqlDataItems.length) {
            IDataBinding itemBinding = sqlDataItems[i];
            if (!SQLUtility.getIsReadOnly(itemBinding, sqlRecordData)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isSQLIOType(String ioType) {
        if (ioType != null) {
            int i = 0;
            while (i < SQLConstants.SQL_IO_TYPE_STRINGS.length) {
                if (SQLConstants.SQL_IO_TYPE_STRINGS[i].equalsIgnoreCase(ioType)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isSQLRecordDefinedWithMultipleTables(IDataBinding sqlRecordData) {
        String[][] tableNameVars;
        String[][] tableNames;
        if (!SQLUtility.isValid(sqlRecordData)) {
            return false;
        }
        int numTables = 0;
        int numTableVars = 0;
        if (sqlRecordData.getAnnotation(EGLIOSQL, "SQLRecord") == null) {
            return false;
        }
        IAnnotationBinding annotation = SQLUtility.getField(sqlRecordData.getAnnotation(EGLIOSQL, "SQLRecord"), "tableNames");
        if (annotation != null && (tableNames = (String[][])annotation.getValue()) != null && (numTables = tableNames.length) > 1) {
            return true;
        }
        annotation = SQLUtility.getField(sqlRecordData.getAnnotation(EGLIOSQL, "SQLRecord"), "tableNameVariables");
        if (annotation != null && (tableNameVars = (String[][])annotation.getValue()) != null && (numTableVars = tableNameVars.length) > 1) {
            return true;
        }
        return numTables + numTableVars > 1;
    }

    public static boolean isSQLRecord(IDataBinding sqlRecordData) {
        if (!SQLUtility.isValid(sqlRecordData)) {
            return false;
        }
        return sqlRecordData.getAnnotation(EGLIOSQL, "SQLRecord") != null;
    }

    public static boolean isEntityRecord(IDataBinding sqlRecordData) {
        if (!SQLUtility.isValid(sqlRecordData)) {
            return false;
        }
        IAnnotationBinding annotation = null;
        ITypeBinding typeBinding = sqlRecordData.getType();
        if (typeBinding != null && typeBinding.isReference()) {
            ITypeBinding baseTypeBinding = typeBinding.getBaseType();
            annotation = baseTypeBinding.getAnnotation(EGLXPERSISTENCE, "Entity");
        } else {
            annotation = typeBinding.getAnnotation(EGLXPERSISTENCE, "Entity");
        }
        return annotation != null;
    }

    public static boolean isBasicRecord(IDataBinding sqlRecordData) {
        if (!SQLUtility.isValid(sqlRecordData)) {
            return false;
        }
        ITypeBinding typeBinding = sqlRecordData.getType();
        boolean isValid = typeBinding.isTypeBinding() && (typeBinding.getKind() == 7 || typeBinding.getKind() == 6);
        return isValid;
    }

    public static boolean isSQLRecordPart(Record record) {
        return record.hasSubType() && record.getSubType().getIdentifier() == InternUtil.intern((String)"SQLRecord");
    }

    public static String getColumnName(IDataBinding itemBinding, IDataBinding recordData) {
        IAnnotationBinding annotation = itemBinding.getAnnotation(EGLXSQL, "column");
        if (annotation != null) {
            IAnnotationBinding columnNameAnnotation = (IAnnotationBinding)annotation.findData("name");
            if (!(columnNameAnnotation instanceof NotFoundBinding)) {
                return (String)columnNameAnnotation.getValue();
            }
            return itemBinding.getName();
        }
        return itemBinding.getName();
    }

    public static boolean getIsReadOnly(IDataBinding itemBinding, IDataBinding recordData) {
        boolean isReadOnly = false;
        IAnnotationBinding annotation = itemBinding.getAnnotation(EGLXSQL, "generatedValue");
        if (annotation != null) {
            isReadOnly = true;
        } else {
            IAnnotationBinding insertableAnnotation = SQLUtility.getColumnAnnotation(itemBinding, "insertable");
            if (insertableAnnotation != null && !(insertableAnnotation instanceof NotFoundBinding) && insertableAnnotation.getValue() == Boolean.NO) {
                isReadOnly = true;
            }
        }
        return isReadOnly;
    }

    public static boolean getIsUpdateable(IDataBinding itemBinding) {
        boolean isUpdateable = true;
        IAnnotationBinding updateableAnnotation = SQLUtility.getColumnAnnotation(itemBinding, "updateable");
        if (updateableAnnotation != null && !(updateableAnnotation instanceof NotFoundBinding) && updateableAnnotation.getValue() == Boolean.NO) {
            isUpdateable = false;
        }
        return isUpdateable;
    }

    private static IAnnotationBinding getColumnAnnotation(IDataBinding itemBinding, String annotationName) {
        IAnnotationBinding columnAnnotation = null;
        IAnnotationBinding annotation = itemBinding.getAnnotation(EGLXSQL, "column");
        if (annotation != null) {
            columnAnnotation = (IAnnotationBinding)annotation.findData(annotationName);
        }
        return columnAnnotation;
    }

    public static boolean isValid(IDataBinding dataBinding) {
        if (dataBinding == null || dataBinding == IBinding.NOT_FOUND_BINDING) {
            return false;
        }
        if (dataBinding.getType() == null || dataBinding.getType() == IBinding.NOT_FOUND_BINDING) {
            return false;
        }
        return dataBinding.getType().getBaseType() != null && dataBinding.getType().getBaseType() != IBinding.NOT_FOUND_BINDING;
    }

    public static IDataBinding[] getFields(IDataBinding dataBinding) {
        ITypeBinding typeBinding;
        if (SQLUtility.isValid(dataBinding) && ((typeBinding = dataBinding.getType().getBaseType()).getKind() == 7 || typeBinding.getKind() == 6)) {
            return ((IRecordBinding)((Object)typeBinding)).getFields();
        }
        return new IDataBinding[0];
    }

    public static IDataBinding[] getFields(ITypeBinding typeBinding) {
        if (typeBinding.getKind() == 7 || typeBinding.getKind() == 6) {
            return ((IRecordBinding)((Object)typeBinding)).getFields();
        }
        return new IDataBinding[0];
    }

    public static String getTableName(ITypeBinding typeBinding) {
        if (typeBinding != null) {
            ITypeBinding elementTypeBinding = null;
            elementTypeBinding = typeBinding.isReference() ? typeBinding.getBaseType() : typeBinding;
            IAnnotationBinding annotation = elementTypeBinding.getAnnotation(EGLXSQL, "Table");
            if (annotation != null) {
                IAnnotationBinding tableNameAnnotation = (IAnnotationBinding)annotation.findData("name");
                return (String)tableNameAnnotation.getValue();
            }
        }
        return null;
    }

    public static String getIdColumnName(ITypeBinding typeBinding) {
        if (typeBinding != null) {
            IDataBinding[] fields;
            IDataBinding[] iDataBindingArray = fields = SQLUtility.getFields(typeBinding);
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                IDataBinding field = iDataBindingArray[n2];
                IAnnotationBinding annotation = field.getAnnotation(EGLXPERSISTENCE, "Id");
                if (annotation != null) {
                    annotation = field.getAnnotation(EGLXPERSISTENCE, "column");
                    if (annotation != null) {
                        IAnnotationBinding tableNameAnnotation = (IAnnotationBinding)annotation.findData("name");
                        return (String)tableNameAnnotation.getValue();
                    }
                    return field.getCaseSensitiveName();
                }
                ++n2;
            }
        }
        return null;
    }

    public static Map<ITypeBinding, String> getForeignKeys(IDataBinding dataBinding) {
        IDataBinding[] fieldBindings;
        HashMap<IPartBinding, String> foreignKeys = null;
        IDataBinding[] iDataBindingArray = fieldBindings = SQLUtility.getFields(dataBinding);
        int n = fieldBindings.length;
        int n2 = 0;
        while (n2 < n) {
            IDataBinding fieldBinding = iDataBindingArray[n2];
            String foreignKey = SQLUtility.getForeignKeyName(fieldBinding);
            if (foreignKey != null) {
                if (foreignKeys == null) {
                    foreignKeys = new HashMap<IPartBinding, String>();
                }
                if (fieldBinding.getType().getKind() == 3) {
                    foreignKeys.put(dataBinding.getDeclaringPart(), foreignKey);
                } else {
                    foreignKeys.put(fieldBinding.getDeclaringPart(), foreignKey);
                }
            }
            ++n2;
        }
        return foreignKeys;
    }

    private static String getForeignKeyName(IDataBinding fieldBinding) {
        String columnName = null;
        IAnnotationBinding annotation = fieldBinding.getAnnotation(EGLXPERSISTENCE, "ManyToOne");
        if (annotation != null) {
            columnName = fieldBinding.getCaseSensitiveName();
        }
        return columnName;
    }

    public static String getColumnName(Expression expr) {
        IDataBinding data = expr.resolveDataBinding();
        if (data != null && data != IBinding.NOT_FOUND_BINDING) {
            IAnnotationBinding annotation = data.getAnnotation(EGLIOSQL, "Column");
            if (annotation != null) {
                return (String)annotation.getValue();
            }
            return data.getName();
        }
        return null;
    }

    public static IAnnotationBinding getField(IAnnotationBinding aBinding, String fieldName) {
        IDataBinding fieldBinding = aBinding.findData(fieldName);
        return IBinding.NOT_FOUND_BINDING == fieldBinding ? null : (IAnnotationBinding)fieldBinding;
    }

    public static boolean isTerraDataSupported() {
        String temp = System.getProperty("EGL_TERADATA", "false");
        return "true".equals(temp);
    }
}

