/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.tools;

import java.io.File;
import java.util.Set;
import org.eclipse.edt.compiler.EDTCompiler;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.EVisitor;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.lookup.PartEnvironment;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.impl.AbstractVisitor;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.FileSystemObjectStore;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.MofObjectNotFoundException;
import org.eclipse.edt.mof.serialization.ObjectStore;

public class TestLoadPart {
    public static void main(String[] args) {
        new TestLoadPart().doIt(args);
    }

    public void doIt(String[] args) {
        File root = null;
        String partName = null;
        if (args.length > 0) {
            root = new File(args[0]);
        }
        if (args.length > 1) {
            partName = args[1];
        } else {
            root = new File("d:/workspaces/EGL_CE/org.eclipse.edt.mof.egl/EGL_MOF");
            partName = "egl:lc.eksportremburs.datatables.common.lcget01";
        }
        FileSystemObjectStore typeStore = new FileSystemObjectStore(root, (IEnvironment)PartEnvironment.getCurrentEnv(), "XML");
        PartEnvironment.getCurrentEnv().registerObjectStore("mof", (ObjectStore)typeStore);
        typeStore = new FileSystemObjectStore(root, (IEnvironment)PartEnvironment.getCurrentEnv(), "XML", ".eglxml");
        PartEnvironment.getCurrentEnv().registerObjectStore("egl", (ObjectStore)typeStore);
        new EDTCompiler().getSystemEnvironment(null);
        try {
            EObject eClass = null;
            int i = 0;
            while (i < 2) {
                long start = System.currentTimeMillis();
                eClass = Environment.INSTANCE.find(partName);
                System.out.println("Time to load: " + (System.currentTimeMillis() - start));
                ++i;
            }
            if (eClass instanceof Part) {
                this.visitStuff((Part)eClass);
                Set types = IRUtils.getReferencedPartsFor((Part)((Part)eClass));
                System.out.println("Referenced parts for: " + ((Part)eClass).getFullyQualifiedName());
                for (Part part : types) {
                    System.out.println(part.getFullyQualifiedName());
                }
            }
        }
        catch (MofObjectNotFoundException e) {
            e.printStackTrace();
        }
        catch (DeserializationException e) {
            e.printStackTrace();
        }
    }

    public void visitStuff(Part part) {
        MyVisitor visitor = new MyVisitor();
        visitor.disallowRevisit();
        part.accept((EVisitor)visitor);
    }

    public static class MyVisitor
    extends AbstractVisitor {
    }
}

