/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.datamodel.validate;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;

public class ValidationManager {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    private HashSet projects = new HashSet();
    private boolean isAutoBuild_;
    private boolean autoBuildDisabled_;

    public ValidationManager() {
        this.setAutoBuildPreference();
        this.autoBuildDisabled_ = false;
    }

    public void disableValidationForProject(IProject project) {
        this.projects.add(project);
    }

    public void restoreValidationForProjects(boolean runValidation) {
    }

    public void modifyAutoBuild(boolean isAutoBuild) {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription workspaceDesc = workspace.getDescription();
            workspaceDesc.setAutoBuilding(isAutoBuild);
            workspace.setDescription(workspaceDesc);
        }
        catch (Exception exception) {}
    }

    public void disableAutoBuild() {
        if (!this.autoBuildDisabled_) {
            this.setAutoBuildPreference();
            this.modifyAutoBuild(false);
            this.autoBuildDisabled_ = true;
        }
    }

    public void restoreAutoBuild() {
        if (this.autoBuildDisabled_) {
            this.modifyAutoBuild(this.getAutoBuildPreference());
            this.autoBuildDisabled_ = false;
        }
    }

    public boolean setAutoBuildPreference() {
        this.isAutoBuild_ = this.getWorkspaceAutoBuildPreference();
        return this.isAutoBuild_;
    }

    public boolean getAutoBuildPreference() {
        return this.isAutoBuild_;
    }

    public boolean getWorkspaceAutoBuildPreference() {
        IWorkspaceDescription workspaceDesc = ResourcesPlugin.getWorkspace().getDescription();
        return workspaceDesc.isAutoBuilding();
    }
}

