/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.core.EDTRuntimeContainerEntry;
import org.eclipse.jdt.core.IClasspathEntry;

public class EDTRuntimeContainer {
    private final String id;
    private final String name;
    private final String description;
    private final IClasspathEntry[] entries;
    private final IPath path;

    public EDTRuntimeContainer(String id, String name, String description, EDTRuntimeContainerEntry[] entries) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.path = new Path("org.eclipse.edt.ide.core.EDT_CONTAINER").append(this.id);
        if (entries == null || entries.length == 0) {
            this.entries = new IClasspathEntry[0];
        } else {
            ArrayList<IClasspathEntry> resolvedEntries = new ArrayList<IClasspathEntry>(entries.length);
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry entry = entries[i].getClasspathEntry();
                if (entry != null) {
                    resolvedEntries.add(entry);
                }
                ++i;
            }
            this.entries = resolvedEntries.toArray(new IClasspathEntry[resolvedEntries.size()]);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public IClasspathEntry[] getEntries() {
        return this.entries;
    }

    public IPath getPath() {
        return this.path;
    }
}

