/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.ide.core.internal.builder.BuildManager;
import org.eclipse.edt.ide.core.internal.builder.DuplicatePartManager;
import org.eclipse.edt.ide.core.internal.builder.ProjectSettingsListenerManager;
import org.eclipse.edt.ide.core.internal.builder.Util;
import org.eclipse.edt.ide.core.internal.dependency.DependencyGraph;
import org.eclipse.edt.ide.core.internal.dependency.DependencyGraphManager;
import org.eclipse.edt.ide.core.internal.dependency.IFunctionRequestor;
import org.eclipse.edt.ide.core.internal.generation.GenerationBuildManager;
import org.eclipse.edt.ide.core.internal.lookup.FileInfoManager;
import org.eclipse.edt.ide.core.internal.lookup.IFileInfo;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathEntryManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironmentManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectInfoManager;
import org.eclipse.edt.ide.core.internal.lookup.ZipFileBuildPathEntryManager;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class ResourceChangeProcessor
implements IResourceChangeListener {
    private Map contextSpecificMarkersForDeletion = new HashMap();
    private Set removedProjects = new HashSet();

    public void resourceChanged(IResourceChangeEvent event) {
        boolean postChange;
        boolean projectDeleting = event.getType() == 4;
        boolean projectClosing = event.getType() == 2;
        boolean preBuilding = event.getType() == 8;
        boolean bl = postChange = event.getType() == 1;
        if (projectDeleting || projectClosing) {
            this.processProjectDelete((IProject)event.getResource());
        } else if (preBuilding) {
            this.removeContextSpecificMarkers();
        } else if (postChange) {
            IResourceDelta[] affectedChildren;
            IResourceDelta delta = event.getDelta();
            IResourceDelta[] iResourceDeltaArray = affectedChildren = delta.getAffectedChildren();
            int n = affectedChildren.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource;
                IResourceDelta child = iResourceDeltaArray[n2];
                if ((child.getFlags() & 0x4000) != 0) {
                    resource = child.getResource();
                    if (resource.getType() == 4 && EGLProject.hasEGLNature((IProject)resource)) {
                        ProjectSettingsListenerManager.getInstance().addProject((IProject)resource);
                    }
                } else if (child.getKind() == 4 && (resource = child.getResource()).getType() == 4 && EGLProject.hasEGLNature((IProject)resource)) {
                    ProjectSettingsListenerManager.getInstance().addProject((IProject)resource);
                }
                ++n2;
            }
        }
    }

    public void processProjectClose(IProject project) {
        this.processProjectDelete(project);
    }

    public void processProjectDelete(IProject project) {
        if (EGLProject.hasEGLNature(project)) {
            this.removedProjects.add(project.getName());
            this.collectContextSpecificMarkersForRemoval(project);
            ZipFileBuildPathEntryManager.getInstance().clear(project);
            FileInfoManager.getInstance().removeProject(project);
            ProjectEnvironmentManager.getInstance().remove(project);
            ProjectBuildPathEntryManager.getInstance().remove(project);
            ProjectBuildPathManager.getInstance().remove(project);
            ProjectInfoManager.getInstance().remove(project);
            DependencyGraphManager.getInstance().remove(project);
            BuildManager.getInstance().removeProject(project);
            GenerationBuildManager.getInstance().removeProject(project);
            DuplicatePartManager.getInstance().remove(project);
            ProjectSettingsListenerManager.getInstance().removeProject(project);
        }
    }

    private void collectContextSpecificMarkersForRemoval(final IProject project) {
        try {
            IContainer[] sourceLocations = ProjectBuildPathManager.getInstance().getProjectBuildPath(project).getSourceLocations();
            int i = 0;
            int l = sourceLocations.length;
            while (i < l) {
                IContainer sourceLocation = sourceLocations[i];
                final int segmentCount = sourceLocation.getFullPath().segmentCount();
                IResource[] children = sourceLocation.members();
                int j = 0;
                while (j < children.length) {
                    children[j].accept(new IResourceProxyVisitor(){

                        public boolean visit(IResourceProxy proxy) throws CoreException {
                            IResource resource = proxy.requestResource();
                            switch (proxy.getType()) {
                                case 1: {
                                    final IFile file = (IFile)resource;
                                    if (org.eclipse.edt.ide.core.internal.model.Util.isEGLFileName(resource.getName())) {
                                        String[] packageName = InternUtil.intern((String[])org.eclipse.edt.ide.core.internal.utils.Util.pathToStringArray(resource.getFullPath().removeFirstSegments(segmentCount).removeLastSegments(1)));
                                        IFileInfo fileInfo = FileInfoManager.getInstance().getFileInfo(project, file.getProjectRelativePath());
                                        if (fileInfo != null) {
                                            Set partNames = fileInfo.getPartNames();
                                            for (final String partName : partNames) {
                                                DependencyGraph dependencyGraph = DependencyGraphManager.getInstance().getDependencyGraph(project);
                                                dependencyGraph.findFunctionDependencies(packageName, partName, new IFunctionRequestor(){

                                                    @Override
                                                    public void acceptFunction(String functionProjectName, String[] functionPackageName, String functionPartName) {
                                                        ArrayList<ContextSpecificMarkerRemovalRequest> changes = (ArrayList<ContextSpecificMarkerRemovalRequest>)ResourceChangeProcessor.this.contextSpecificMarkersForDeletion.get(functionProjectName);
                                                        if (changes == null) {
                                                            changes = new ArrayList<ContextSpecificMarkerRemovalRequest>();
                                                            ResourceChangeProcessor.this.contextSpecificMarkersForDeletion.put(functionProjectName, changes);
                                                        }
                                                        changes.add(new ContextSpecificMarkerRemovalRequest(functionProjectName, functionPackageName, functionPartName, partName, file.getFullPath()));
                                                    }
                                                });
                                            }
                                        }
                                    }
                                    return false;
                                }
                            }
                            return true;
                        }
                    }, 0);
                    ++j;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void removeContextSpecificMarkers() {
        if (this.contextSpecificMarkersForDeletion.size() > 0) {
            try {
                for (String projectName : this.contextSpecificMarkersForDeletion.keySet()) {
                    if (this.removedProjects.contains(projectName)) continue;
                    List changes = (List)this.contextSpecificMarkersForDeletion.get(projectName);
                    for (ContextSpecificMarkerRemovalRequest removalRequest : changes) {
                        Util.removeMarkersFromInvokedFunctions(removalRequest.contextPartName, removalRequest.contextFilePath, removalRequest.functionProjectName, removalRequest.functionPackageName, removalRequest.functionPartName);
                    }
                }
            }
            finally {
                this.contextSpecificMarkersForDeletion.clear();
            }
        }
        this.removedProjects.clear();
    }

    public class ContextSpecificMarkerRemovalRequest {
        private String functionProjectName;
        private String[] functionPackageName;
        private String functionPartName;
        private IPath contextFilePath;
        private String contextPartName;

        public ContextSpecificMarkerRemovalRequest(String functionProjectName, String[] functionPackageName, String functionPartName, String contextPartName, IPath contextFilePath) {
            this.functionProjectName = functionProjectName;
            this.functionPackageName = functionPackageName;
            this.functionPartName = functionPartName;
            this.contextPartName = contextPartName;
            this.contextFilePath = contextFilePath;
        }
    }
}

