/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java_cup.runtime.Scanner;
import org.eclipse.core.resources.IFile;
import org.eclipse.edt.compiler.core.ast.ErrorCorrectingParser;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Lexer;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.VAGLexer;
import org.eclipse.edt.compiler.internal.EGLVAGCompatibilitySetting;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.utils.SoftLRUCache;
import org.eclipse.edt.ide.core.internal.utils.Util;

public abstract class AbstractASTManager {
    private SoftLRUCache fileLRUCache = new SoftLRUCache();

    public File getFileAST(IFile file) {
        File cachedFile = (File)this.fileLRUCache.get((Object)file);
        if (cachedFile == null) {
            try {
                String fileContents = Util.getFileContents(file);
                cachedFile = this.getFileAST(file, fileContents);
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
            this.fileLRUCache.put((Object)file, (Object)cachedFile);
        }
        return cachedFile;
    }

    public File getFileAST(Object key, String fileContents) {
        File result = (File)this.fileLRUCache.get(key);
        if (result == null) {
            result = this.getFileAST(new BufferedReader(new StringReader(fileContents)));
            this.fileLRUCache.put(key, (Object)result);
        }
        return result;
    }

    public File getFileAST(IFile file, String fileContents) {
        File result = null;
        try {
            result = this.getFileAST(new BufferedReader(new StringReader(fileContents)));
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        this.fileLRUCache.put((Object)file, (Object)result);
        return result;
    }

    private File getFileAST(Reader reader) {
        ErrorCorrectingParser parser = EGLVAGCompatibilitySetting.isVAGCompatibility() ? new ErrorCorrectingParser((Scanner)new VAGLexer(reader)) : new ErrorCorrectingParser((Scanner)new Lexer(reader));
        return (File)parser.parse().value;
    }

    public Part getPartAST(IFile declaringFile, String partName) {
        File file = this.getFileAST(declaringFile);
        return this.getPartAST(file, declaringFile, partName);
    }

    public Part getPartAST(File file, IFile declaringFile, String partName) {
        List parts = file.getParts();
        for (Part part : parts) {
            if (part.getIdentifier() != partName) continue;
            Part result = part.clonePart();
            this.doGetPartAST(declaringFile, result);
            return result;
        }
        throw new BuildException("Part must exist before calling this method");
    }

    protected void doGetPartAST(IFile declaringFile, Part result) {
    }

    public Node getAST(IFile declaringFile, String partName) {
        if (Util.getFilePartName(declaringFile) == partName) {
            return this.getFilePartAST(declaringFile);
        }
        return this.getPartAST(declaringFile, partName);
    }

    private Node getFilePartAST(IFile declaringFile) {
        return this.getFileAST(declaringFile).cloneFilePart();
    }

    public void clear() {
        this.fileLRUCache = new SoftLRUCache();
    }
}

