/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup.workingcopy;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.compiler.ICompiler;
import org.eclipse.edt.compiler.ISystemEnvironment;
import org.eclipse.edt.compiler.binding.FileBinding;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.PartBinding;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.EGLAliasJsfNamesSetting;
import org.eclipse.edt.compiler.internal.EGLVAGCompatibilitySetting;
import org.eclipse.edt.compiler.internal.core.builder.CircularBuildRequestException;
import org.eclipse.edt.compiler.internal.core.compiler.BindingCompletor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.NullDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.BindingCreator;
import org.eclipse.edt.compiler.internal.core.lookup.EnvironmentScope;
import org.eclipse.edt.compiler.internal.core.lookup.FileASTScope;
import org.eclipse.edt.compiler.internal.core.lookup.FileScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.core.lookup.SystemScope;
import org.eclipse.edt.compiler.internal.core.utils.PartBindingCache;
import org.eclipse.edt.ide.core.internal.binding.PartRestoreFailedException;
import org.eclipse.edt.ide.core.internal.builder.ASTManager;
import org.eclipse.edt.ide.core.internal.compiler.SystemEnvironmentManager;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyASTManager;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyProcessingQueue;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.IWorkingCopyBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectInfo;
import org.eclipse.edt.ide.core.internal.partinfo.IPartOrigin;
import org.eclipse.edt.ide.core.internal.utils.Util;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.PartNotFoundException;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.egl.utils.InternUtil;
import org.eclipse.edt.mof.serialization.CachingObjectStore;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.ObjectStore;

public class WorkingCopyProjectBuildPathEntry
implements IWorkingCopyBuildPathEntry {
    private PartBindingCache bindingCache;
    private WorkingCopyProjectEnvironment declaringEnvironment;
    private WorkingCopyProjectInfo projectInfo;
    private IEnvironment realizingEnvironment;
    private WorkingCopyProcessingQueue processingQueue;
    private ObjectStore[] stores;

    public WorkingCopyProjectBuildPathEntry(WorkingCopyProjectInfo projectInfo) {
        this.projectInfo = projectInfo;
        this.bindingCache = new PartBindingCache();
        this.stores = ProjectBuildPathEntry.EMPTY_STORES;
        this.realizingEnvironment = new RealizingEnvironment();
    }

    public boolean hasPackage(String[] packageName) {
        return this.projectInfo.hasPackage(packageName);
    }

    public IPartBinding getPartBinding(String[] packageName, String partName) {
        return this.getPartBinding(packageName, partName, false);
    }

    public IPartBinding getPartBinding(String[] packageName, String partName, boolean force) {
        IPartBinding result = null;
        if (this.processingQueue != null) {
            result = this.processingQueue.requestCompilationFor(packageName, partName, force);
        }
        if (result == null) {
            result = this.bindingCache.get(packageName, partName);
            if (result != null) {
                return result;
            }
            if (WorkingCopyProjectBuildPathManager.getInstance().getProjectBuildPath(this.projectInfo.getProject()).isBinary()) {
                IPartOrigin origin = this.projectInfo.getPartOrigin(packageName, partName);
                if (origin != null && origin.getEGLFile() != null && Util.getFilePartName(origin.getEGLFile()) == partName) {
                    try {
                        return this.compileLevel2Binding(packageName, this.projectInfo.getCaseSensitivePartName(packageName, partName));
                    }
                    catch (CircularBuildRequestException e) {
                        this.removePartBindingInvalid(packageName, partName);
                        throw e;
                    }
                }
                return null;
            }
            if (WorkingCopyProjectBuildPathManager.getInstance().getProjectBuildPath(this.projectInfo.getProject()).isReadOnly()) {
                return this.readPartBinding(packageName, partName);
            }
            if (this.projectInfo.hasPart(packageName, partName) != 1) {
                try {
                    return this.compileLevel2Binding(packageName, this.projectInfo.getCaseSensitivePartName(packageName, partName));
                }
                catch (CircularBuildRequestException e) {
                    this.removePartBindingInvalid(packageName, partName);
                    throw e;
                }
            }
            return null;
        }
        return result;
    }

    public IPartBinding getNewPartBinding(String[] packageName, String caseSensitiveInternedPartName, int kind) {
        String caseInsensitiveInternedPartName = InternUtil.intern((String)caseSensitiveInternedPartName);
        IPartBinding partBinding = this.bindingCache.get(packageName, caseInsensitiveInternedPartName);
        if (partBinding == null || partBinding.getKind() != kind) {
            partBinding = PartBinding.newPartBinding((int)kind, (String[])packageName, (String)caseSensitiveInternedPartName);
            this.bindingCache.put(packageName, caseInsensitiveInternedPartName, partBinding);
        } else {
            partBinding.clear();
            partBinding.setValid(false);
        }
        return partBinding;
    }

    public void setDeclaringEnvironment(WorkingCopyProjectEnvironment projectEnvironment) {
        this.declaringEnvironment = projectEnvironment;
    }

    public IPartBinding getPartBindingFromCache(String[] packageName, String partName) {
        return this.bindingCache.get(packageName, partName);
    }

    public IPartBinding getCachedPartBinding(String[] packageName, String partName) {
        return this.getPartBindingFromCache(packageName, partName);
    }

    public IPartBinding compileLevel2Binding(String[] packageName, String caseSensitiveInternedPartName) {
        String fileName;
        IPartBinding fileBinding;
        String caseInsensitiveInternedPartName = InternUtil.intern((String)caseSensitiveInternedPartName);
        IFile declaringFile = this.projectInfo.getPartOrigin(packageName, caseInsensitiveInternedPartName).getEGLFile();
        Node partAST = WorkingCopyASTManager.getInstance().getAST(declaringFile, caseInsensitiveInternedPartName);
        IPartBinding partBinding = new BindingCreator((IEnvironment)this.declaringEnvironment, packageName, caseSensitiveInternedPartName, partAST).getPartBinding();
        Object scope = partBinding.getKind() == 16 ? new EnvironmentScope((IEnvironment)this.declaringEnvironment, (IDependencyRequestor)NullDependencyRequestor.getInstance()) : (!(fileBinding = this.getPartBinding(packageName, fileName = Util.getFilePartName(declaringFile), true)).isValid() ? new SystemScope((Scope)new FileASTScope((Scope)new EnvironmentScope((IEnvironment)this.declaringEnvironment, (IDependencyRequestor)NullDependencyRequestor.getInstance()), (FileBinding)fileBinding, ASTManager.getInstance().getFileAST(declaringFile)), (IEnvironment)this.getSystemEnvironment()) : new SystemScope((Scope)new FileScope((Scope)new EnvironmentScope((IEnvironment)this.declaringEnvironment, (IDependencyRequestor)NullDependencyRequestor.getInstance()), (FileBinding)fileBinding, (IDependencyRequestor)NullDependencyRequestor.getInstance()), (IEnvironment)this.getSystemEnvironment()));
        BindingCompletor.getInstance().completeBinding(partAST, partBinding, (Scope)scope, new ICompilerOptions(){

            public boolean isVAGCompatible() {
                return EGLVAGCompatibilitySetting.isVAGCompatibility();
            }

            public boolean isAliasJSFNames() {
                return EGLAliasJsfNamesSetting.isAliasJsfNames();
            }
        });
        partBinding.setEnvironment((IEnvironment)this.declaringEnvironment);
        this.bindingCache.put(packageName, caseInsensitiveInternedPartName, partBinding);
        WorkingCopyASTManager.getInstance().reportNestedFunctions(partAST, declaringFile);
        return partBinding;
    }

    public int hasPart(String[] packageName, String partName) {
        return this.projectInfo.hasPart(packageName, partName);
    }

    public IProject getProject() {
        return this.projectInfo.getProject();
    }

    @Override
    public IPartOrigin getPartOrigin(String[] packageName, String partName) {
        return this.projectInfo.getPartOrigin(packageName, partName);
    }

    public IEnvironment getRealizingEnvironment() {
        return this.realizingEnvironment;
    }

    public void setProcessingQueue(WorkingCopyProcessingQueue processingQueue) {
        this.processingQueue = processingQueue;
    }

    public void clear() {
        this.bindingCache = new PartBindingCache();
        ObjectStore[] objectStoreArray = this.stores;
        int n = this.stores.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectStore store = objectStoreArray[n2];
            if (store instanceof CachingObjectStore) {
                ((CachingObjectStore)store).clearCache();
            }
            ++n2;
        }
    }

    public boolean isZipFile() {
        return false;
    }

    public boolean isProject() {
        return true;
    }

    public String getID() {
        return this.getProject().getName();
    }

    private EObject readPart(String[] packageName, String name) throws DeserializationException {
        String key = packageName != null && packageName.length > 0 ? String.valueOf(IRUtils.concatWithSeparator((String[])packageName, (String)".")) + "." + name : name;
        int i = 0;
        while (i < this.stores.length) {
            EObject ir = this.stores[i].get(key);
            if (ir != null) {
                return ir;
            }
            ++i;
        }
        return null;
    }

    private IPartBinding readPartBinding(String[] packageName, String partName) {
        try {
            IPartBinding partBinding;
            EObject ir = this.readPart(packageName, partName);
            if (ir != null && (partBinding = this.declaringEnvironment.getConverter().convert(ir)) != null) {
                this.bindingCache.put(packageName, partName, partBinding);
                return partBinding;
            }
            return null;
        }
        catch (Exception e) {
            throw new PartRestoreFailedException(packageName, partName, e);
        }
    }

    public FileBinding getFileBinding(String[] packageName, String fileName, File fileAST) {
        String caseInsensitiveInternedFileName = InternUtil.intern((String)fileName);
        FileBinding fileBinding = this.getFileBindingFromCache(packageName, caseInsensitiveInternedFileName);
        if (fileBinding != null) {
            return fileBinding;
        }
        fileBinding = (FileBinding)new BindingCreator((IEnvironment)this.declaringEnvironment, packageName, caseInsensitiveInternedFileName, (Node)fileAST).getPartBinding();
        fileBinding.setEnvironment((IEnvironment)this.declaringEnvironment);
        EnvironmentScope scope = new EnvironmentScope((IEnvironment)this.declaringEnvironment, (IDependencyRequestor)NullDependencyRequestor.getInstance());
        BindingCompletor.getInstance().completeBinding((Node)fileAST, (IPartBinding)fileBinding, (Scope)scope, new ICompilerOptions(){

            public boolean isVAGCompatible() {
                return EGLVAGCompatibilitySetting.isVAGCompatibility();
            }

            public boolean isAliasJSFNames() {
                return EGLAliasJsfNamesSetting.isAliasJsfNames();
            }
        });
        this.bindingCache.put(packageName, caseInsensitiveInternedFileName, (IPartBinding)fileBinding);
        return fileBinding;
    }

    public FileBinding getFileBindingFromCache(String[] packageName, String partName) {
        return (FileBinding)this.bindingCache.get(packageName, partName);
    }

    private ISystemEnvironment getSystemEnvironment() {
        return SystemEnvironmentManager.findSystemEnvironment(this.getProject(), null);
    }

    private ICompiler getCompiler() {
        return ProjectSettingsUtility.getCompiler(this.getProject());
    }

    public void addPartBindingToCache(IPartBinding partBinding) {
        this.bindingCache.put(InternUtil.intern((String[])partBinding.getPackageName()), InternUtil.intern((String)partBinding.getCaseSensitiveName()), partBinding);
    }

    protected void setObjectStores(ObjectStore[] stores) {
        this.stores = stores == null ? ProjectBuildPathEntry.EMPTY_STORES : stores;
    }

    public ObjectStore[] getObjectStores() {
        return this.stores;
    }

    public Part findPart(String[] packageName, String name) throws PartNotFoundException {
        if (ProjectBuildPathManager.getInstance().getProjectBuildPath(this.projectInfo.getProject()).isReadOnly() || this.projectInfo.hasPart(packageName, name) != 1) {
            try {
                EObject ir = this.readPart(packageName, name);
                if (ir instanceof Part) {
                    return (Part)ir;
                }
            }
            catch (DeserializationException e) {
                throw new PartNotFoundException((Throwable)e);
            }
        }
        return null;
    }

    public void removePartBindingInvalid(String[] packageName, String partName) {
        this.bindingCache.remove(packageName, partName);
    }

    private class RealizingEnvironment
    implements IEnvironment {
        private RealizingEnvironment() {
        }

        public IPartBinding getPartBinding(String[] packageName, String partName) {
            return WorkingCopyProjectBuildPathEntry.this.getPartBinding(packageName, partName, true);
        }

        public IPartBinding getNewPartBinding(String[] packageName, String caseSensitiveInternedPartName, int kind) {
            return WorkingCopyProjectBuildPathEntry.this.getNewPartBinding(packageName, caseSensitiveInternedPartName, kind);
        }

        public boolean hasPackage(String[] packageName) {
            return WorkingCopyProjectBuildPathEntry.this.hasPackage(packageName);
        }

        public IPackageBinding getRootPackage() {
            return WorkingCopyProjectBuildPathEntry.this.declaringEnvironment.getRootPackage();
        }

        public ISystemEnvironment getSystemEnvironment() {
            return WorkingCopyProjectBuildPathEntry.this.getSystemEnvironment();
        }

        public ICompiler getCompiler() {
            return WorkingCopyProjectBuildPathEntry.this.getCompiler();
        }
    }
}

