/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.search.matching;

import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.core.ast.NestedForm;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.ide.core.internal.model.index.IEntryResult;
import org.eclipse.edt.ide.core.internal.search.matching.PartDeclarationPattern;
import org.eclipse.edt.ide.core.model.IIndexConstants;
import org.eclipse.edt.ide.core.model.IPart;

public class QualifiedPartDeclarationPattern
extends PartDeclarationPattern {
    private char[] qualification;
    private char[] decodedQualification;

    public QualifiedPartDeclarationPattern(char[] qualification, char[] simpleName, char partTypes, int matchMode, boolean isCaseSensitive) {
        super(matchMode, isCaseSensitive);
        this.qualification = isCaseSensitive ? qualification : CharOperation.toLowerCase((char[])qualification);
        this.simpleName = isCaseSensitive ? simpleName : CharOperation.toLowerCase((char[])simpleName);
        this.partTypes = partTypes;
        this.needsResolve = qualification != null;
    }

    @Override
    public void decodeIndexEntry(IEntryResult entryResult) {
        char[] word = entryResult.getWord();
        this.isPartDecl = true;
        int size = word.length;
        if (CharOperation.prefixEquals((char[])IIndexConstants.PART_DECL, (char[])word)) {
            this.decodedPartTypes = word[9];
            int oldSlash = 10;
            int slash = CharOperation.indexOf((char)'/', (char[])word, (int)(oldSlash + 1));
            char[] pkgName = slash == oldSlash + 1 ? CharOperation.NO_CHAR : CharOperation.subarray((char[])word, (int)(oldSlash + 1), (int)slash);
            int n = slash + 1;
            slash = CharOperation.indexOf((char)'/', (char[])word, (int)(slash + 1));
            this.decodedSimpleName = CharOperation.subarray((char[])word, (int)n, (int)slash);
            char[][] enclosingTypeNames = slash + 1 < size ? (slash + 3 == size && word[slash + 1] == ONE_ZERO[0] ? ONE_ZERO_CHAR : CharOperation.splitOn((char)'/', (char[])CharOperation.subarray((char[])word, (int)(slash + 1), (int)(size - 1)))) : CharOperation.NO_CHAR_CHAR;
            this.decodedQualification = CharOperation.concatWith((char[])pkgName, (char[][])enclosingTypeNames, (char)'.');
        } else {
            this.isPartDecl = false;
        }
    }

    @Override
    protected boolean matchIndexEntry() {
        if (!this.partTypesMatch()) {
            return false;
        }
        if (!this.isPartDecl) {
            return false;
        }
        if (this.qualification != null) {
            switch (this.matchMode) {
                case 0: {
                    if (CharOperation.equals((char[])this.qualification, (char[])this.decodedQualification, (boolean)this.isCaseSensitive)) break;
                    return false;
                }
                case 1: {
                    if (CharOperation.prefixEquals((char[])this.qualification, (char[])this.decodedQualification, (boolean)this.isCaseSensitive)) break;
                    return false;
                }
                case 2: {
                    if (CharOperation.match((char[])this.qualification, (char[])this.decodedQualification, (boolean)this.isCaseSensitive)) break;
                    return false;
                }
            }
        }
        if (this.simpleName != null) {
            switch (this.matchMode) {
                case 0: {
                    if (CharOperation.equals((char[])this.simpleName, (char[])this.decodedSimpleName, (boolean)this.isCaseSensitive)) break;
                    return false;
                }
                case 1: {
                    if (CharOperation.prefixEquals((char[])this.simpleName, (char[])this.decodedSimpleName, (boolean)this.isCaseSensitive)) break;
                    return false;
                }
                case 2: {
                    if (CharOperation.match((char[])this.simpleName, (char[])this.decodedSimpleName, (boolean)this.isCaseSensitive)) break;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int matchesNestedFormPart(NestedForm node) {
        if (this.partTypes != ' ' && this.partTypes != Short.MAX_VALUE) {
            return 0;
        }
        IPartBinding partBinding = this.getPartBinding(node.getName());
        if (partBinding != null && partBinding != IBinding.NOT_FOUND_BINDING) {
            return this.matchLevelForType(this.simpleName, this.qualification, null, this.getPartBinding(node.getName()));
        }
        return 3;
    }

    @Override
    public int matchLevel(Part part) {
        return this.matchLevelForType(this.simpleName, this.qualification, this.getPartBinding(part));
    }

    @Override
    public int matchLevel(IPart part) {
        return this.matchLevelForType(this.simpleName, this.qualification, part);
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append("PartDeclarationPattern: qualification<");
        if (this.qualification != null) {
            buffer.append(this.qualification);
        }
        buffer.append(">, type<");
        if (this.simpleName != null) {
            buffer.append(this.simpleName);
        }
        buffer.append(">, ");
        switch (this.matchMode) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
            }
        }
        if (this.isCaseSensitive) {
            buffer.append("case sensitive");
        } else {
            buffer.append("case insensitive");
        }
        return buffer.toString();
    }
}

