/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.codegen.api;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.eclipse.edt.mof.codegen.api.TemplateException;

public class TabbedWriter {
    private Writer writer;
    private int indent;
    private boolean doIndent;
    private boolean doAutoIndent;
    private String currentLine;
    private int lineNumber;
    private boolean closed;

    public TabbedWriter(String fileName) {
        try {
            this.writer = new BufferedWriter(new FileWriter(fileName));
        }
        catch (IOException e) {
            throw new TemplateException(e);
        }
        this.doIndent = true;
        this.doAutoIndent = true;
        this.lineNumber = 1;
        this.closed = false;
    }

    public TabbedWriter(Writer writer) {
        this.writer = writer;
        this.doIndent = true;
        this.doAutoIndent = true;
        this.lineNumber = 1;
        this.closed = false;
    }

    public void close() {
        try {
            if (!this.closed) {
                this.closed = true;
                if (this.doAutoIndent && this.currentLine != null) {
                    this.println();
                }
                this.writer.close();
            }
        }
        catch (IOException e) {
            throw new TemplateException(e);
        }
    }

    private int computeIndent() {
        int nextIndent = 0;
        char[] chars = this.currentLine.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '}') {
                if (nextIndent > 0) {
                    --nextIndent;
                } else {
                    --this.indent;
                }
            } else if (chars[i] == '{') {
                ++nextIndent;
            }
            ++i;
        }
        return this.indent + nextIndent;
    }

    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new TemplateException(e);
        }
    }

    public boolean getAutoIndent() {
        return this.doAutoIndent;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public Writer getWriter() {
        return this.writer;
    }

    private void indent() {
        try {
            int i = 0;
            while (i < this.indent) {
                this.writer.write(9);
                ++i;
            }
        }
        catch (IOException e) {
            throw new TemplateException(e);
        }
    }

    public void popIndent() {
        if (this.indent > 0) {
            --this.indent;
        }
    }

    public void print(String str) {
        this.print(str.toCharArray());
    }

    public void print(char[] chars) {
        if (this.doAutoIndent) {
            this.printAutoIndented(chars);
        } else {
            this.printManuallyIndented(chars);
        }
    }

    public void print(char c) {
        if (this.doAutoIndent) {
            this.printAutoIndented(c);
        } else {
            this.printManuallyIndented(c);
        }
    }

    public void print(int i) {
        this.print(Integer.toString(i).toCharArray());
    }

    public void print(boolean b) {
        if (b) {
            this.print("true");
        } else {
            this.print("false");
        }
    }

    public void println() {
        this.print('\n');
    }

    public void println(String str) {
        this.print(str);
        this.print('\n');
    }

    public void println(char[] chars) {
        this.print(chars);
        this.print('\n');
    }

    public void println(char c) {
        this.print(c);
        this.print('\n');
    }

    public void println(int i) {
        this.print(Integer.toString(i).toCharArray());
        this.print('\n');
    }

    public void println(boolean b) {
        this.print(b);
        this.print('\n');
    }

    private void printAutoIndented(char ch) {
        try {
            if (ch == '\n') {
                this.currentLine = this.currentLine == null ? "" : this.currentLine.trim();
                int nextIndent = this.computeIndent();
                this.indent();
                this.writer.write(this.currentLine);
                this.writer.write(10);
                this.currentLine = null;
                this.indent = nextIndent;
                ++this.lineNumber;
            } else {
                this.currentLine = this.currentLine == null ? String.valueOf(ch) : this.currentLine.concat(String.valueOf(ch));
            }
        }
        catch (IOException e) {
            throw new TemplateException(e);
        }
    }

    private void printAutoIndented(char[] ch) {
        int currentStart = 0;
        int end = ch.length;
        try {
            int i = 0;
            while (i < end) {
                if (ch[i] == '\n') {
                    String saveText = new String(ch, currentStart, i - currentStart);
                    this.currentLine = this.currentLine == null ? saveText : this.currentLine.concat(saveText);
                    this.currentLine = this.currentLine.trim();
                    int nextIndent = this.computeIndent();
                    this.indent();
                    this.writer.write(this.currentLine);
                    this.writer.write(10);
                    this.currentLine = null;
                    currentStart = i + 1;
                    this.indent = nextIndent;
                    ++this.lineNumber;
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw new TemplateException(e);
        }
        if (end > currentStart && ch[end - 1] != '\n') {
            String saveText = new String(ch, currentStart, end - currentStart);
            this.currentLine = this.currentLine == null ? saveText : this.currentLine.concat(saveText);
        }
    }

    private void printManuallyIndented(char ch) {
        try {
            if (this.doIndent) {
                this.indent();
            }
            this.writer.write(ch);
            if (ch == '\n') {
                this.doIndent = true;
                ++this.lineNumber;
            } else {
                this.doIndent = false;
            }
        }
        catch (IOException e) {
            throw new TemplateException(e);
        }
    }

    private void printManuallyIndented(char[] ch) {
        int currentStart = 0;
        int end = ch.length;
        try {
            int i = 0;
            while (i < end) {
                if (ch[i] == '\n') {
                    if (this.doIndent) {
                        this.indent();
                    }
                    this.writer.write(ch, currentStart, i + 1 - currentStart);
                    currentStart = i + 1;
                    this.doIndent = true;
                    ++this.lineNumber;
                }
                ++i;
            }
            if (end > currentStart && ch[end - 1] != '\n') {
                if (this.doIndent) {
                    this.indent();
                }
                this.writer.write(ch, currentStart, end - currentStart);
                this.doIndent = false;
            }
        }
        catch (IOException e) {
            throw new TemplateException(e);
        }
    }

    public void pushIndent() {
        ++this.indent;
    }

    public void setAutoIndent(boolean flag) {
        if (this.doAutoIndent && !flag && this.currentLine != null) {
            this.doIndent = true;
            this.printManuallyIndented(this.currentLine.toCharArray());
            this.currentLine = null;
        }
        this.doAutoIndent = flag;
    }

    public String getCurrentLine() {
        return this.currentLine;
    }
}

