/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.serialization;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.eclipse.edt.mof.serialization.AbstractObjectStore;
import org.eclipse.edt.mof.serialization.Deserializer;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.ObjectStore;
import org.eclipse.edt.mof.serialization.SerializationException;

public class FileSystemObjectStore
extends AbstractObjectStore
implements ObjectStore {
    static final String MOFBIN = ".mofbin";
    static final String MOFXML = ".mofxml";
    File root;
    String fileExtension;

    public FileSystemObjectStore(File root, IEnvironment env) {
        super(env);
        this.root = root;
    }

    public FileSystemObjectStore(File root, IEnvironment env, String storageFormat) {
        super(env, storageFormat);
        this.root = root;
        this.fileExtension = storageFormat == "XML" ? MOFXML : MOFBIN;
    }

    public FileSystemObjectStore(File root, IEnvironment env, String storageFormat, String fileExtension) {
        super(env, storageFormat);
        this.root = root;
        this.fileExtension = fileExtension;
    }

    @Override
    public Deserializer createDeserializer(String typeSignature) {
        String path = String.valueOf(typeSignature.replace('.', '/')) + this.getFileExtension();
        Deserializer deserializer = null;
        File typeFile = new File(this.root, path);
        try {
            FileInputStream fileIn = new FileInputStream(typeFile);
            byte[] bytes = new byte[fileIn.available()];
            fileIn.read(bytes);
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            deserializer = this.factory.createDeserializer(in, this.env);
            return deserializer;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void store(String typeSignature, Object obj) {
        File folder;
        if (!(obj instanceof byte[])) {
            throw new IllegalArgumentException("Object not of type: byte[]");
        }
        String ext = this.getFileExtension();
        int i = typeSignature.lastIndexOf(46);
        String packagePath = i != -1 ? typeSignature.substring(0, i).replace('.', '/') : null;
        String path = String.valueOf(typeSignature.replace('.', '/')) + ext;
        if (packagePath != null && !(folder = new File(this.root, packagePath)).exists()) {
            folder.mkdirs();
        }
        try {
            File outFile = new File(this.root, path);
            FileOutputStream file = new FileOutputStream(outFile);
            String data = new String((byte[])obj, "iso-8859-1");
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)file, "iso-8859-1");
            out.write(data);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public void primRemove(String key) {
    }

    @Override
    public boolean containsKey(String key) {
        key = this.removeSchemeFromKey(key);
        String path = String.valueOf(key.replace('.', '/')) + this.getFileExtension();
        File file = new File(this.root, path);
        return file.exists();
    }

    @Override
    public long lastModified(String key) {
        String path = String.valueOf((key = this.removeSchemeFromKey(key)).replace('.', '/')) + this.getFileExtension();
        File file = new File(this.root, path);
        if (file.exists()) {
            return file.lastModified();
        }
        return -1L;
    }

    public String getFileExtension() {
        if (this.fileExtension == null) {
            this.fileExtension = this.storageFormat.equals("BINARY") ? MOFBIN : MOFXML;
        }
        return this.fileExtension;
    }
}

