/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb.many;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.jaxb.many.ManyValue;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlTransient
public abstract class MultiDimensionalArrayValue
extends ManyValue<Object> {
    protected List<ManyValue<Object>> adaptedValue = new ArrayList<ManyValue<Object>>();

    public abstract Class<?> componentClass();

    public abstract Class<? extends ManyValue<Object>> adaptedClass();

    @Override
    @XmlTransient
    public Object getItem() {
        Object nestedArray = this.adaptedValue.get(0).getItem();
        ArrayList<Integer> dimensionsList = new ArrayList<Integer>();
        dimensionsList.add(this.adaptedValue.size());
        this.getDimensions(dimensionsList, nestedArray);
        int[] dimensions = new int[dimensionsList.size()];
        for (int x = 0; x < dimensions.length; ++x) {
            dimensions[x] = (Integer)dimensionsList.get(x);
        }
        Object array = Array.newInstance(this.componentClass(), dimensions);
        Array.set(array, 0, nestedArray);
        int size = this.adaptedValue.size();
        for (int x = 1; x < size; ++x) {
            Array.set(array, x, this.adaptedValue.get(x).getItem());
        }
        return array;
    }

    @Override
    @XmlTransient
    public boolean isArray() {
        return true;
    }

    @Override
    @XmlTransient
    public void setItem(Object array) {
        try {
            int size = Array.getLength(array);
            this.adaptedValue = new ArrayList<ManyValue<Object>>(size);
            for (int x = 0; x < size; ++x) {
                ManyValue nestedItem = (ManyValue)PrivilegedAccessHelper.newInstanceFromClass(this.adaptedClass());
                nestedItem.setItem(Array.get(array, x));
                this.adaptedValue.add(nestedItem);
            }
        }
        catch (Exception e) {
            XMLMarshalException.unmarshalException((Exception)e);
        }
    }

    private List<Integer> getDimensions(List<Integer> dimensions, Object array) {
        dimensions.add(Array.getLength(array));
        Object nestedArray = Array.get(array, 0);
        if (nestedArray.getClass().isArray()) {
            return this.getDimensions(dimensions, nestedArray);
        }
        return dimensions;
    }
}

