/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.jsf.core.internal.tld.CMUtil;
import org.eclipse.jst.pagedesigner.dom.DOMPosition;
import org.eclipse.jst.pagedesigner.dom.DOMPositionHelper;
import org.eclipse.jst.pagedesigner.dom.DOMRefPosition;
import org.eclipse.jst.pagedesigner.dom.DOMRefPosition2;
import org.eclipse.jst.pagedesigner.dom.DOMUtil;
import org.eclipse.jst.pagedesigner.dom.EditValidateUtil;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.parts.NodeEditPart;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.DesignRange;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SelectionHelper {
    public static Node toNode(IStructuredModel model, ITextSelection textSel) {
        IndexedRegion inode = model.getIndexedRegion(textSel.getOffset());
        if (inode instanceof Node) {
            return (Node)inode;
        }
        return null;
    }

    public static Node toNode(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (first instanceof Node) {
            return (Node)first;
        }
        if (first instanceof NodeEditPart) {
            return ((NodeEditPart)((Object)first)).getIDOMNode();
        }
        return null;
    }

    public static Node toNode(DesignRange range) {
        if (range.isValid()) {
            Node node1 = range.getStartPosition().getContainerNode();
            Node node2 = range.getEndPosition().getContainerNode();
            return DOMUtil.findCommonAncester(node1, node2);
        }
        return null;
    }

    public static IDOMPosition toDOMPosition(IDOMModel model, IndexedRegion region, int offset) {
        if (region == null) {
            region = model.getIndexedRegion(offset);
        }
        if (region == null && offset > 0 && (region = model.getIndexedRegion(--offset)) != null && region.getEndOffset() >= offset + 1) {
            ++offset;
        }
        if (region == null) {
            return new DOMPosition((Node)model.getDocument(), 0);
        }
        IDOMNode node = (IDOMNode)region;
        int start = node.getStartOffset();
        if (offset <= start) {
            return new DOMRefPosition((Node)node, false);
        }
        int end = node.getEndOffset();
        if (offset >= end) {
            return new DOMRefPosition((Node)node, true);
        }
        if (node instanceof CharacterData) {
            String source;
            String data = ((CharacterData)node).getData();
            if (data.equals(source = node.getSource())) {
                return new DOMPosition((Node)node, offset - start);
            }
            IStructuredDocumentRegion r = node.getFirstStructuredDocumentRegion();
            int countedData = 0;
            while (r != null) {
                if ("XML_CHAR_REFERENCE".equals(r.getType()) || "XML_ENTITY_REFERENCE".equals(r.getType())) {
                    ++countedData;
                    if (r.getEnd() >= offset) {
                        return new DOMPosition((Node)node, countedData);
                    }
                } else {
                    if (r.getEnd() >= offset) {
                        return new DOMPosition((Node)node, countedData + offset - r.getStart());
                    }
                    countedData += r.getLength();
                }
                r = r.getNext();
            }
            return new DOMRefPosition((Node)node, true);
        }
        if (node instanceof Element) {
            CMElementDeclaration cm = CMUtil.getElementDeclaration((Element)((Element)node));
            if (cm != null && cm.getContentType() == 1) {
                return new DOMRefPosition((Node)node, true);
            }
            IStructuredDocumentRegion startRegion = node.getStartStructuredDocumentRegion();
            if (startRegion == null) {
                return new DOMRefPosition((Node)node, true);
            }
            int startRegionEnd = node.getStartStructuredDocumentRegion().getEnd();
            if (offset <= startRegionEnd) {
                return new DOMRefPosition2((Node)node, false);
            }
            return new DOMRefPosition2((Node)node, true);
        }
        return new DOMRefPosition((Node)node, true);
    }

    public static ISelection convertToDesignerSelection(IHTMLGraphicalViewer graphicViewer, int offset, int length) {
        DesignPosition p2;
        IDOMPosition position2;
        EditPart part;
        IDOMModel model = graphicViewer.getModel();
        IndexedRegion region1 = model.getIndexedRegion(offset);
        IndexedRegion region2 = model.getIndexedRegion(offset + length);
        IDOMNode node1 = (IDOMNode)region1;
        if (node1 == null) {
            DOMRefPosition2 endOfDoc = new DOMRefPosition2((Node)model.getDocument(), true);
            DesignPosition p = DOMPositionHelper.toDesignPosition(endOfDoc);
            return new DesignRange(p, p);
        }
        if (!(region1 != region2 && node1.getEndOffset() != offset + length || node1 instanceof Text || (part = (EditPart)node1.getAdapterFor(EditPart.class)) == null)) {
            return new StructuredSelection((Object)part);
        }
        IDOMPosition position1 = SelectionHelper.toDOMPosition(model, region1, offset);
        IDOMPosition iDOMPosition = position2 = length == 0 ? position1 : SelectionHelper.toDOMPosition(model, region2, offset + length);
        if (position1 == null || position2 == null) {
            return new DesignRange(null, null);
        }
        DesignPosition p1 = DOMPositionHelper.toDesignPosition(position1);
        DesignPosition designPosition = p2 = length == 0 ? p1 : DOMPositionHelper.toDesignPosition(position2);
        if (p1 == null || p2 == null) {
            return new DesignRange(null, null);
        }
        return new DesignRange(p1, p2);
    }

    private static int getIndexedRegionLocation(IDOMPosition p) {
        if (!EditValidateUtil.validPosition(p)) {
            return 0;
        }
        IDOMNode parent = (IDOMNode)p.getContainerNode();
        if (p.isText()) {
            String text = ((CharacterData)parent).getData();
            String source = parent.getSource();
            if (text.length() == source.length()) {
                return parent.getStartOffset() + p.getOffset();
            }
            int offset = p.getOffset();
            int counted = 0;
            IStructuredDocumentRegion r = parent.getFirstStructuredDocumentRegion();
            while (r != null && counted < offset) {
                if ("XML_CHAR_REFERENCE".equals(r.getType()) || "XML_ENTITY_REFERENCE".equals(r.getType())) {
                    if (++counted >= offset) {
                        return r.getEndOffset();
                    }
                } else {
                    int length = r.getLength();
                    if (counted + length >= offset) {
                        return r.getStartOffset() + offset - counted;
                    }
                    counted += length;
                }
                r = r.getNext();
            }
            return parent.getStartOffset() + p.getOffset();
        }
        IDOMNode previous = (IDOMNode)p.getPreviousSiblingNode();
        if (previous != null) {
            return previous.getEndOffset();
        }
        IDOMNode next = (IDOMNode)p.getNextSiblingNode();
        if (next != null) {
            return next.getStartOffset();
        }
        IStructuredDocumentRegion r = parent.getStartStructuredDocumentRegion();
        if (r != null) {
            return r.getEnd();
        }
        return parent.getEndOffset();
    }

    public static IStructuredSelection convertFromDesignSelection(IStructuredSelection sel) {
        List list = sel.toList();
        if (list != null) {
            ArrayList<IDOMNode> result = new ArrayList<IDOMNode>(list.size());
            int i = 0;
            int size = list.size();
            while (i < size) {
                NodeEditPart part = (NodeEditPart)((Object)list.get(i));
                result.add(part.getIDOMNode());
                ++i;
            }
            return new StructuredSelection(result);
        }
        return new StructuredSelection();
    }

    public static ITextSelection convertFromDesignSelection(DesignRange range) {
        if (range.isValid()) {
            IDOMPosition start = DOMPositionHelper.toDOMPosition(range.getStartPosition());
            IDOMPosition end = DOMPositionHelper.toDOMPosition(range.getEndPosition());
            if (EditValidateUtil.validPosition(start) && EditValidateUtil.validPosition(end)) {
                int endoffset;
                int offset = SelectionHelper.getIndexedRegionLocation(start);
                if (offset > (endoffset = SelectionHelper.getIndexedRegionLocation(end))) {
                    int temp = offset;
                    offset = endoffset;
                    endoffset = temp;
                }
                return new TextSelection(offset, endoffset - offset);
            }
        }
        return new TextSelection(0, 0);
    }

    public static ITextSelection convertFromDesignSelectionToTextSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection nodes = SelectionHelper.convertFromDesignSelection((IStructuredSelection)selection);
            IDOMNode node = (IDOMNode)nodes.getFirstElement();
            if (node != null && node.getNodeType() != 9) {
                return new TextSelection(node.getStartOffset(), node.getEndOffset() - node.getStartOffset());
            }
        } else if (selection instanceof DesignRange) {
            return SelectionHelper.convertFromDesignSelection((DesignRange)selection);
        }
        return new TextSelection(0, 0);
    }
}

