/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.style;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.ISemanticHighlighting;
import org.eclipse.wst.sse.ui.ISemanticHighlightingExtension2;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ColorHelper;
import org.eclipse.wst.sse.ui.internal.provisional.style.StructuredPresentationReconciler;
import org.eclipse.wst.sse.ui.internal.reconcile.DocumentRegionProcessor;
import org.eclipse.wst.sse.ui.internal.style.SemanticHighlightingPresenter;
import org.eclipse.wst.sse.ui.internal.style.SemanticHighlightingReconciler;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;

public class SemanticHighlightingManager
implements IPropertyChangeListener {
    private static final String SEMANTIC_HIGHLIGHTING_EXTENSION_POINT = "semanticHighlighting";
    private static final String TARGET_ATTR = "target";
    private static final String CLASS_ATTR = "class";
    private static final String STYLE_KEY_ATTR = "styleStringKey";
    private ISourceViewer fSourceViewer;
    private IPreferenceStore fPreferenceStore;
    private SourceViewerConfiguration fConfiguration;
    private StructuredPresentationReconciler fPresentationReconciler;
    private String fContentTypeId;
    private SemanticHighlightingPresenter fPresenter;
    private SemanticHighlightingReconciler fReconciler;
    private ISemanticHighlighting[] fHighlightings;
    private HighlightingStyle[] fHighlightingStyles;
    private String[] fHighlightingStyleStringKeys;
    private IPropertyChangeListener fHighlightingChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            SemanticHighlightingManager.this.handleHighlightingPropertyChange(event);
        }
    };

    public void propertyChange(PropertyChangeEvent event) {
        this.handlePropertyChange(event);
    }

    public void install(ISourceViewer sourceViewer, IPreferenceStore preferenceStore, SourceViewerConfiguration configuration, String contentTypeId) {
        this.fSourceViewer = sourceViewer;
        this.fPreferenceStore = preferenceStore;
        this.fConfiguration = configuration;
        this.fContentTypeId = contentTypeId;
        this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        this.fPresentationReconciler = (StructuredPresentationReconciler)this.fConfiguration.getPresentationReconciler(this.fSourceViewer);
        if (this.isEnabled()) {
            this.enable();
        }
    }

    private void loadSemanticHighlightings() {
        ArrayList<SemanticContent> semantics = new ArrayList<SemanticContent>(0);
        ISemanticHighlighting highlighting = null;
        String styleKey = null;
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.wst.sse.ui", SEMANTIC_HIGHLIGHTING_EXTENSION_POINT);
        IContentType contentType = Platform.getContentTypeManager().getContentType(this.fContentTypeId);
        int i = 0;
        while (i < elements.length) {
            String[] targets = StringUtils.unpack((String)elements[i].getAttribute(TARGET_ATTR));
            int j = 0;
            while (j < targets.length) {
                IContentType targetContentType = Platform.getContentTypeManager().getContentType(targets[j]);
                if (contentType.isKindOf(targetContentType)) {
                    try {
                        highlighting = (ISemanticHighlighting)elements[i].createExecutableExtension(CLASS_ATTR);
                        styleKey = elements[i].getAttribute(STYLE_KEY_ATTR);
                    }
                    catch (CoreException e) {
                        Logger.logException(e);
                    }
                    if (highlighting == null) break;
                    semantics.add(new SemanticContent(targetContentType, highlighting, styleKey));
                    break;
                }
                ++j;
            }
            ++i;
        }
        Collections.sort(semantics);
        this.fHighlightings = new ISemanticHighlighting[semantics.size()];
        this.fHighlightingStyles = new HighlightingStyle[semantics.size()];
        this.fHighlightingStyleStringKeys = new String[semantics.size()];
        i = 0;
        while (i < semantics.size()) {
            this.fHighlightings[i] = ((SemanticContent)semantics.get(i)).getHighlighting();
            styleKey = ((SemanticContent)semantics.get(i)).getStyleKey();
            this.fHighlightingStyles[i] = this.createHighlightingStyle(((SemanticContent)semantics.get(i)).getHighlighting(), styleKey);
            this.fHighlightingStyleStringKeys[i] = styleKey;
            ++i;
        }
    }

    private HighlightingStyle createHighlightingStyle(ISemanticHighlighting highlighting, String styleKey) {
        IPreferenceStore store = highlighting.getPreferenceStore();
        HighlightingStyle highlightingStyle = null;
        if (store != null) {
            TextAttribute attribute = null;
            if (styleKey != null) {
                attribute = this.createTextAttribute(store.getString(styleKey));
            } else {
                int style;
                int n = style = this.getBoolean(store, highlighting.getBoldPreferenceKey()) ? 1 : 0;
                if (this.getBoolean(store, highlighting.getItalicPreferenceKey())) {
                    style |= 2;
                }
                if (this.getBoolean(store, highlighting.getStrikethroughPreferenceKey())) {
                    style |= 0x20000000;
                }
                if (this.getBoolean(store, highlighting.getUnderlinePreferenceKey())) {
                    style |= 0x40000000;
                }
                String rgbString = this.getString(store, highlighting.getColorPreferenceKey());
                Color color = null;
                Color bgColor = null;
                if (rgbString != null) {
                    color = EditorUtility.getColor(ColorHelper.toRGB(rgbString));
                }
                if (highlighting instanceof ISemanticHighlightingExtension2 && (rgbString = this.getString(store, ((ISemanticHighlightingExtension2)((Object)highlighting)).getBackgroundColorPreferenceKey())) != null) {
                    bgColor = EditorUtility.getColor(ColorHelper.toRGB(rgbString));
                }
                attribute = new TextAttribute(color, bgColor, style);
            }
            store.addPropertyChangeListener(this.fHighlightingChangeListener);
            boolean isEnabled = this.getBoolean(store, highlighting.getEnabledPreferenceKey());
            highlightingStyle = new HighlightingStyle(attribute, isEnabled);
        }
        return highlightingStyle;
    }

    private TextAttribute createTextAttribute(String styleValue) {
        String[] values = ColorHelper.unpackStylePreferences(styleValue);
        if (values.length < 6) {
            return null;
        }
        RGB foreground = ColorHelper.toRGB(values[0]);
        RGB background = ColorHelper.toRGB(values[1]);
        boolean bold = Boolean.valueOf(values[2]);
        boolean italic = Boolean.valueOf(values[3]);
        boolean strikethrough = Boolean.valueOf(values[4]);
        boolean underline = Boolean.valueOf(values[5]);
        int style = 0;
        if (bold) {
            style |= 1;
        }
        if (italic) {
            style |= 2;
        }
        if (strikethrough) {
            style |= 0x20000000;
        }
        if (underline) {
            style |= 0x40000000;
        }
        return this.createTextAttribute(foreground, background, style);
    }

    private TextAttribute createTextAttribute(RGB foreground, RGB background, int style) {
        return new TextAttribute(foreground != null ? EditorUtility.getColor(foreground) : null, background != null ? EditorUtility.getColor(background) : null, style);
    }

    private boolean getBoolean(IPreferenceStore store, String key) {
        return key == null ? false : store.getBoolean(key);
    }

    private String getString(IPreferenceStore store, String key) {
        return key == null ? null : store.getString(key);
    }

    private void enable() {
        this.loadSemanticHighlightings();
        this.fPresenter = new SemanticHighlightingPresenter();
        this.fPresenter.install(this.fSourceViewer, this.fPresentationReconciler);
        this.fReconciler = new SemanticHighlightingReconciler();
        this.fReconciler.install((ITextViewer)this.fSourceViewer, this.fPresenter, this.fHighlightings, this.fHighlightingStyles);
        IReconciler reconciler = this.fConfiguration.getReconciler(this.fSourceViewer);
        if (reconciler instanceof DocumentRegionProcessor) {
            ((DocumentRegionProcessor)reconciler).setSemanticHighlightingStrategy(this.fReconciler);
        }
    }

    private void disable() {
        if (this.fReconciler != null) {
            this.fReconciler.uninstall();
            this.fReconciler = null;
        }
        if (this.fPresenter != null) {
            this.fPresenter.uninstall();
            this.fPresenter = null;
        }
        if (this.fHighlightings != null) {
            this.disposeHighlightings();
        }
    }

    private void disposeHighlightings() {
        if (this.fHighlightings != null) {
            int i = 0;
            while (i < this.fHighlightings.length) {
                IPreferenceStore store = this.fHighlightings[i].getPreferenceStore();
                if (store != null) {
                    store.removePropertyChangeListener(this.fHighlightingChangeListener);
                }
                ++i;
            }
        }
        this.fHighlightings = null;
        this.fHighlightingStyles = null;
        this.fHighlightingStyleStringKeys = null;
    }

    private void handleHighlightingPropertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property == null) {
            return;
        }
        boolean refreshRequired = false;
        int i = 0;
        while (i < this.fHighlightings.length) {
            ISemanticHighlighting highlighting = this.fHighlightings[i];
            if (this.fHighlightingStyleStringKeys[i] != null && property.equals(this.fHighlightingStyleStringKeys[i])) {
                this.adaptToStyleChange(this.fHighlightingStyles[i], event);
                this.fPresenter.highlightingStyleChanged(this.fHighlightingStyles[i]);
                refreshRequired = true;
            } else if (property.equals(highlighting.getBoldPreferenceKey())) {
                this.adaptToTextStyleChange(this.fHighlightingStyles[i], event, 1);
                this.fPresenter.highlightingStyleChanged(this.fHighlightingStyles[i]);
                refreshRequired = true;
            } else if (property.equals(highlighting.getColorPreferenceKey())) {
                this.adaptToTextForegroundChange(this.fHighlightingStyles[i], event);
                this.fPresenter.highlightingStyleChanged(this.fHighlightingStyles[i]);
                refreshRequired = true;
            } else if (property.equals(highlighting.getEnabledPreferenceKey())) {
                this.adaptToEnablementChange(this.fHighlightingStyles[i], event);
                this.fPresenter.highlightingStyleChanged(this.fHighlightingStyles[i]);
                refreshRequired = true;
            } else if (property.equals(highlighting.getItalicPreferenceKey())) {
                this.adaptToTextStyleChange(this.fHighlightingStyles[i], event, 2);
                this.fPresenter.highlightingStyleChanged(this.fHighlightingStyles[i]);
                refreshRequired = true;
            } else if (property.equals(highlighting.getStrikethroughPreferenceKey())) {
                this.adaptToTextStyleChange(this.fHighlightingStyles[i], event, 0x20000000);
                this.fPresenter.highlightingStyleChanged(this.fHighlightingStyles[i]);
                refreshRequired = true;
            } else if (property.equals(highlighting.getUnderlinePreferenceKey())) {
                this.adaptToTextStyleChange(this.fHighlightingStyles[i], event, 0x40000000);
                this.fPresenter.highlightingStyleChanged(this.fHighlightingStyles[i]);
                refreshRequired = true;
            } else if (highlighting instanceof ISemanticHighlightingExtension2 && property.equals(((ISemanticHighlightingExtension2)((Object)highlighting)).getBackgroundColorPreferenceKey())) {
                this.adaptToTextBackgroundChange(this.fHighlightingStyles[i], event);
                this.fPresenter.highlightingStyleChanged(this.fHighlightingStyles[i]);
                refreshRequired = true;
            }
            ++i;
        }
        if (refreshRequired && this.fReconciler != null) {
            this.fReconciler.refresh();
        }
    }

    private void handlePropertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property == null || !property.equals(SEMANTIC_HIGHLIGHTING_EXTENSION_POINT)) {
            return;
        }
        Object newValue = event.getNewValue();
        if (newValue instanceof Boolean) {
            if (((Boolean)newValue).booleanValue()) {
                this.enable();
            } else {
                this.disable();
            }
        }
        if (this.fReconciler != null) {
            this.fReconciler.refresh();
        }
    }

    private void adaptToEnablementChange(HighlightingStyle highlighting, PropertyChangeEvent event) {
        Object value = event.getNewValue();
        boolean eventValue = value instanceof Boolean ? (Boolean)value : "true".equals(value);
        highlighting.setEnabled(eventValue);
    }

    private void adaptToTextForegroundChange(HighlightingStyle highlighting, PropertyChangeEvent event) {
        RGB rgb = null;
        Object value = event.getNewValue();
        if (value instanceof RGB) {
            rgb = (RGB)value;
        } else if (value instanceof String) {
            rgb = ColorHelper.toRGB((String)value);
        }
        if (rgb != null) {
            Color color = EditorUtility.getColor(rgb);
            TextAttribute oldAttr = highlighting.getTextAttribute();
            highlighting.setTextAttribute(new TextAttribute(color, oldAttr.getBackground(), oldAttr.getStyle()));
        }
    }

    private void adaptToTextBackgroundChange(HighlightingStyle highlighting, PropertyChangeEvent event) {
        RGB rgb = null;
        Object value = event.getNewValue();
        if (value instanceof RGB) {
            rgb = (RGB)value;
        } else if (value instanceof String) {
            rgb = ColorHelper.toRGB((String)value);
        }
        if (rgb != null) {
            Color color = EditorUtility.getColor(rgb);
            TextAttribute oldAttr = highlighting.getTextAttribute();
            highlighting.setTextAttribute(new TextAttribute(oldAttr.getForeground(), color, oldAttr.getStyle()));
        }
    }

    private void adaptToTextStyleChange(HighlightingStyle highlighting, PropertyChangeEvent event, int styleAttribute) {
        boolean activeValue;
        boolean eventValue = false;
        Object value = event.getNewValue();
        if (value instanceof Boolean) {
            eventValue = (Boolean)value;
        } else if ("true".equals(value)) {
            eventValue = true;
        }
        TextAttribute oldAttr = highlighting.getTextAttribute();
        boolean bl = activeValue = (oldAttr.getStyle() & styleAttribute) == styleAttribute;
        if (activeValue != eventValue) {
            highlighting.setTextAttribute(new TextAttribute(oldAttr.getForeground(), oldAttr.getBackground(), eventValue ? oldAttr.getStyle() | styleAttribute : oldAttr.getStyle() & ~styleAttribute));
        }
    }

    private void adaptToStyleChange(HighlightingStyle highlighting, PropertyChangeEvent event) {
        TextAttribute attr;
        Object value = event.getNewValue();
        if (value instanceof String && (attr = this.createTextAttribute((String)value)) != null) {
            highlighting.setTextAttribute(attr);
        }
    }

    private boolean isEnabled() {
        return this.fPreferenceStore != null ? this.fPreferenceStore.getBoolean(SEMANTIC_HIGHLIGHTING_EXTENSION_POINT) : false;
    }

    public void uninstall() {
        this.disable();
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fPreferenceStore = null;
        }
        this.fSourceViewer = null;
        this.fConfiguration = null;
        this.fPresentationReconciler = null;
    }

    static class HighlightedPosition
    extends Position {
        private HighlightingStyle fStyle;
        private boolean fReadOnly;
        private Object fLock;

        public HighlightedPosition(int offset, int length, HighlightingStyle highlighting, Object lock, boolean isReadOnly) {
            super(offset, length);
            this.fStyle = highlighting;
            this.fLock = lock;
            this.fReadOnly = isReadOnly;
        }

        public HighlightedPosition(int offset, int length, HighlightingStyle highlighting, Object lock) {
            this(offset, length, highlighting, lock, false);
        }

        public HighlightedPosition(Position position, HighlightingStyle highlighting, Object lock) {
            this(position.offset, position.length, highlighting, lock, false);
        }

        public HighlightedPosition(Position position, HighlightingStyle highlighting, Object lock, boolean isReadOnly) {
            this(position.offset, position.length, highlighting, lock, isReadOnly);
        }

        public StyleRange createStyleRange() {
            int len = 0;
            if (this.fStyle.isEnabled()) {
                len = this.getLength();
            }
            TextAttribute textAttribute = this.fStyle.getTextAttribute();
            int style = textAttribute.getStyle();
            int fontStyle = style & 3;
            StyleRange styleRange = new StyleRange(this.getOffset(), len, textAttribute.getForeground(), textAttribute.getBackground(), fontStyle);
            styleRange.strikeout = (style & 0x20000000) != 0;
            styleRange.underline = (style & 0x40000000) != 0;
            return styleRange;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEqual(int off, int len, HighlightingStyle highlighting) {
            Object object = this.fLock;
            synchronized (object) {
                return !this.isDeleted() && this.getOffset() == off && this.getLength() == len && this.fStyle == highlighting;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEqual(Position pos, HighlightingStyle highlighting) {
            Object object = this.fLock;
            synchronized (object) {
                return !this.isDeleted() && this.getOffset() == pos.getOffset() && this.getLength() == pos.getLength() && this.fStyle == highlighting;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isContained(int off, int len) {
            Object object = this.fLock;
            synchronized (object) {
                return !this.isDeleted() && off <= this.getOffset() && off + len >= this.getOffset() + this.getLength();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(int off, int len) {
            Object object = this.fLock;
            synchronized (object) {
                super.setOffset(off);
                super.setLength(len);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLength(int length) {
            Object object = this.fLock;
            synchronized (object) {
                super.setLength(length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setOffset(int offset) {
            Object object = this.fLock;
            synchronized (object) {
                super.setOffset(offset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete() {
            Object object = this.fLock;
            synchronized (object) {
                super.delete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void undelete() {
            Object object = this.fLock;
            synchronized (object) {
                super.undelete();
            }
        }

        public HighlightingStyle getHighlighting() {
            return this.fStyle;
        }

        public boolean isReadOnly() {
            return this.fReadOnly;
        }
    }

    public static class HighlightedRange
    extends Region {
        private String fKey;

        public HighlightedRange(int offset, int length, String key) {
            super(offset, length);
            this.fKey = key;
        }

        public String getKey() {
            return this.fKey;
        }

        public boolean equals(Object o) {
            return super.equals(o) && o instanceof HighlightedRange && this.fKey.equals(((HighlightedRange)((Object)o)).getKey());
        }

        public int hashCode() {
            return super.hashCode() | this.fKey.hashCode();
        }
    }

    static class HighlightingStyle {
        private TextAttribute fTextAttribute;
        private boolean fIsEnabled;

        public HighlightingStyle(TextAttribute textAttribute, boolean isEnabled) {
            this.setTextAttribute(textAttribute);
            this.setEnabled(isEnabled);
        }

        public TextAttribute getTextAttribute() {
            return this.fTextAttribute;
        }

        public void setTextAttribute(TextAttribute textAttribute) {
            this.fTextAttribute = textAttribute;
        }

        public boolean isEnabled() {
            return this.fIsEnabled;
        }

        public void setEnabled(boolean isEnabled) {
            this.fIsEnabled = isEnabled;
        }
    }

    private class SemanticContent
    implements Comparable {
        public IContentType type;
        public ISemanticHighlighting highlighting;
        public String styleKey;

        public SemanticContent(IContentType type, ISemanticHighlighting highlighting, String styleKey) {
            this.type = type;
            this.highlighting = highlighting;
            this.styleKey = styleKey;
        }

        public int compareTo(Object arg0) {
            SemanticContent other = (SemanticContent)arg0;
            if (this.type.equals(other.type)) {
                return 0;
            }
            if (this.type.isKindOf(other.type)) {
                return 1;
            }
            return -1;
        }

        public ISemanticHighlighting getHighlighting() {
            return this.highlighting;
        }

        public String getStyleKey() {
            return this.styleKey;
        }
    }
}

