/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;
import org.eclipse.edt.compiler.internal.io.IRFileNameUtility;
import org.eclipse.edt.debug.core.DebugUtil;
import org.eclipse.edt.ide.core.internal.model.ClassFileElementInfo;
import org.eclipse.edt.ide.core.internal.model.EGLModelManager;
import org.eclipse.edt.ide.core.model.IClassFile;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.util.EditorUtility;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class EGLPackageFragmentRootSourceContainer
extends AbstractSourceContainer
implements IWorkbenchAdapter {
    public static final String TYPE_ID = "org.eclipse.edt.debug.core.sourceContainer.packageFragmentRoot";
    private final IPackageFragmentRoot root;

    public EGLPackageFragmentRootSourceContainer(IPackageFragmentRoot root) {
        this.root = root;
    }

    public Object[] findSourceElements(String name) throws CoreException {
        IPackageFragment fragment;
        if (!DebugUtil.isEGLFileName(name)) {
            return EMPTY;
        }
        String type = IRFileNameUtility.toIRFileName((String)name);
        int lastDot = type.lastIndexOf(46);
        if (lastDot != -1) {
            type = type.substring(0, lastDot);
        }
        type = type.replace('/', '.');
        String pkg = "";
        lastDot = type.lastIndexOf(46);
        if (lastDot != -1) {
            pkg = type.substring(0, lastDot);
            type = type.substring(lastDot + 1);
        }
        if (!(fragment = this.root.getPackageFragment(pkg)).exists()) {
            fragment = null;
            IEGLElement[] kids = this.root.getChildren();
            int i = 0;
            while (i < kids.length) {
                if (kids[i] instanceof IPackageFragment && kids[i].getElementName().equalsIgnoreCase(pkg)) {
                    fragment = (IPackageFragment)kids[i];
                    break;
                }
                ++i;
            }
        }
        if (fragment != null) {
            switch (fragment.getKind()) {
                case 2: {
                    IClassFile file = fragment.getClassFile(String.valueOf(type) + ".ir");
                    if (!file.exists()) break;
                    IProject proj = file.getEGLProject().getProject();
                    String eglarPath = file.getPath().toString();
                    IPart part = file.getPart();
                    if (part != null) {
                        String fullyqualifiedPartName = part.getFullyQualifiedName();
                        return new Object[]{EditorUtility.getBinaryReadonlyFile((IProject)proj, (String)eglarPath, (String)fullyqualifiedPartName)};
                    }
                    String eglName = String.valueOf(type) + ".egl";
                    IClassFile[] classes = fragment.getClassFiles();
                    int i = 0;
                    while (i < classes.length) {
                        Object info;
                        if (classes[i] != file && (part = classes[i].getPart()) != null && (info = EGLModelManager.getEGLModelManager().getInfo((IEGLElement)classes[i])) instanceof ClassFileElementInfo && eglName.equalsIgnoreCase(((ClassFileElementInfo)info).getEglFileName())) {
                            String fullyqualifiedPartName = part.getFullyQualifiedName();
                            return new Object[]{EditorUtility.getBinaryReadonlyFile((IProject)proj, (String)eglarPath, (String)fullyqualifiedPartName)};
                        }
                        ++i;
                    }
                    break;
                }
                case 1: {
                    String eglName = String.valueOf(type) + ".egl";
                    IEGLFile file = fragment.getEGLFile(eglName);
                    if (file.exists()) {
                        return new Object[]{file.getResource()};
                    }
                    IEGLElement[] kids = fragment.getChildren();
                    int i = 0;
                    while (i < kids.length) {
                        if (kids[i] instanceof IEGLFile && kids[i].getElementName().equalsIgnoreCase(eglName)) {
                            return new Object[]{kids[i].getResource()};
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
        return EMPTY;
    }

    public String getName() {
        return this.root.getElementName();
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }

    public boolean equals(Object obj) {
        return obj instanceof EGLPackageFragmentRootSourceContainer && ((EGLPackageFragmentRootSourceContainer)((Object)obj)).root.equals(this.root);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public Object[] getChildren(Object o) {
        return EMPTY;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return this.root.isArchive() ? PluginImages.DESC_OBJS_PACKFRAG_ROOT_EGLAR : PluginImages.DESC_OBJS_PACKFRAG_ROOT;
    }

    public String getLabel(Object o) {
        return this.root.getElementName();
    }

    public Object getParent(Object o) {
        return null;
    }
}

