/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.core.java.variables;

import java.util.ArrayList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.edt.debug.core.java.IEGLJavaStackFrame;
import org.eclipse.edt.debug.core.java.IEGLJavaThread;
import org.eclipse.edt.debug.core.java.IEGLJavaValue;
import org.eclipse.edt.debug.core.java.IEGLJavaVariable;
import org.eclipse.edt.debug.core.java.SMAPVariableInfo;
import org.eclipse.edt.debug.internal.core.java.EGLJavaValue;
import org.eclipse.edt.debug.internal.core.java.EGLJavaVariable;
import org.eclipse.edt.debug.internal.core.java.VariableUtil;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.logicalstructures.JDIPlaceholderVariable;

public class MapVariable
extends EGLJavaVariable {
    public MapVariable(IDebugTarget target, IJavaVariable javaVariable, SMAPVariableInfo variableInfo, IEGLJavaStackFrame frame, IEGLJavaValue parent) {
        super(target, javaVariable, variableInfo, frame, parent);
    }

    @Override
    protected IEGLJavaValue createEGLValue(IJavaValue javaValue) {
        return new MapValue(this.getDebugTarget(), javaValue, this);
    }

    protected String getTypeNameForElement(IJavaValue value) throws DebugException {
        return value.getReferenceTypeName();
    }

    @Override
    protected boolean shouldCheckJavaElementAdapter() {
        return false;
    }

    private class MapValue
    extends EGLJavaValue {
        public MapValue(IDebugTarget target, IJavaValue value, EGLJavaVariable parent) {
            super(target, value, parent);
        }

        @Override
        public synchronized IVariable[] getVariables() throws DebugException {
            IJavaValue toArrayValue;
            IEGLJavaThread eglThread;
            IJavaValue entrySetValue;
            if (this.children != null) {
                return this.children;
            }
            if (this.javaValue instanceof IJavaObject && (entrySetValue = VariableUtil.runSendMessage(eglThread = MapVariable.this.getEGLStackFrame().getEGLThread(), (IJavaObject)this.javaValue, null, "entrySet", "()Ljava/util/Set;", false)) instanceof IJavaObject && (toArrayValue = VariableUtil.runSendMessage(eglThread, (IJavaObject)entrySetValue, null, "toArray", "()[Ljava/lang/Object;", false)) != null) {
                IVariable[] vars = toArrayValue.getVariables();
                ArrayList<IEGLJavaVariable> list = new ArrayList<IEGLJavaVariable>(vars.length);
                SMAPVariableInfo parentInfo = this.parentVariable.getVariableInfo();
                IVariable[] iVariableArray = vars;
                int n = vars.length;
                int n2 = 0;
                while (n2 < n) {
                    IVariable var = iVariableArray[n2];
                    IValue value = var.getValue();
                    if (value instanceof IJavaObject) {
                        IJavaValue nextkey = VariableUtil.runSendMessage(eglThread, (IJavaObject)value, null, "getKey", "()Ljava/lang/Object;", false);
                        IJavaValue nextvalue = VariableUtil.runSendMessage(eglThread, (IJavaObject)value, null, "getValue", "()Ljava/lang/Object;", false);
                        if (nextkey != null && nextvalue instanceof IJavaValue) {
                            SMAPVariableInfo info = new SMAPVariableInfo(nextkey.getValueString(), nextkey.getValueString(), MapVariable.this.getTypeNameForElement(nextvalue), parentInfo.lineDeclared, parentInfo.smapEntry);
                            list.add(VariableUtil.createEGLVariable((IJavaVariable)new JDIPlaceholderVariable(nextkey.getValueString(), nextvalue), info, this.parentVariable.getEGLStackFrame(), this));
                        }
                    }
                    ++n2;
                }
                this.children = list.toArray(new IEGLJavaVariable[list.size()]);
            }
            if (this.children == null) {
                this.children = super.getVariables();
            }
            return this.children;
        }

        @Override
        public String getValueString() {
            return this.javaValue.isNull() ? "null" : "";
        }

        @Override
        public String computeDetail() {
            return this.getValueString();
        }
    }
}

