/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.ui.launching;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.edt.debug.core.DebugUtil;
import org.eclipse.edt.debug.ui.launching.EGLLaunchableTester;
import org.eclipse.edt.debug.ui.launching.EGLLaunchingMessages;
import org.eclipse.edt.ide.rui.internal.testserver.ClasspathUtil;
import org.eclipse.edt.ide.rui.internal.testserver.DeploymentDescriptorFinder;
import org.eclipse.edt.ide.rui.server.EvServer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaLaunchDelegate;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.dialogs.ListDialog;

public class EGLJavaLaunchDelegate
extends JavaLaunchDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        List<IFile> files;
        IFile file;
        String programFileName;
        IProject project;
        String projectName = configuration.getAttribute("org.eclipse.edt.debug.ui.attr_project_name", null);
        if (projectName == null || projectName.trim().length() < 1) {
            this.abort(EGLLaunchingMessages.egl_java_main_launch_configuration_no_project_specified);
        }
        if ((project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) == null || !project.exists()) {
            this.abort(EGLLaunchingMessages.egl_java_main_launch_configuration_invalid_project);
        }
        if ((programFileName = configuration.getAttribute("org.eclipse.edt.debug.ui.attr_program_file", "").trim()).length() < 1) {
            this.abort(EGLLaunchingMessages.egl_java_main_launch_configuration_no_program_file_specified);
        }
        if ((file = project.getFile(programFileName)) == null || !file.exists()) {
            this.abort(EGLLaunchingMessages.egl_java_main_launch_configuration_invalid_program_file);
        }
        if ((files = EGLLaunchableTester.getMainJavaOutputFiles(file)) == null || files.size() == 0) {
            this.abort(NLS.bind((String)EGLLaunchingMessages.java_launch_no_files, (Object)file.getName()));
        }
        IFile javaFile = null;
        if (files.size() > 1) {
            Object[] result;
            ListDialog dialog = new ListDialog(DebugUtil.getShell());
            dialog.setTitle(EGLLaunchingMessages.java_launch_file_selection_title);
            dialog.setMessage(EGLLaunchingMessages.java_launch_file_selection_msg);
            dialog.setContentProvider(new IStructuredContentProvider(){

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public Object[] getElements(Object inputElement) {
                    return files.toArray();
                }
            });
            dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof IFile) {
                        return ((IFile)element).getFullPath().toString();
                    }
                    return super.getText(element);
                }
            });
            dialog.setInput(files);
            if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length > 0 && result[0] instanceof IFile) {
                javaFile = (IFile)result[0];
            }
        } else {
            javaFile = files.get(0);
        }
        if (javaFile != null && javaFile.exists()) {
            IType type;
            ILaunchConfigurationWorkingCopy copy = configuration.getWorkingCopy();
            String className = null;
            IJavaElement javaElement = JavaCore.create((IFile)javaFile);
            if (javaElement instanceof ITypeRoot && (type = ((ITypeRoot)javaElement).findPrimaryType()) != null) {
                className = type.getFullyQualifiedName();
            }
            if (className != null) {
                String vmArgs = copy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
                vmArgs = String.valueOf(vmArgs) + "-Degl.main.class.name=\"" + className + "\" -Degl.ide.port=\"" + EvServer.getInstance().getPortNumber() + "\" -Degl.dd.list=\"" + DeploymentDescriptorFinder.toArgumentString(DeploymentDescriptorFinder.findDeploymentDescriptors((IProject)project).values()) + "\" -Degl.default.dd=\"" + DeploymentDescriptorFinder.getDefaultDDName((IProject)project) + "\"";
                copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArgs);
                copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, javaFile.getProject().getName());
                List classpath = copy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, new ArrayList());
                classpath.add(ClasspathUtil.getWorkspaceProjectClasspathEntry((String)javaFile.getProject().getName()));
                ClasspathUtil.addEGLPathToJavaPathIfNecessary((IJavaProject)JavaCore.create((IProject)javaFile.getProject()), (IProject)project, new HashSet(), (List)classpath);
                ClasspathUtil.addJDBCJars((IProject)project, new HashSet(), new HashSet(), (List)classpath);
                String icu = ClasspathUtil.getClasspathEntry((String)"com.ibm.icu");
                if (icu != null) {
                    classpath.add(icu);
                }
                copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, classpath);
                copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
                super.launch((ILaunchConfiguration)copy, mode, launch, monitor);
            } else {
                this.abort(NLS.bind((String)EGLLaunchingMessages.egl_java_main_launch_configuration_missing_java_type, (Object)javaFile.getFullPath().toString()));
            }
        }
    }

    protected void abort(String message) throws CoreException {
        Status status = new Status(4, "org.eclipse.edt.debug.ui", 4, message, null);
        throw new CoreException((IStatus)status);
    }
}

