/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.java.templates;

import org.eclipse.edt.gen.java.CommonUtilities;
import org.eclipse.edt.gen.java.Context;
import org.eclipse.edt.gen.java.templates.JavaTemplate;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.EType;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.Template;
import org.eclipse.edt.mof.codegen.api.TemplateContext;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.Assignment;
import org.eclipse.edt.mof.egl.AssignmentStatement;
import org.eclipse.edt.mof.egl.Container;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.ExternalType;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.LHSExpr;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.MemberName;
import org.eclipse.edt.mof.egl.ParameterKind;
import org.eclipse.edt.mof.egl.ReturnStatement;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.egl.StatementBlock;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class FieldTemplate
extends JavaTemplate {
    public void preGen(Field field, Context ctx) {
        ctx.invoke("preGen", field.getType(), new Object[]{ctx});
        if (field.getContainer() instanceof Type && field.getAnnotation("eglx.json.JsonName") == null) {
            try {
                Annotation annotation = CommonUtilities.getAnnotation((Context)ctx, (String)"egl:eglx.json.JsonName");
                annotation.setValue((Object)field.getId());
                field.addAnnotation(annotation);
            }
            catch (Exception exception) {}
        }
    }

    public void genDeclaration(Field field, Context ctx, TabbedWriter out) {
        CommonUtilities.generateSmapExtension((Member)field, (Context)ctx);
        if (field.getContainer() != null) {
            ctx.invoke("genXmlTransient", (EObject)field.getContainer(), new Object[]{out});
            ctx.invoke("genAnnotations", (EObject)field.getContainer(), new Object[]{ctx, out, field});
        }
        ctx.invokeSuper((Template)this, "genDeclaration", (EObject)field, new Object[]{ctx, out});
        this.transientOption(field, out);
        ctx.invoke("genRuntimeTypeName", (EObject)field, new Object[]{ctx, out, JavaTemplate.TypeNameKind.JavaPrimitive});
        out.print(" ");
        ctx.invoke("genName", (EObject)field, new Object[]{ctx, out});
        out.println(";");
    }

    public void genAnnotations(Field field, Context ctx, TabbedWriter out) {
        for (Annotation annot : field.getAnnotations()) {
            ctx.invoke("genAnnotation", (EType)annot.getEClass(), new Object[]{ctx, out, annot, field});
        }
    }

    public void genInstantiation(Field field, Context ctx, TabbedWriter out) {
        ctx.invoke("genInstantiation", field.getType(), new Object[]{ctx, out, field});
    }

    public void genInitialization(Field field, Context ctx, TabbedWriter out) {
        if (CommonUtilities.isBoxedOutputTemp((Member)field, (Context)ctx)) {
            if (ctx.getAttribute((Object)field, "functionArgumentTemporaryVariable") == ParameterKind.PARM_OUT) {
                out.print("org.eclipse.edt.runtime.java.eglx.lang.EAny.ezeWrap(");
                if (field.getType().getTypeSignature().equalsIgnoreCase("eglx.lang.EAny")) {
                    out.print("(eglx.lang.EAny) ");
                }
                if (field.getType().getTypeSignature().equalsIgnoreCase("eglx.lang.ENumber")) {
                    out.print("(eglx.lang.ENumber) ");
                }
                if (ctx.mapsToNativeType(field.getType()) || ctx.mapsToPrimitiveType(field.getType())) {
                    ctx.invoke("genDefaultValue", field.getType(), new Object[]{ctx, out, field});
                } else {
                    ctx.invoke("genInstantiation", field.getType(), new Object[]{ctx, out, field});
                }
                out.print(")");
            } else {
                out.print("null");
            }
        } else if (field.isNullable()) {
            ctx.invoke("genDefaultValue", field.getType(), new Object[]{ctx, out, field});
        } else if (TypeUtils.isReferenceType((Type)field.getType())) {
            ctx.invoke("genDefaultValue", field.getType(), new Object[]{ctx, out, field});
        } else if (ctx.mapsToNativeType(field.getType()) || ctx.mapsToPrimitiveType(field.getType())) {
            ctx.invoke("genDefaultValue", field.getType(), new Object[]{ctx, out, field});
        } else {
            ctx.invoke("genInstantiation", field.getType(), new Object[]{ctx, out, field});
        }
    }

    public void genInitializeStatement(Field field, Context ctx, TabbedWriter out) {
        this.processInitializeStatement(field, ctx, out, false);
    }

    public void genInitializeStatement(Field field, Context ctx, TabbedWriter out, Boolean adjustSmap) {
        this.processInitializeStatement(field, ctx, out, adjustSmap);
    }

    public void processInitializeStatement(Field field, Context ctx, TabbedWriter out, boolean adjustSmap) {
        if (field.getInitializerStatements() == null || field.getInitializerStatements().getStatements().isEmpty()) {
            ctx.invoke("genName", (EObject)field, new Object[]{ctx, out});
            out.print(" = ");
            ctx.invoke("genInitialization", (EObject)field, new Object[]{ctx, out});
            out.println(";");
        } else {
            if (!(field.getInitializerStatements().getStatements().size() > 0 && field.getInitializerStatements().getStatements().get(0) instanceof AssignmentStatement && ((AssignmentStatement)field.getInitializerStatements().getStatements().get(0)).getAssignment().getLHS() instanceof MemberName && ((MemberName)((AssignmentStatement)field.getInitializerStatements().getStatements().get(0)).getAssignment().getLHS()).getMember().equals(field))) {
                ctx.invoke("genName", (EObject)field, new Object[]{ctx, out});
                out.print(" = ");
                ctx.invoke("genInitialization", (EObject)field, new Object[]{ctx, out});
                out.println(";");
                if (adjustSmap) {
                    ctx.setSmapLastJavaLineNumber(out.getLineNumber() - 1);
                }
            }
            ctx.invoke("genStatementNoBraces", (Statement)field.getInitializerStatements(), (TemplateContext)ctx, out);
        }
    }

    public void genGetter(Field field, Context ctx, TabbedWriter out) {
        ctx.invoke("genAnnotations", (EObject)field, new Object[]{ctx, out});
        Function function = factory.createFunction();
        StatementBlock statementBlock = factory.createStatementBlock();
        MemberName nameExpression = factory.createMemberName();
        nameExpression.setMember((Member)field);
        nameExpression.setId(field.getName());
        ReturnStatement returnStatement = factory.createReturnStatement();
        returnStatement.setContainer((Container)function);
        returnStatement.setExpression((Expression)nameExpression);
        statementBlock.setContainer((Container)function);
        statementBlock.getStatements().add(returnStatement);
        function.setType(field.getType());
        function.setStatementBlock(statementBlock);
        function.setReturnField(field);
        function.setIsNullable(field.isNullable());
        function.setName("get" + this.genMethodName(field));
        ctx.invoke("genDeclaration", (EObject)function, new Object[]{ctx, out});
    }

    public void genSetter(Field field, Context ctx, TabbedWriter out) {
        Function function = factory.createFunction();
        StatementBlock statementBlock = factory.createStatementBlock();
        FunctionParameter functionParameter = factory.createFunctionParameter();
        functionParameter.setContainer((Container)function);
        functionParameter.setName("ezeValue");
        functionParameter.setParameterKind(ParameterKind.PARM_IN);
        functionParameter.setType(field.getType());
        functionParameter.setIsNullable(field.isNullable());
        AssignmentStatement assignmentStatement = factory.createAssignmentStatement();
        assignmentStatement.setContainer((Container)function);
        Assignment assignment = factory.createAssignment();
        assignmentStatement.setAssignment(assignment);
        MemberName nameExpression1 = factory.createMemberName();
        nameExpression1.setMember((Member)field);
        nameExpression1.setId(field.getName());
        MemberName nameExpression2 = factory.createMemberName();
        nameExpression2.setMember((Member)functionParameter);
        nameExpression2.setId(functionParameter.getName());
        assignment.setLHS((LHSExpr)nameExpression1);
        assignment.setRHS((Expression)nameExpression2);
        statementBlock.setContainer((Container)function);
        statementBlock.getStatements().add(assignmentStatement);
        function.setStatementBlock(statementBlock);
        function.getParameters().add(functionParameter);
        function.setName("set" + this.genMethodName(field));
        ctx.invoke("genDeclaration", (EObject)function, new Object[]{ctx, out});
    }

    protected String genMethodName(Field field) {
        String ret = field.getName().substring(0, 1).toUpperCase();
        if (field.getName().length() > 1) {
            ret = String.valueOf(ret) + field.getName().substring(1);
        }
        return ret;
    }

    protected void transientOption(Field field, TabbedWriter out) {
        ExternalType et = CommonUtilities.getJavaExternalType((Type)field.getType());
        if (et != null && !CommonUtilities.isSerializable((ExternalType)et)) {
            out.print("transient ");
        }
    }
}

