/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.gen.CommandParameter;
import org.eclipse.edt.gen.InvalidParameterValueException;
import org.eclipse.edt.gen.MissingParameterValueException;
import org.eclipse.edt.gen.PromptQueryException;
import org.eclipse.edt.gen.UnknownParameterException;

public abstract class CommandProcessor {
    protected Map<String, CommandParameter> parameterMapping = new HashMap<String, CommandParameter>();
    protected Map<String, String> aliasMapping = new HashMap<String, String>();

    public void installOverrides(String[] args) throws PromptQueryException, UnknownParameterException, InvalidParameterValueException, MissingParameterValueException {
        String internalName;
        String alias;
        CommandParameter parameter;
        String prompt = "";
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("?")) {
                for (Map.Entry<String, CommandParameter> entry : this.parameterMapping.entrySet()) {
                    parameter = entry.getValue();
                    prompt = String.valueOf(prompt) + parameter.getPromptText() + "\n";
                }
            } else if (args[i].startsWith("?")) {
                alias = args[i].substring(1);
                internalName = this.getAlias(alias);
                if (internalName == null) {
                    throw new UnknownParameterException(alias);
                }
                parameter = this.getParameter(internalName);
                if (parameter == null) {
                    throw new UnknownParameterException(internalName);
                }
                prompt = String.valueOf(prompt) + parameter.getPromptText() + "\n";
            }
            ++i;
        }
        if (prompt.length() > 0) {
            throw new PromptQueryException(prompt);
        }
        i = 0;
        while (i < args.length) {
            if (args[i].startsWith("-")) {
                int n;
                Object[] objectArray;
                Object[] possibleValues;
                String value;
                alias = args[i].substring(1);
                internalName = this.getAlias(alias);
                if (internalName == null) {
                    throw new UnknownParameterException(alias);
                }
                parameter = this.getParameter(internalName);
                if (parameter == null) {
                    throw new UnknownParameterException(internalName);
                }
                if (parameter.getPossibleValues() instanceof Boolean[]) {
                    boolean valid = false;
                    Boolean replacementValue = new Boolean(true);
                    value = "true";
                    if (i + 1 < args.length && !args[i + 1].startsWith("-") && !args[i + 1].startsWith("?")) {
                        value = args[i + 1];
                        ++i;
                    }
                    objectArray = possibleValues = parameter.getPossibleValues();
                    int n2 = possibleValues.length;
                    n = 0;
                    while (n < n2) {
                        Object possibleValue = objectArray[n];
                        if (possibleValue instanceof Boolean) {
                            if (((Boolean)possibleValue).booleanValue() && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes"))) {
                                valid = true;
                                replacementValue = new Boolean(true);
                            } else if (!((Boolean)possibleValue).booleanValue() && (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no"))) {
                                valid = true;
                                replacementValue = new Boolean(false);
                            }
                        }
                        ++n;
                    }
                    if (!valid) {
                        throw new InvalidParameterValueException(value);
                    }
                    parameter.setValue(replacementValue);
                } else if (parameter.getPossibleValues() instanceof String[]) {
                    boolean valid = false;
                    String replacementValue = "";
                    value = "";
                    if (i + 1 < args.length && !args[i + 1].startsWith("-") && !args[i + 1].startsWith("?")) {
                        value = args[i + 1];
                        ++i;
                    }
                    objectArray = possibleValues = parameter.getPossibleValues();
                    int n3 = possibleValues.length;
                    n = 0;
                    while (n < n3) {
                        Object possibleValue = objectArray[n];
                        if (possibleValue == null) {
                            valid = true;
                            replacementValue = value;
                        } else if (possibleValue instanceof String && value.equalsIgnoreCase((String)possibleValue)) {
                            valid = true;
                            replacementValue = value;
                        }
                        ++n;
                    }
                    if (!valid) {
                        throw new InvalidParameterValueException(value);
                    }
                    parameter.setValue(replacementValue);
                } else {
                    ArrayList<String> replacementValue = new ArrayList<String>();
                    while (i + 1 < args.length) {
                        Object[] possibleValues2;
                        if (args[i + 1].startsWith("-")) break;
                        boolean valid = false;
                        Object[] objectArray2 = possibleValues2 = parameter.getPossibleValues();
                        n = possibleValues2.length;
                        int n4 = 0;
                        while (n4 < n) {
                            Object possibleValue = objectArray2[n4];
                            if (possibleValue == null) {
                                valid = true;
                            } else if (possibleValue instanceof String && args[i + 1].equalsIgnoreCase((String)possibleValue)) {
                                valid = true;
                            }
                            ++n4;
                        }
                        if (!valid) {
                            throw new InvalidParameterValueException(args[i + 1]);
                        }
                        replacementValue.add(args[i + 1]);
                        ++i;
                    }
                    parameter.setValue(replacementValue.toArray());
                }
            }
            ++i;
        }
        for (Map.Entry<String, CommandParameter> entry : this.parameterMapping.entrySet()) {
            CommandParameter parameter2 = entry.getValue();
            if (!parameter2.isRequired() || parameter2.getValue() != null) continue;
            throw new MissingParameterValueException(entry.getKey());
        }
    }

    public void installParameter(boolean required, String internalName, String[] aliases, Object[] possibleValues, String promptText) {
        if (this.getParameter(internalName) != null) {
            System.out.print("This parameter already exists: " + internalName + ". It has been ignored.");
            return;
        }
        CommandParameter parameter = new CommandParameter(required, possibleValues, possibleValues[0], promptText);
        this.parameterMapping.put(internalName, parameter);
        if (aliases != null) {
            String[] stringArray = aliases;
            int n = aliases.length;
            int n2 = 0;
            while (n2 < n) {
                String alias = stringArray[n2];
                if (alias != null) {
                    if (this.getAlias(alias) != null) {
                        System.out.print("This alias already exists: " + alias + ". It has been ignored.");
                        return;
                    }
                    this.aliasMapping.put(alias.toLowerCase(), internalName);
                }
                ++n2;
            }
        }
    }

    private String getAlias(String aliasName) {
        return this.aliasMapping.get(aliasName.toLowerCase());
    }

    private CommandParameter getParameter(String internalName) {
        return this.parameterMapping.get(internalName);
    }
}

