/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.builder;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.edt.compiler.internal.io.IRFileNameUtility;
import org.eclipse.edt.ide.core.CoreIDEPluginStrings;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.internal.lookup.FileInfoManager;
import org.eclipse.edt.ide.core.internal.lookup.IFileInfo;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathManager;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.osgi.service.prefs.Preferences;

public class ProjectSettingsListenerManager {
    private static final ProjectSettingsListenerManager instance = new ProjectSettingsListenerManager();
    public static final Object FAMILY_PROCESS_GENERATOR_CHANGES = new Object();
    private Map<IProject, IEclipsePreferences.IPreferenceChangeListener> listeners = new HashMap<IProject, IEclipsePreferences.IPreferenceChangeListener>();

    private ProjectSettingsListenerManager() {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible()) {
                this.addProject(project);
            }
            ++n2;
        }
    }

    public static ProjectSettingsListenerManager getInstance() {
        return instance;
    }

    public void addProject(IProject project) {
        if (!this.listeners.containsKey(project)) {
            GeneratorPreferenceListener listener = new GeneratorPreferenceListener(project);
            Preferences prefs = new ProjectScope(project).getNode(EDTCoreIDEPlugin.PLUGIN_ID).node("generatorIds");
            if (prefs instanceof IEclipsePreferences) {
                ((IEclipsePreferences)prefs).addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)listener);
            }
            if ((prefs = new ProjectScope(project).getNode(EDTCoreIDEPlugin.PLUGIN_ID).node("buildFlag")) instanceof IEclipsePreferences) {
                ((IEclipsePreferences)prefs).addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)listener);
            }
            this.listeners.put(project, listener);
        }
    }

    public void removeProject(IProject project) {
        IEclipsePreferences.IPreferenceChangeListener listener = this.listeners.remove(project);
        if (listener != null) {
            Preferences prefs = new ProjectScope(project).getNode(EDTCoreIDEPlugin.PLUGIN_ID).node("generatorIds");
            if (prefs instanceof IEclipsePreferences) {
                ((IEclipsePreferences)prefs).removePreferenceChangeListener(listener);
            }
            if ((prefs = new ProjectScope(project).getNode(EDTCoreIDEPlugin.PLUGIN_ID).node("buildFlag")) instanceof IEclipsePreferences) {
                ((IEclipsePreferences)prefs).removePreferenceChangeListener(listener);
            }
        }
    }

    private class GeneratorPreferenceListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        final IProject project;
        final Preferences prefs;

        public GeneratorPreferenceListener(IProject project) {
            this.project = project;
            this.prefs = new ProjectScope(project).getNode(EDTCoreIDEPlugin.PLUGIN_ID).node("generatorIds");
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            String key = event.getKey();
            Object source = "<project>".equals(key) ? this.project : this.project.findMember(key);
            if (source != null) {
                IResource[] sourceDirs;
                try {
                    IPackageFragmentRoot[] roots = EGLCore.create(this.project).getPackageFragmentRoots();
                    sourceDirs = new IResource[roots.length];
                    int i = 0;
                    while (i < roots.length) {
                        if (!roots[i].isArchive()) {
                            sourceDirs[i] = roots[i].getResource();
                        }
                        ++i;
                    }
                }
                catch (EGLModelException e) {
                    EDTCoreIDEPlugin.log((Throwable)((Object)e));
                    return;
                }
                final IResource[] toTraverse = source.getType() == 4 ? sourceDirs : new IResource[]{source};
                WorkspaceJob job = new WorkspaceJob(CoreIDEPluginStrings.calculatingGeneratorChanges, (IResource)source){
                    private final /* synthetic */ IResource val$source;
                    {
                        this.val$source = iResource;
                        super($anonymous0);
                    }

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        final IContainer outputFolder = ProjectBuildPathManager.getInstance().getProjectBuildPath(GeneratorPreferenceListener.this.project).getOutputLocation();
                        IResource[] iResourceArray = toTraverse;
                        int n = toTraverse.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResource nextResource = iResourceArray[n2];
                            if (nextResource != null) {
                                IPath sourceDir = null;
                                IResource[] iResourceArray2 = sourceDirs;
                                int n3 = sourceDirs.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IResource nextSrcDir = iResourceArray2[n4];
                                    if (nextSrcDir != null && nextSrcDir.getFullPath().isPrefixOf(nextResource.getFullPath())) {
                                        sourceDir = nextSrcDir.getFullPath();
                                        break;
                                    }
                                    ++n4;
                                }
                                if (sourceDir != null) {
                                    final int sourceDirSegments = sourceDir.segmentCount();
                                    nextResource.accept(new IResourceProxyVisitor(){

                                        public boolean visit(IResourceProxy proxy) throws CoreException {
                                            IResource resource = proxy.requestResource();
                                            if (resource.equals((Object)val$source) || ProjectSettingsUtility.findSetting(resource.getFullPath(), (this).GeneratorPreferenceListener.this.prefs, false) == null) {
                                                if (resource.getType() == 1) {
                                                    IFileInfo info = FileInfoManager.getInstance().getFileInfo((this).GeneratorPreferenceListener.this.project, resource.getProjectRelativePath());
                                                    if (info != null) {
                                                        IPath relativeFolderPath = resource.getFullPath().removeFirstSegments(sourceDirSegments).removeLastSegments(1);
                                                        for (Object name : info.getPartNames()) {
                                                            if (info.getPartType((String)name) == 16) continue;
                                                            String relativePath = IRFileNameUtility.toIRFileName((String)relativeFolderPath.append((String)name).toString());
                                                            IResource file = outputFolder.findMember(String.valueOf(relativePath) + ".eglxml");
                                                            if (file != null) {
                                                                file.touch(null);
                                                            }
                                                            if ((file = outputFolder.findMember(String.valueOf(relativePath) + ".eglbin")) != null) {
                                                                file.touch(null);
                                                            }
                                                            if ((file = outputFolder.findMember(String.valueOf(relativePath) + ".mofxml")) != null) {
                                                                file.touch(null);
                                                            }
                                                            if ((file = outputFolder.findMember(String.valueOf(relativePath) + ".mofbin")) == null) continue;
                                                            file.touch(null);
                                                        }
                                                    }
                                                    return false;
                                                }
                                                return true;
                                            }
                                            return false;
                                        }
                                    }, 0);
                                }
                            }
                            ++n2;
                        }
                        return Status.OK_STATUS;
                    }

                    public boolean belongsTo(Object family) {
                        return family == FAMILY_PROCESS_GENERATOR_CHANGES;
                    }
                };
                job.schedule();
            }
        }
    }
}

