/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.compiler.workingcopy;

import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.binding.FileBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.compiler.internal.EGLAliasJsfNamesSetting;
import org.eclipse.edt.compiler.internal.EGLVAGCompatibilitySetting;
import org.eclipse.edt.compiler.internal.core.builder.AbstractProcessingQueue;
import org.eclipse.edt.compiler.internal.core.builder.IBuildNotifier;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.NullProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.BindingCreator;
import org.eclipse.edt.compiler.internal.core.lookup.EnvironmentScope;
import org.eclipse.edt.compiler.internal.core.lookup.FileScope;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionContainerScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.core.lookup.SystemScope;
import org.eclipse.edt.compiler.internal.util.TopLevelFunctionInfo;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.internal.compiler.Binder;
import org.eclipse.edt.ide.core.internal.compiler.Compiler;
import org.eclipse.edt.ide.core.internal.compiler.SystemEnvironmentManager;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.IProblemRequestorFactory;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.IWorkingCopyCompileRequestor;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyASTManager;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyCompilationResult;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyTopLevelFunctionProcessingQueue;
import org.eclipse.edt.ide.core.internal.dependency.AbstractDependencyInfo;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyBuildNotifier;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectBuildPathEntryManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectEnvironmentManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectInfo;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectInfoManager;
import org.eclipse.edt.ide.core.internal.utils.Util;
import org.eclipse.edt.mof.egl.utils.InternUtil;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.IEnvironment;

public class WorkingCopyProcessingQueue
extends AbstractProcessingQueue {
    private IProject project;
    private IProblemRequestorFactory problemRequestorFactory;
    private IWorkingCopyCompileRequestor requestor;
    private WorkingCopyProjectEnvironment projectEnvironment;
    private WorkingCopyProjectInfo projectInfo;
    private boolean pushedEnvironment;

    public WorkingCopyProcessingQueue(IProject project, IProblemRequestorFactory problemRequestorFactory) {
        super((IBuildNotifier)WorkingCopyBuildNotifier.getInstance(), new ICompilerOptions(){

            public boolean isVAGCompatible() {
                return EGLVAGCompatibilitySetting.isVAGCompatibility();
            }

            public boolean isAliasJSFNames() {
                return EGLAliasJsfNamesSetting.isAliasJsfNames();
            }
        });
        this.project = project;
        this.problemRequestorFactory = problemRequestorFactory;
        WorkingCopyProjectBuildPathEntry entry = WorkingCopyProjectBuildPathEntryManager.getInstance().getProjectBuildPathEntry(project);
        entry.setProcessingQueue(this);
        this.projectEnvironment = WorkingCopyProjectEnvironmentManager.getInstance().getProjectEnvironment(project);
        this.projectEnvironment.getIREnvironment().initSystemEnvironment(this.projectEnvironment.getSystemEnvironment());
        this.projectInfo = WorkingCopyProjectInfoManager.getInstance().getProjectInfo(project);
        Environment.pushEnv((IEnvironment)this.projectEnvironment.getIREnvironment());
        this.pushedEnvironment = true;
    }

    public boolean pushedEnvironment() {
        return this.pushedEnvironment;
    }

    public void setCompileRequestor(IWorkingCopyCompileRequestor requestor) {
        this.requestor = requestor;
    }

    protected boolean hasExceededMaxLoop() {
        return false;
    }

    protected IPartBinding level03Compile(String[] packageName, String caseSensitiveInternedPartName) {
        String caseInsensitiveInternedPartName = InternUtil.intern((String)caseSensitiveInternedPartName);
        IFile declaringFile = this.projectInfo.getPartOrigin(packageName, caseInsensitiveInternedPartName).getEGLFile();
        Node partAST = WorkingCopyASTManager.getInstance().getAST(declaringFile, caseInsensitiveInternedPartName);
        IPartBinding binding = new BindingCreator((org.eclipse.edt.compiler.internal.core.lookup.IEnvironment)this.projectEnvironment, packageName, caseSensitiveInternedPartName, partAST).getPartBinding();
        binding.setEnvironment((org.eclipse.edt.compiler.internal.core.lookup.IEnvironment)this.projectEnvironment);
        WorkingCopyDependencyInfo dependencyInfo = new WorkingCopyDependencyInfo();
        Scope scope = this.createScope(packageName, declaringFile, binding, dependencyInfo);
        IProblemRequestor problemRequestor = this.createProblemRequestor(caseInsensitiveInternedPartName, declaringFile, partAST, binding);
        if (problemRequestor != NullProblemRequestor.getInstance()) {
            Compiler.getInstance().compilePart(partAST, binding, scope, dependencyInfo, problemRequestor, this.compilerOptions);
            if (binding.getKind() == 16) {
                this.validatePackageDeclaration(packageName, declaringFile, partAST, (FileBinding)binding, problemRequestor);
            }
        } else {
            Binder.getInstance().bindPart(partAST, binding, scope, dependencyInfo, problemRequestor, this.compilerOptions);
        }
        TopLevelFunctionInfo[] topLevelFunctions = new TopLevelFunctionInfo[]{};
        if (dependencyInfo.getFunctionContainerScope() != null) {
            topLevelFunctions = this.processTopLevelFunctions(dependencyInfo.getTopLevelFunctions(), dependencyInfo.getFunctionContainerScope(), dependencyInfo);
        }
        this.requestor.acceptResult(new WorkingCopyCompilationResult(partAST, binding, declaringFile, topLevelFunctions));
        WorkingCopyASTManager.getInstance().reportNestedFunctions(partAST, declaringFile);
        return binding;
    }

    protected IPartBinding level02Compile(String[] packageName, String caseSensitiveInternedPartName) {
        return WorkingCopyProjectBuildPathEntryManager.getInstance().getProjectBuildPathEntry(this.project).compileLevel2Binding(packageName, caseSensitiveInternedPartName);
    }

    protected IPartBinding level01Compile(String[] packageName, String caseSensitiveInternedPartName) {
        return this.projectEnvironment.level01Compile(packageName, caseSensitiveInternedPartName);
    }

    protected IPartBinding getPartBindingFromCache(String[] packageName, String partName) {
        return WorkingCopyProjectBuildPathEntryManager.getInstance().getProjectBuildPathEntry(this.project).getPartBindingFromCache(packageName, partName);
    }

    private Scope createScope(String[] packageName, IFile declaringFile, IPartBinding binding, AbstractDependencyInfo dependencyInfo) {
        EnvironmentScope scope;
        if (binding.getKind() == 16) {
            scope = new EnvironmentScope((org.eclipse.edt.compiler.internal.core.lookup.IEnvironment)this.projectEnvironment, (IDependencyRequestor)dependencyInfo);
        } else {
            String fileName = Util.getFilePartName(declaringFile);
            IPartBinding fileBinding = this.projectEnvironment.getPartBinding(packageName, fileName);
            scope = new SystemScope((Scope)new FileScope((Scope)new EnvironmentScope((org.eclipse.edt.compiler.internal.core.lookup.IEnvironment)this.projectEnvironment, (IDependencyRequestor)dependencyInfo), (FileBinding)fileBinding, (IDependencyRequestor)dependencyInfo), (org.eclipse.edt.compiler.internal.core.lookup.IEnvironment)SystemEnvironmentManager.findSystemEnvironment(this.project, null));
        }
        return scope;
    }

    private TopLevelFunctionInfo[] processTopLevelFunctions(Set topLevelFunctions, FunctionContainerScope contextScope, AbstractDependencyInfo dependencyInfo) {
        WorkingCopyTopLevelFunctionProcessingQueue queue = new WorkingCopyTopLevelFunctionProcessingQueue(this.project, contextScope, dependencyInfo, this.compilerOptions, this.problemRequestorFactory);
        for (IPartBinding function : topLevelFunctions) {
            queue.addPart(function);
        }
        queue.process();
        return queue.getTopLevelFunctionInfos();
    }

    protected void doAddPart(String[] packageName, String caseInsensitiveInternedPartName) {
        this.addPart(packageName, this.projectInfo.getCaseSensitivePartName(packageName, caseInsensitiveInternedPartName));
    }

    private IProblemRequestor createProblemRequestor(String partName, IFile file, Node partAST, IPartBinding binding) {
        IProblemRequestor newRequestor = binding.getKind() == 20 ? this.problemRequestorFactory.getGenericTopLevelFunctionProblemRequestor(file, partName, ((TopLevelFunction)partAST).isContainerContextDependent()) : this.problemRequestorFactory.getProblemRequestor(file, partName);
        return newRequestor;
    }

    private void validatePackageDeclaration(String[] packageName, IFile declaringFile, Node partAST, FileBinding binding, IProblemRequestor problemRequestor) {
        try {
            IPackageBinding declaringPackage = binding.getDeclaringPackage();
            if (declaringPackage != null && declaringPackage.getPackageName() != packageName) {
                if (packageName.length == 0) {
                    problemRequestor.acceptProblem((Node)((File)partAST).getPackageDeclaration(), 3049, new String[0]);
                } else if (((File)partAST).hasPackageDeclaration()) {
                    problemRequestor.acceptProblem((Node)((File)partAST).getPackageDeclaration(), 3049, new String[0]);
                } else {
                    IPath packagePath = declaringFile.getProjectRelativePath().removeFileExtension().removeLastSegments(1);
                    packagePath = packagePath.removeFirstSegments(packagePath.segmentCount() - packageName.length);
                    problemRequestor.acceptProblem(0, 0, 2, 3064, new String[]{packagePath.toString().replace('/', '.')});
                }
            } else if (((File)partAST).hasPackageDeclaration()) {
                String packageDeclName = ((File)partAST).getPackageDeclaration().getName().getCanonicalName();
                IPath packagePath = declaringFile.getProjectRelativePath().removeFileExtension().removeLastSegments(1);
                if (!packageDeclName.equals((packagePath = packagePath.removeFirstSegments(packagePath.segmentCount() - packageName.length)).toString().replace('/', ".".charAt(0)))) {
                    problemRequestor.acceptProblem((Node)((File)partAST).getPackageDeclaration(), 3049, 2, new String[0]);
                }
            }
        }
        catch (RuntimeException e) {
            problemRequestor.acceptProblem(0, 0, 2, 3000, new String[]{binding.getName()});
            EDTCoreIDEPlugin.getPlugin().log("Part Validation Failure", e);
        }
    }

    private class WorkingCopyDependencyInfo
    extends AbstractDependencyInfo {
        private WorkingCopyDependencyInfo() {
        }

        @Override
        protected void recordQualifiedName(String[] strings) {
        }

        @Override
        public Set getQualifiedNames() {
            return Collections.EMPTY_SET;
        }

        @Override
        public Set getSimpleNames() {
            return Collections.EMPTY_SET;
        }

        public void recordBinding(IBinding binding) {
        }

        public void recordName(Name name) {
        }

        public void recordPackageBinding(IPackageBinding binding) {
        }

        public void recordSimpleName(String simpleName) {
        }

        public void recordTypeBinding(ITypeBinding binding) {
        }
    }
}

