/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.util;

import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvHelp;
import org.eclipse.edt.ide.rui.visualeditor.internal.nl.Messages;
import org.eclipse.edt.ide.rui.visualeditor.internal.nl.Tooltips;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.ColorSelectorButton;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.ColorUtil;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.Mnemonics;
import org.eclipse.edt.ide.rui.visualeditor.plugin.Activator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ColorSelectionDialog
extends Dialog
implements DisposeListener,
ModifyListener,
SelectionListener {
    protected static int IMAGE_WIDTH = 50;
    protected Button _buttonColorSelection = null;
    protected Color[] _colors = null;
    protected ColorSelectorButton _colorSelector = null;
    protected Combo _comboNames = null;
    protected Image[] _images = null;
    protected Button _radioCustom = null;
    protected Button _radioName = null;
    protected Button _radioNumbered = null;
    protected Button _radioNumberedHex = null;
    protected Button _radioNumberedRGB = null;
    protected String _strColorValue = null;
    protected Table _tableNames = null;
    protected Text _textColorValue = null;
    protected Text _textCustom = null;

    public ColorSelectionDialog(Shell shellParent, String strColorValue) {
        super(shellParent);
        this._strColorValue = strColorValue != null ? strColorValue : "";
        EvHelp.setHelp((Control)shellParent, EvHelp.COLOR_SELECTION_DIALOG);
    }

    protected Control createDialogArea(Composite compositeParent) {
        this.initializeColorImages();
        this.getShell().setText(Messages.NL_Color_selection);
        Image image = Activator.getImage("elcl16/colorselectiondialog_obj.gif");
        this.getShell().setImage(image);
        Composite composite = new Composite(compositeParent, 0);
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        composite.addDisposeListener((DisposeListener)this);
        Label labelInstruction = new Label(composite, 0);
        GridData gridData = new GridData(768);
        labelInstruction.setLayoutData((Object)gridData);
        labelInstruction.setText(Messages.NL_Choose_a_color_and_a_format);
        this._radioNumbered = new Button(composite, 16);
        gridData = new GridData(768);
        gridData.horizontalIndent = 8;
        this._radioNumbered.setLayoutData((Object)gridData);
        this._radioNumbered.setText(Messages.NL_Number_format);
        Composite compositeNumberFormat = new Composite(composite, 0);
        gridData = new GridData(768);
        gridData.horizontalIndent = 16;
        compositeNumberFormat.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        compositeNumberFormat.setLayout((Layout)gridLayout);
        Group group1 = new Group(compositeNumberFormat, 0);
        gridData = new GridData(1808);
        group1.setLayoutData((Object)gridData);
        group1.setText(Messages.NL_Color);
        gridLayout = new GridLayout();
        group1.setLayout((Layout)gridLayout);
        this._colorSelector = new ColorSelectorButton();
        this._buttonColorSelection = this._colorSelector.createWidget(group1);
        gridData = new GridData(1808);
        gridData.horizontalAlignment = 0x1000000;
        gridData.verticalAlignment = 0x1000000;
        this._buttonColorSelection.setLayoutData((Object)gridData);
        this._buttonColorSelection.setToolTipText(Tooltips.NL_Press_to_select_a_color);
        Group group = new Group(compositeNumberFormat, 0);
        gridData = new GridData(1808);
        group.setLayoutData((Object)gridData);
        group.setText(Messages.NL_Format);
        gridLayout = new GridLayout();
        group.setLayout((Layout)gridLayout);
        this._radioNumberedRGB = new Button((Composite)group, 16);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this._radioNumberedRGB.setLayoutData((Object)gridData);
        this._radioNumberedRGB.setText(Messages.NL_RGB);
        this._radioNumberedHex = new Button((Composite)group, 16);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this._radioNumberedHex.setLayoutData((Object)gridData);
        this._radioNumberedHex.setText(Messages.NL_Hexadecimal);
        this._radioName = new Button(composite, 16);
        gridData = new GridData(768);
        gridData.horizontalIndent = 8;
        this._radioName.setLayoutData((Object)gridData);
        this._radioName.setText(Messages.NL_Name_format);
        Composite compositeNameFormat = new Composite(composite, 0);
        gridData = new GridData(768);
        compositeNameFormat.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        compositeNameFormat.setLayout((Layout)gridLayout);
        this._tableNames = new Table(compositeNameFormat, 68352);
        gridData = new GridData(768);
        gridData.heightHint = 200;
        gridData.widthHint = 200;
        gridData.horizontalIndent = 16;
        this._tableNames.setLayoutData((Object)gridData);
        TableColumn tableColumn = new TableColumn(this._tableNames, 65536);
        tableColumn.setText(Messages.NL_Color_name);
        TableLayout layoutTable = new TableLayout();
        ColumnWeightData cLayout = new ColumnWeightData(100, false);
        layoutTable.addColumnData((ColumnLayoutData)cLayout);
        this._tableNames.setLinesVisible(true);
        this._tableNames.setHeaderVisible(false);
        this._tableNames.setLayout((Layout)layoutTable);
        String[] straColors = ColorUtil.getColorNames();
        String[] straHex = ColorUtil.getColorHexValues();
        int i = 0;
        while (i < straHex.length) {
            TableItem item = new TableItem(this._tableNames, 0);
            item.setText(straColors[i]);
            item.setImage(this._images[i]);
            ++i;
        }
        this._radioCustom = new Button(composite, 16);
        gridData = new GridData(768);
        gridData.horizontalIndent = 8;
        this._radioCustom.setLayoutData((Object)gridData);
        this._radioCustom.setText(Messages.NL_Custom);
        Composite compositeCustom = new Composite(composite, 0);
        gridData = new GridData(768);
        compositeCustom.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        compositeCustom.setLayout((Layout)gridLayout);
        this._textCustom = new Text(compositeCustom, 2048);
        gridData = new GridData(768);
        gridData.horizontalIndent = 16;
        this._textCustom.setLayoutData((Object)gridData);
        Label label = new Label(composite, 258);
        gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        Composite compositeFormattedValue = new Composite(composite, 0);
        gridData = new GridData(768);
        compositeFormattedValue.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        compositeFormattedValue.setLayout((Layout)gridLayout);
        label = new Label(compositeFormattedValue, 0);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(Messages.NL_ValueXcolonX);
        this._textColorValue = new Text(compositeFormattedValue, 2056);
        gridData = new GridData(768);
        this._textColorValue.setLayoutData((Object)gridData);
        this.initialize();
        this._colorSelector.setModifyListener(this);
        this._tableNames.addSelectionListener((SelectionListener)this);
        this._radioNumbered.addSelectionListener((SelectionListener)this);
        this._radioNumberedRGB.addSelectionListener((SelectionListener)this);
        this._radioNumberedHex.addSelectionListener((SelectionListener)this);
        this._radioName.addSelectionListener((SelectionListener)this);
        this._radioCustom.addSelectionListener((SelectionListener)this);
        this._textCustom.addModifyListener((ModifyListener)this);
        new Mnemonics().setMnemonics(composite);
        return composite;
    }

    public String getColorValue() {
        return this._strColorValue;
    }

    protected void initialize() {
        this._textColorValue.setText(this._strColorValue);
        if (this._strColorValue.length() == 0) {
            this._radioNumbered.setSelection(false);
            this._radioNumberedRGB.setSelection(true);
            this._radioNumberedHex.setSelection(false);
            this._radioName.setSelection(false);
            this._radioCustom.setSelection(true);
            this._textCustom.setText(this._strColorValue);
            this.updateControls();
            return;
        }
        RGB rgb = ColorUtil.convertRGBStringToRGB(this._strColorValue);
        if (rgb != null) {
            this._radioNumbered.setSelection(true);
            this._radioNumberedRGB.setSelection(true);
            this._radioNumberedHex.setSelection(false);
            this._radioName.setSelection(false);
            this._radioCustom.setSelection(false);
            this._colorSelector.setRGB(rgb);
            this._strColorValue = ColorUtil.convertRgbToRgbString(rgb);
            this._textColorValue.setText(this._strColorValue);
            this.updateControls();
            return;
        }
        rgb = ColorUtil.convertHexStringToRGB(this._strColorValue);
        if (rgb != null) {
            this._radioNumbered.setSelection(true);
            this._radioNumberedRGB.setSelection(false);
            this._radioNumberedHex.setSelection(true);
            this._radioName.setSelection(false);
            this._radioCustom.setSelection(false);
            this._colorSelector.setRGB(rgb);
            this._strColorValue = ColorUtil.convertRgbToHexString(rgb);
            this._textColorValue.setText(this._strColorValue);
            this.updateControls();
            return;
        }
        int iIndex = -1;
        String[] straColors = ColorUtil.getColorNames();
        int i = 0;
        while (i < straColors.length) {
            if (this._strColorValue.equalsIgnoreCase(straColors[i])) {
                iIndex = i;
                break;
            }
            ++i;
        }
        if (iIndex >= 0) {
            this._radioNumbered.setSelection(false);
            this._radioNumberedRGB.setSelection(true);
            this._radioNumberedHex.setSelection(false);
            this._radioName.setSelection(true);
            this._radioCustom.setSelection(false);
            this._tableNames.setSelection(iIndex);
            this.updateControls();
            return;
        }
        this._radioNumbered.setSelection(false);
        this._radioNumberedRGB.setSelection(true);
        this._radioNumberedHex.setSelection(false);
        this._radioName.setSelection(false);
        this._radioCustom.setSelection(true);
        this._textCustom.setText(this._strColorValue);
        this.updateControls();
    }

    protected void initializeColorImages() {
        GC gc = new GC((Drawable)this.getShell());
        Font f = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
        gc.setFont(f);
        int iImageHeight = gc.getFontMetrics().getHeight();
        gc.dispose();
        Color colorBlack = this.getShell().getDisplay().getSystemColor(2);
        String[] straColors = ColorUtil.getColorNames();
        String[] straHex = ColorUtil.getColorHexValues();
        this._colors = new Color[straColors.length];
        this._images = new Image[straColors.length];
        int i = 0;
        while (i < straHex.length) {
            String strR = straHex[i].substring(0, 2);
            String strG = straHex[i].substring(2, 4);
            String strB = straHex[i].substring(4);
            int iR = Integer.parseInt(strR, 16);
            int iG = Integer.parseInt(strG, 16);
            int iB = Integer.parseInt(strB, 16);
            RGB rgb = new RGB(iR, iG, iB);
            this._colors[i] = new Color((Device)this.getShell().getDisplay(), rgb);
            this._images[i] = new Image((Device)this.getShell().getDisplay(), IMAGE_WIDTH, iImageHeight);
            gc = new GC((Drawable)this._images[i]);
            gc.setBackground(this._colors[i]);
            gc.fillRectangle(0, 0, IMAGE_WIDTH, iImageHeight);
            gc.setBackground(colorBlack);
            gc.drawRectangle(0, 0, IMAGE_WIDTH - 1, iImageHeight - 1);
            gc.dispose();
            ++i;
        }
    }

    public void modifyText(ModifyEvent event) {
        if (event.widget == this._buttonColorSelection) {
            RGB rgb = this._colorSelector.getRGB();
            if (this._radioNumberedRGB.getSelection()) {
                String strRGB = ColorUtil.convertRgbToRgbString(rgb);
                this._textColorValue.setText(strRGB);
            } else {
                String strHex = ColorUtil.convertRgbToHexString(rgb);
                this._textColorValue.setText(strHex);
            }
        } else if (event.widget == this._textCustom) {
            this._textColorValue.setText(this._textCustom.getText());
        }
    }

    protected void okPressed() {
        this._strColorValue = this._textColorValue.getText();
        super.okPressed();
    }

    protected void updateControls() {
        boolean bNumbered = this._radioNumbered.getSelection();
        boolean bNamed = this._radioName.getSelection();
        boolean bCustom = this._radioCustom.getSelection();
        this._buttonColorSelection.setEnabled(bNumbered);
        this._radioNumberedRGB.setEnabled(bNumbered);
        this._radioNumberedHex.setEnabled(bNumbered);
        this._tableNames.setEnabled(bNamed);
        this._textCustom.setEnabled(bCustom);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void widgetDisposed(DisposeEvent e) {
        int i = 0;
        while (i < this._colors.length) {
            this._colors[i].dispose();
            ++i;
        }
        i = 0;
        while (i < this._images.length) {
            this._images[i].dispose();
            ++i;
        }
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.getSource() == this._tableNames) {
            TableItem[] tableItems = this._tableNames.getSelection();
            if (tableItems.length == 0) {
                return;
            }
            String strTableSelection = tableItems[0].getText();
            this._textColorValue.setText(strTableSelection);
        } else if (event.getSource() == this._radioNumbered) {
            this.updateControls();
            if (this._radioNumberedRGB.getSelection()) {
                RGB rgb = this._colorSelector.getRGB();
                String strRGB = ColorUtil.convertRgbToRgbString(rgb);
                this._textColorValue.setText(strRGB);
            } else {
                RGB rgb = this._colorSelector.getRGB();
                String strHex = ColorUtil.convertRgbToHexString(rgb);
                this._textColorValue.setText(strHex);
            }
        } else if (event.getSource() == this._radioNumberedRGB) {
            RGB rgb = this._colorSelector.getRGB();
            String strRGB = ColorUtil.convertRgbToRgbString(rgb);
            this._textColorValue.setText(strRGB);
        } else if (event.getSource() == this._radioNumberedHex) {
            RGB rgb = this._colorSelector.getRGB();
            String strHex = ColorUtil.convertRgbToHexString(rgb);
            this._textColorValue.setText(strHex);
        } else if (event.getSource() == this._radioName) {
            this.updateControls();
            TableItem[] tableItems = this._tableNames.getSelection();
            if (tableItems.length == 0) {
                this._tableNames.setSelection(0);
                tableItems = this._tableNames.getSelection();
            }
            String strTableSelection = tableItems[0].getText();
            this._textColorValue.setText(strTableSelection);
        } else if (event.getSource() == this._radioCustom) {
            this.updateControls();
            this._textColorValue.setText(this._textCustom.getText());
        }
    }
}

