/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.views.dataview;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.core.model.document.IEGLModelChangeListener;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvEditor;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvHelp;
import org.eclipse.edt.ide.rui.visualeditor.internal.views.dataview.DefaultPage;
import org.eclipse.edt.ide.rui.visualeditor.internal.views.dataview.IPageDataViewPage;
import org.eclipse.edt.ide.rui.visualeditor.internal.views.dataview.PageDataView;
import org.eclipse.edt.ide.rui.visualeditor.internal.views.dataview.PageDataViewContentProvider;
import org.eclipse.edt.ide.rui.visualeditor.internal.views.dataview.PageDataViewDragAdapter;
import org.eclipse.edt.ide.rui.visualeditor.internal.views.dataview.PageDataViewLabelProvider;
import org.eclipse.edt.ide.rui.visualeditor.internal.views.dataview.action.DataViewActionGroup;
import org.eclipse.edt.ide.rui.visualeditor.internal.views.dataview.model.PageDataModel;
import org.eclipse.edt.ide.rui.visualeditor.internal.views.dataview.model.PageDataModelBuilder;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;

public class PageDataViewPage
extends Page
implements IPageDataViewPage,
IEGLModelChangeListener {
    public static final int DESIGN_PAGE = 0;
    public static final int SOURCE_PAGE = 1;
    public static final int PREVIEW_PAGE = 3;
    private PageBook pageBook;
    private int currentEditorPage;
    private PageDataView pageDataView;
    private IEGLDocument document;
    private TreeViewer treeViewer;
    private ListenerList selectionChangedListeners = new ListenerList();
    private EvEditor evEditor;
    private EGLEditor eglEditor;
    private DefaultPage defaultPage;
    private Reconciler reconciler = new Reconciler();
    private boolean reconcilerScheduled;
    private static final int DELAY = 2000;

    public PageDataViewPage(IEGLDocument document, EvEditor evEditor) {
        this.document = document;
        this.evEditor = evEditor;
        this.eglEditor = evEditor.getPageSource();
        this.defaultPage = new DefaultPage();
        document.addModelChangeListener((IEGLModelChangeListener)this);
    }

    public void showPage(int iPage) {
        this.currentEditorPage = iPage;
        if (this.pageBook != null) {
            switch (iPage) {
                case 0: {
                    this.pageBook.showPage(this.treeViewer.getControl());
                    this.updateTreeViewer();
                    break;
                }
                case 1: {
                    this.pageBook.showPage(this.pageDataView.getDefaultPage().getControl());
                    break;
                }
                case 3: {
                    this.pageBook.showPage(this.pageDataView.getDefaultPage().getControl());
                }
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
        if (this.treeViewer != null) {
            this.treeViewer.addPostSelectionChangedListener(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
        if (this.treeViewer != null) {
            this.treeViewer.removePostSelectionChangedListener(listener);
        }
    }

    public void createControl(Composite parent) {
        if (this.eglEditor == null) {
            this.eglEditor = this.evEditor.getPageSource();
        }
        this.pageBook = (PageBook)parent;
        PageDataModel model = PageDataModelBuilder.getInstance().create(this.document.getNewModelEGLFile(), this.eglEditor);
        this.treeViewer = new TreeViewer(parent, 768);
        this.treeViewer.setContentProvider((IContentProvider)new PageDataViewContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new PageDataViewLabelProvider());
        DataViewActionGroup dataViewActionGroup = new DataViewActionGroup(this.treeViewer, this.evEditor);
        dataViewActionGroup.fillContextMenu((IMenuManager)new MenuManager());
        Transfer[] transfers = new Transfer[]{TemplateTransfer.getInstance()};
        this.treeViewer.addDragSupport(0, transfers, (DragSourceListener)new PageDataViewDragAdapter(this, this.treeViewer.getTree()));
        this.treeViewer.setInput((Object)model);
        this.treeViewer.expandToLevel(10);
        EvHelp.setHelp((Control)parent, EvHelp.DATA_VIEW);
    }

    public void dispose() {
        if (this.eglEditor == null) {
            return;
        }
        if (this.document != null) {
            this.document.removeModelChangeListener((IEGLModelChangeListener)this);
        }
        this.eglEditor.outlinePageClosed();
        this.eglEditor = null;
        this.selectionChangedListeners.clear();
        this.selectionChangedListeners = null;
        this.treeViewer = null;
        super.dispose();
    }

    public IEGLDocument getDocument() {
        return this.document;
    }

    public EGLEditor getEditor() {
        return this.eglEditor;
    }

    public void select(Object reference) {
        IStructuredSelection ss;
        List elements;
        ISelection s;
        if (this.treeViewer != null && (s = this.treeViewer.getSelection()) instanceof IStructuredSelection && !(elements = (ss = (IStructuredSelection)s).toList()).contains(reference)) {
            s = reference == null ? StructuredSelection.EMPTY : new StructuredSelection(reference);
            this.treeViewer.setSelection(s, true);
        }
    }

    public void modelChanged() {
        if (this.currentEditorPage == 0) {
            this.updateTreeViewer();
        }
    }

    private void updateTreeViewer() {
        if (!this.reconcilerScheduled && this.treeViewer != null && !this.treeViewer.getControl().isDisposed()) {
            PageDataModel model = PageDataModelBuilder.getInstance().create(this.document.getNewModelEGLFile(), this.eglEditor);
            this.treeViewer.setInput((Object)model);
            this.treeViewer.expandToLevel(10);
            this.treeViewer.getControl().getDisplay().timerExec(2000, (Runnable)this.reconciler);
        }
    }

    public IEditorInput getEditorInput() {
        return this.eglEditor.getEditorInput();
    }

    public void setInput(IEGLDocument newDocument) {
        if (this.document != null) {
            this.document.removeModelChangeListener((IEGLModelChangeListener)this);
        }
        this.document = newDocument;
        if (this.document != null) {
            this.document.addModelChangeListener((IEGLModelChangeListener)this);
        }
        if (this.treeViewer != null) {
            this.treeViewer.setInput((Object)newDocument.getNewModelEGLFile());
        }
    }

    public void refresh() {
        if (this.treeViewer != null) {
            this.document.reconcile();
            this.treeViewer.refresh((Object)this.document.getNewModelEGLFile(), true);
        }
    }

    public IFile getFile() {
        return ((IFileEditorInput)this.getEditorInput()).getFile();
    }

    public ISelection getSelection() {
        if (this.treeViewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this.treeViewer.getSelection();
    }

    public void setSelection(ISelection selection) {
        if (this.treeViewer != null) {
            this.treeViewer.setSelection(selection);
        }
    }

    public Control getControl() {
        Control control = null;
        if (this.treeViewer == null) {
            return control;
        }
        switch (this.evEditor.getPageIndex()) {
            case 0: {
                control = this.treeViewer.getControl();
                break;
            }
            case 1: {
                control = this.defaultPage.getControl();
                break;
            }
            case 3: {
                control = this.defaultPage.getControl();
            }
        }
        return control;
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    @Override
    public void setPageDataView(PageDataView pageDataView) {
        this.pageDataView = pageDataView;
    }

    private class Reconciler
    implements Runnable {
        private Reconciler() {
        }

        @Override
        public void run() {
            long currentTime = System.currentTimeMillis();
            if (currentTime - PageDataViewPage.this.document.getLastUpdateTime() < 2000L) {
                if (!PageDataViewPage.this.treeViewer.getControl().isDisposed()) {
                    PageDataViewPage.this.treeViewer.getControl().getDisplay().timerExec(2000, (Runnable)PageDataViewPage.this.reconciler);
                }
                return;
            }
            if (!PageDataViewPage.this.treeViewer.getControl().isDisposed()) {
                PageDataViewPage.this.treeViewer.getControl().setRedraw(false);
                PageDataViewPage.this.document.reconcile();
                PageDataViewPage.this.treeViewer.refresh((Object)PageDataViewPage.this.document.getNewModelEGLFile(), true);
                PageDataViewPage.this.treeViewer.getControl().setRedraw(true);
            }
            PageDataViewPage.this.reconcilerScheduled = false;
        }
    }
}

