/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.internal.project;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.ide.rui.internal.project.IWidgetLibraryImporter;
import org.eclipse.edt.ide.ui.project.templates.AbstractProjectTemplateClass;
import org.eclipse.edt.ide.ui.wizards.AddProjectDependencyOperation;
import org.eclipse.edt.ide.ui.wizards.ProjectConfiguration;
import org.eclipse.edt.ide.widgetLibProvider.IWidgetLibProvider;
import org.eclipse.edt.ide.widgetLibProvider.WidgetLibProviderManager;

public class WebClientProjectTemplate
extends AbstractProjectTemplateClass {
    protected static final String COMMON = "common";
    protected static final String CLIENT = "client";

    protected void setTargetRuntime(ProjectConfiguration eglProjConfiguration) {
        eglProjConfiguration.setTargetRuntimeValue(3);
    }

    public void applyTemplate(IProject project) {
    }

    private URL getWidgetProjectURL(String resourcePluginName, String libraryResourceFolder, String projectName) throws IOException {
        URL url = FileLocator.resolve((URL)Platform.getBundle((String)resourcePluginName).getEntry(String.valueOf(libraryResourceFolder) + projectName + ".zip"));
        return url;
    }

    protected void addMoreOperations(ProjectConfiguration eglProjConfiguration, ISchedulingRule rule, List listOps) {
        ArrayList<AddProjectDependencyOperation> dependencyOps = new ArrayList<AddProjectDependencyOperation>();
        IWidgetLibProvider[] providers = WidgetLibProviderManager.getInstance().getProviders();
        if (providers != null) {
            int i = 0;
            while (i < providers.length) {
                String id = providers[i].getId();
                String projectName = providers[i].getProjectName();
                String resourcePluginName = providers[i].getResourcePluginName();
                String resourceFolder = providers[i].getResourceFolder();
                if (eglProjConfiguration.getSelectedWidgetLibraries().contains(id)) {
                    IWidgetLibraryImporter importer = providers[i].getImporter();
                    listOps.add(importer.getImportRUIProjectsOperation(rule, resourcePluginName, resourceFolder, projectName));
                    dependencyOps.add(importer.getAddProjectDependencyOperation(eglProjConfiguration, rule, projectName));
                }
                ++i;
            }
        }
        listOps.addAll(dependencyOps);
    }

    protected void setProjectCompilerAndGenerator(ProjectConfiguration eglProjConfiguration) {
        eglProjConfiguration.setSelectedCompiler("org.eclipse.edt.ide.compiler.edtCompiler");
        String[] generatorIds = new String[]{"org.eclipse.edt.ide.gen.JavaScriptGenProvider", "org.eclipse.edt.ide.gen.JavaScriptDevGenProvider"};
        eglProjConfiguration.setSelectedGenerators(generatorIds);
    }

    protected void setDefaultPackages() {
        this.setDefaultPackages(new String[]{CLIENT});
    }

    protected void createPackage(ProjectConfiguration eglProjConfiguration, List listOps, String basePackage, String packageName) {
        String comboundPackageName;
        if (packageName != null && packageName.length() > 0) {
            comboundPackageName = basePackage != null && basePackage.length() > 0 ? String.valueOf(basePackage) + "." + packageName : packageName;
        } else if (basePackage != null && basePackage.length() > 0) {
            comboundPackageName = basePackage;
        } else {
            return;
        }
        super.createPackage(eglProjConfiguration, listOps, basePackage, comboundPackageName);
    }
}

