/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.wizards.pages;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.internal.EGLAliasJsfNamesSetting;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.ide.rui.internal.project.CommonUtilities;
import org.eclipse.edt.ide.rui.internal.project.IWidgetLibraryConflict;
import org.eclipse.edt.ide.rui.internal.wizards.RuiNewWizardMessages;
import org.eclipse.edt.ide.rui.wizards.WebClientProjectTemplateWizard;
import org.eclipse.edt.ide.rui.wizards.pages.ColumnLayout;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.project.wizard.pages.ProjectWizardPage;
import org.eclipse.edt.ide.ui.internal.project.wizards.NewEGLProjectWizard;
import org.eclipse.edt.ide.ui.internal.project.wizards.ProjectWizardUtils;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.wizards.EGLWizardUtilities;
import org.eclipse.edt.ide.widgetLibProvider.IWidgetLibProvider;
import org.eclipse.edt.ide.widgetLibProvider.WidgetLibProviderManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class ProjectWizardRUILibraryPage
extends ProjectWizardPage {
    private static final String RUI_WIDGET_LIBRARY_ID = "org.eclipse.edt.rui.widgets_0.7.0";
    public static IStatus OK_STATUS = new Status(0, "org.eclipse.edt.ide.rui", 0, "OK", null);
    private static final String BASE_PACKAGE_HINT = "com.mycompany.myapp";
    private Label basePackageLabel;
    protected Text basePackage;
    private CheckboxTableViewer fTableViewer;
    private Label fDetailLabel;
    private Label fDetailTitleLabel;
    private Label fLogoLabel;
    private HashMap<String, LibraryNode> fLibraryNodes = new HashMap();
    private IWidgetLibProvider[] libProviders;
    private Hashtable libraryImages = new Hashtable();

    public ProjectWizardRUILibraryPage(String pageName) {
        super(pageName);
        this.setTitle(RuiNewWizardMessages.RUILibraryPageTitle);
        this.setDescription(RuiNewWizardMessages.RUILibraryPageDescription);
        this.populateLibraryData();
    }

    public void createContents(Composite ancestor) {
        GridData adata = new GridData(1808);
        ancestor.setLayoutData((Object)adata);
        ancestor.setLayout((Layout)new GridLayout());
        this.createBasePackageEntry(ancestor);
        this.createSelectionTable(ancestor);
        this.createDetailGroup(ancestor);
        this.fTableViewer.getTable().setFocus();
    }

    protected void createBasePackageEntry(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        c.setLayout((Layout)layout);
        this.basePackageLabel = new Label(c, 0);
        this.basePackageLabel.setText(NewWizardMessages.EGLProjectWizardTypePage_BasePackage);
        this.basePackage = new Text(c, 2048);
        this.basePackage.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String name = ((Text)e.widget).getText();
                ((NewEGLProjectWizard)((WebClientProjectTemplateWizard)ProjectWizardRUILibraryPage.this.getWizard()).getParentWizard()).getModel().setBasePackageName(name);
            }
        });
        this.basePackage.setLayoutData((Object)new GridData(768));
        String defaultBasePackageName = ((NewEGLProjectWizard)((WebClientProjectTemplateWizard)this.getWizard()).getParentWizard()).getModel().getBasePackageName();
        if (defaultBasePackageName != null && !defaultBasePackageName.isEmpty()) {
            this.basePackage.setText(defaultBasePackageName);
        }
        this.hookListenerPackageName(this.basePackage);
        new Label(c, 0).setText(NewWizardMessages.EGLProjectWizardTypePage_BasePackage_Example);
        new Label(c, 0).setText(BASE_PACKAGE_HINT);
    }

    private void hookListenerPackageName(Text text) {
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IStatus status = ProjectWizardRUILibraryPage.this.validatePackageName(ProjectWizardRUILibraryPage.this.basePackage.getText());
                if (status != OK_STATUS) {
                    ProjectWizardRUILibraryPage.this.setErrorMessage(status.getMessage());
                } else {
                    ProjectWizardRUILibraryPage.this.setErrorMessage(null);
                }
                ProjectWizardRUILibraryPage.this.getWizard().getContainer().updateButtons();
            }
        });
    }

    public IStatus validatePackageName(String packageName) {
        if (packageName.length() > 0) {
            if (packageName.length() != packageName.trim().length()) {
                return ProjectWizardUtils.createErrorStatus((String)NewWizardMessages.error_basepackage_spaces);
            }
            StatusInfo pkgStatus = new StatusInfo();
            ICompilerOptions compilerOption = new ICompilerOptions(){

                public boolean isVAGCompatible() {
                    return false;
                }

                public boolean isAliasJSFNames() {
                    return EGLAliasJsfNamesSetting.isAliasJsfNames();
                }
            };
            EGLWizardUtilities.NameValidatorProblemRequestor nameValidaRequestor = new EGLWizardUtilities.NameValidatorProblemRequestor(pkgStatus);
            EGLNameValidator.validate((String)packageName, (int)30, (IProblemRequestor)nameValidaRequestor, (ICompilerOptions)compilerOption);
            if (!pkgStatus.isOK()) {
                return ProjectWizardUtils.createErrorStatus((String)pkgStatus.getMessage());
            }
        }
        return OK_STATUS;
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && this.validatePage();
    }

    private boolean validatePage() {
        IStatus status = this.validatePackageName(this.basePackage.getText());
        return status == OK_STATUS;
    }

    private void populateLibraryData() {
        this.libProviders = WidgetLibProviderManager.getInstance().getProviders();
        if (this.libProviders != null) {
            int i = 0;
            while (i < this.libProviders.length) {
                String id = this.libProviders[i].getId();
                String libName = this.libProviders[i].getLibName();
                this.libProviders[i].isSelected();
                String resourcePluginName = this.libProviders[i].getResourcePluginName();
                String resourceFolder = this.libProviders[i].getResourceFolder();
                String projectName = this.libProviders[i].getProjectName();
                if (id != null) {
                    try {
                        URL url = CommonUtilities.getWidgetProjectURL(resourcePluginName, resourceFolder, projectName);
                        if (url != null) {
                            if (!this.fLibraryNodes.containsKey(libName)) {
                                this.fLibraryNodes.put(libName, new LibraryNode(libName));
                            }
                            this.fLibraryNodes.get(libName).addProvider(this.libProviders[i]);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
    }

    private void createSelectionTable(Composite ancestor) {
        Composite tableComposite = new Composite(ancestor, 0);
        GridData data = new GridData(1808);
        data.widthHint = 360;
        tableComposite.setLayoutData((Object)data);
        ColumnLayout columnLayout = new ColumnLayout();
        tableComposite.setLayout((Layout)columnLayout);
        Table table = new Table(tableComposite, 68386);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.fTableViewer = new CheckboxTableViewer(table);
        this.fTableViewer.setComparator((ViewerComparator)new ViewerSorter());
        this.fTableViewer.setContentProvider((IContentProvider)new LibraryContentProvider());
        TableViewerColumn column1 = new TableViewerColumn((TableViewer)this.fTableViewer, new TableColumn(table, 0));
        column1.getColumn().setText(RuiNewWizardMessages.RUILibraryPage_libname_label);
        column1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                LibraryNode insertDataNode = (LibraryNode)element;
                return insertDataNode.getName();
            }
        });
        columnLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(4, 70, true));
        TableViewerColumn column2 = new TableViewerColumn((TableViewer)this.fTableViewer, new TableColumn(table, 0));
        column2.getColumn().setText(RuiNewWizardMessages.RUILibraryPage_version_label);
        column2.setEditingSupport((EditingSupport)new VersionColumnEditingSupport((TableViewer)this.fTableViewer));
        column2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                LibraryNode insertDataNode = (LibraryNode)element;
                return insertDataNode.getVersion();
            }
        });
        columnLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 70, true));
        TableViewerColumn column3 = new TableViewerColumn((TableViewer)this.fTableViewer, new TableColumn(table, 0));
        column3.getColumn().setText(RuiNewWizardMessages.RUILibraryPage_provider_label);
        column3.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                LibraryNode insertDataNode = (LibraryNode)element;
                return insertDataNode.getProvider();
            }
        });
        columnLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 40, true));
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                ProjectWizardRUILibraryPage.this.setDetails();
            }
        });
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                LibraryNode newElement = (LibraryNode)event.getElement();
                if (!event.getChecked() && newElement.getId().equals(ProjectWizardRUILibraryPage.RUI_WIDGET_LIBRARY_ID)) {
                    ProjectWizardRUILibraryPage.this.fTableViewer.setChecked((Object)newElement, true);
                    return;
                }
                ProjectWizardRUILibraryPage.this.setSelectedWidgetLibrary((LibraryNode)event.getElement());
            }
        });
        this.fTableViewer.setInput(new ArrayList<LibraryNode>(this.fLibraryNodes.values()));
        this.fTableViewer.setAllChecked(false);
        this.setSelectedWidgetLibrary();
    }

    private void createDetailGroup(Composite ancestor) {
        Group group = new Group(ancestor, 0);
        group.setText(RuiNewWizardMessages.RUILibraryPage_details_label);
        GridLayout layout = new GridLayout(2, false);
        group.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.horizontalIndent = 0;
        data.heightHint = 150;
        group.setLayoutData((Object)data);
        Composite innerComposite = new Composite((Composite)group, 0);
        data = new GridData(1808);
        innerComposite.setLayoutData((Object)data);
        innerComposite.setLayout((Layout)new FillLayout());
        this.fDetailLabel = new Label(innerComposite, 64);
        this.fLogoLabel = new Label((Composite)group, 0);
        data = new GridData(2);
        this.fLogoLabel.setLayoutData((Object)data);
    }

    private Object[] getSelectedLib() {
        Iterator<LibraryNode> iter = this.fLibraryNodes.values().iterator();
        ArrayList<LibraryNode> nodes = new ArrayList<LibraryNode>();
        while (iter.hasNext()) {
            LibraryNode node = iter.next();
            if (!node.isSelected()) continue;
            nodes.add(node);
        }
        return nodes.toArray(new Object[nodes.size()]);
    }

    public void setProjectName(String projectName) {
        ((NewEGLProjectWizard)((WebClientProjectTemplateWizard)this.getWizard()).getParentWizard()).getModel().setProjectName(projectName);
    }

    private void setSelectedWidgetLibrary() {
        Object[] selectedLib;
        Object[] objectArray = selectedLib = this.getSelectedLib();
        int n = selectedLib.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.fTableViewer.setChecked(element, true);
            if (((LibraryNode)element).getId().equals(RUI_WIDGET_LIBRARY_ID)) {
                this.fTableViewer.setGrayed(element, true);
            }
            this.setSelectedWidgetLibrary((LibraryNode)element);
            ++n2;
        }
    }

    private void setSelectedWidgetLibrary(LibraryNode newElement) {
        Object[] checkElements = this.fTableViewer.getCheckedElements();
        ArrayList<String> selectedWidgetLibraries = new ArrayList<String>();
        Object[] objectArray = checkElements;
        int n = checkElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            LibraryNode node = (LibraryNode)element;
            if (element != newElement && (newElement.isConflict(node.getId()) || node.isConflict(newElement.getId()))) {
                this.fTableViewer.setChecked((Object)newElement, false);
                return;
            }
            selectedWidgetLibraries.add(((LibraryNode)element).getId());
            ++n2;
        }
        ((NewEGLProjectWizard)((WebClientProjectTemplateWizard)this.getWizard()).getParentWizard()).getModel().setSelectedWidgetLibraries(selectedWidgetLibraries);
    }

    private void setDetails() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        if (selection.size() == 1) {
            LibraryNode data = (LibraryNode)selection.getFirstElement();
            this.fDetailLabel.setText(data.getDetail());
            ImageDescriptor logo = data.getLogo();
            if (logo != null) {
                Image image = null;
                if (this.libraryImages.containsKey(data)) {
                    image = (Image)this.libraryImages.get(data);
                } else {
                    image = logo.createImage();
                    this.libraryImages.put(data, image);
                }
                this.fLogoLabel.setImage(image);
            } else {
                this.fLogoLabel.setImage(null);
            }
            this.fLogoLabel.getParent().layout(true);
        } else {
            this.fDetailLabel.setText("");
        }
    }

    public void dispose() {
        try {
            Collection images = this.libraryImages.values();
            for (Image e : images) {
                if (e.isDisposed()) continue;
                e.dispose();
            }
            this.libraryImages.clear();
        }
        catch (Exception exception) {}
        super.dispose();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.fTableViewer.getTable().getItemCount() > 0 && this.fTableViewer.getTable().getSelectionCount() == 0) {
            this.fTableViewer.setSelection((ISelection)new StructuredSelection(this.fTableViewer.getElementAt(0)));
        }
    }

    protected static class LibraryContentProvider
    implements IStructuredContentProvider {
        private ArrayList<LibraryNode> nodes;

        protected LibraryContentProvider() {
        }

        public Object[] getElements(Object input) {
            return this.nodes.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.nodes = (ArrayList)newInput;
        }
    }

    protected static class LibraryNode {
        private String fName;
        private String fVersion;
        private boolean fSelected;
        private HashSet<IWidgetLibProvider> fProviders = new HashSet();

        public LibraryNode(String name) {
            this.fName = name;
            this.fVersion = "";
            this.fSelected = false;
        }

        public boolean isSelected() {
            return this.fSelected;
        }

        protected void setSelected(boolean selected) {
            this.fSelected = selected;
        }

        public void addProvider(IWidgetLibProvider wProvider) {
            if (wProvider.isSelected() || this.fProviders.isEmpty()) {
                this.fVersion = wProvider.getFullVersion();
                this.fSelected = wProvider.isSelected();
            }
            this.fProviders.add(wProvider);
        }

        public String getName() {
            return this.fName;
        }

        public int getVersionSel() {
            String[] versions = this.getVersions();
            int i = 0;
            while (i < versions.length) {
                if (versions[i].equals(this.fVersion)) {
                    return i;
                }
                ++i;
            }
            return 0;
        }

        public void setVersionSel(int index) {
            this.fVersion = this.getVersions()[index];
        }

        public String getVersion() {
            return this.fVersion;
        }

        public void setVersion(String version) {
            this.fVersion = version;
        }

        public String getId() {
            return this.getWProvider().getId();
        }

        public String getProvider() {
            return this.getWProvider().getProvider();
        }

        public String getDetail() {
            return this.getWProvider().getDetail();
        }

        public ImageDescriptor getLogo() {
            return this.getWProvider().getLogo();
        }

        public boolean isConflict(String aLib) {
            IWidgetLibraryConflict conflictClass = this.getWProvider().getConflictClass();
            if (conflictClass != null) {
                return conflictClass.isConflict(aLib);
            }
            return false;
        }

        public String[] getVersions() {
            HashSet<String> versions = new HashSet<String>();
            for (IWidgetLibProvider wProvider : this.fProviders) {
                versions.add(wProvider.getFullVersion());
            }
            return versions.toArray(new String[versions.size()]);
        }

        private IWidgetLibProvider getWProvider() {
            for (IWidgetLibProvider wProvider : this.fProviders) {
                if (!wProvider.getFullVersion().equals(this.getVersion())) continue;
                return wProvider;
            }
            return null;
        }
    }

    private class VersionColumnEditingSupport
    extends EditingSupport {
        private TableViewer viewer;
        private ComboBoxCellEditor comboCellEditor;

        public VersionColumnEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.viewer = viewer;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.comboCellEditor;
        }

        protected boolean canEdit(Object element) {
            LibraryNode insertDataNode = (LibraryNode)element;
            String[] versions = insertDataNode.getVersions();
            this.comboCellEditor = new ComboBoxCellEditor((Composite)this.viewer.getTable(), versions, 8);
            ((CCombo)this.comboCellEditor.getControl()).setVisibleItemCount(10);
            return versions.length > 1;
        }

        protected Object getValue(Object element) {
            return ((LibraryNode)element).getVersionSel();
        }

        protected void setValue(Object element, Object value) {
            ((LibraryNode)element).setVersionSel((Integer)value);
            this.getViewer().update(element, null);
            ProjectWizardRUILibraryPage.this.setSelectedWidgetLibrary((LibraryNode)element);
            ProjectWizardRUILibraryPage.this.setDetails();
        }
    }
}

