/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.binding.FunctionContainerBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.ide.core.internal.search.PartDeclarationInfo;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposal;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLPartSearchProposalHandler;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;

public class EGLFunctionPartSearchProposalHandler
extends EGLPartSearchProposalHandler {
    private boolean referencedFunctions;
    Node functionContainerPart;

    public EGLFunctionPartSearchProposalHandler(ITextViewer viewer, int documentOffset, String prefix, IEditorPart editor, boolean mustHaveReturnCode, Node boundNode) {
        super(viewer, documentOffset, prefix, editor);
        while (!(boundNode instanceof File)) {
            if (boundNode instanceof NestedFunction) {
                this.functionContainerPart = boundNode.getParent();
            }
            boundNode = boundNode.getParent();
        }
        if (this.functionContainerPart != null) {
            IAnnotationBinding aBinding = ((Part)this.functionContainerPart).getName().resolveBinding().getAnnotation(EGLLANG, "includeReferencedFunctions");
            this.referencedFunctions = aBinding != null && Boolean.YES == aBinding.getValue();
        }
    }

    @Override
    protected String getPartType(PartDeclarationInfo part) {
        return "function";
    }

    @Override
    protected EGLCompletionProposal createPartProposal(PartDeclarationInfo partDeclarationInfo, String partTypeName) {
        String packageName = this.getPackageName(partDeclarationInfo);
        String displayString = String.valueOf(partDeclarationInfo.getPartName()) + " - " + packageName;
        String proposalString = this.getProposalString(partDeclarationInfo, false);
        Point selection = this.getFirstParmSelection(proposalString);
        EGLCompletionProposal eglCompletionProposal = new EGLCompletionProposal(this.viewer, String.valueOf(displayString) + " (function)", proposalString, this.getPartReferenceAdditionalInformation(packageName, partDeclarationInfo, partTypeName), this.getDocumentOffset() - this.getPrefix().length(), this.getPrefix().length(), selection.x - 1, 50, selection.y);
        if (partDeclarationInfo.getPackageName().length() > 0) {
            eglCompletionProposal.setImportPackageName(partDeclarationInfo.getPackageName());
            eglCompletionProposal.setImportPartName(partDeclarationInfo.getPartName());
        }
        return eglCompletionProposal;
    }

    @Override
    protected List createProposals(List parts, boolean quoted) {
        ArrayList proposals = new ArrayList();
        if (this.referencedFunctions) {
            proposals.addAll(super.createProposals(parts, quoted));
        }
        proposals.addAll(this.getNestedFunctionProposals());
        return proposals;
    }

    private List getNestedFunctionProposals() {
        ArrayList proposals = new ArrayList();
        if (this.functionContainerPart != null) {
            FunctionContainerBinding pBinding = (FunctionContainerBinding)((Part)this.functionContainerPart).getName().resolveBinding();
            Iterator iter = pBinding.getDeclaredFunctions(true).iterator();
            while (iter.hasNext()) {
                IFunctionBinding fBinding = (IFunctionBinding)((IDataBinding)iter.next()).getType();
                String name = fBinding.getName();
                if (!name.toUpperCase().startsWith(this.getPrefix().toUpperCase())) continue;
                proposals.addAll(this.createFunctionInvocationProposals(fBinding, UINlsStrings.CAProposal_NestedFunction, 50, false));
            }
        }
        return proposals;
    }

    @Override
    protected String getProposalString(PartDeclarationInfo partDeclarationInfo, boolean includePackageName) {
        StringBuffer buffer = new StringBuffer(partDeclarationInfo.getPartName());
        buffer.append("(");
        buffer.append(")");
        return buffer.toString();
    }

    public List getProposals() {
        return super.getProposals(128);
    }
}

